/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.view.menu;

import br.com.linkcom.neo.util.Util;
import br.com.linkcom.neo.view.menu.Menu;
import br.com.linkcom.neo.view.menu.MenuEntityResolver;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MenuParser {
    protected static final String DTD_LOCATION = "br/com/linkcom/neo/view/menu/menu.dtd";
    protected ClassLoader classLoader = this.getClass().getClassLoader();
    protected String urlPrefix;

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    public void setUrlPrefix(String urlPrefix) {
        this.urlPrefix = urlPrefix;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Menu parse(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        if (inputStream == null) {
            throw new NullPointerException("O arquivo de menu n\u00e3o foi encontrado");
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setEntityResolver(new MenuEntityResolver(this.classLoader));
        Document document = documentBuilder.parse(inputStream);
        Element element = document.getDocumentElement();
        String orientation = element.getAttribute("orientation");
        Menu menu = new Menu();
        menu.setOrientation(orientation);
        this.createMenu(element, menu);
        List<Menu> submenus = menu.getSubmenus();
        for (Menu menu2 : submenus) {
            if (!menu2.getIcon().equals("&nbsp;&nbsp;&nbsp;&nbsp;")) continue;
            menu2.setIcon("");
        }
        return menu;
    }

    private void createMenu(Node basenode, Menu basemenu) {
        NodeList childNodes = basenode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeType() == 1) {
                Menu menu = new Menu();
                basemenu.addMenu(menu);
                NamedNodeMap map = node.getAttributes();
                this.fillMenuAttributes(menu, map);
                this.createMenu(node, menu);
            }
            ++i;
        }
    }

    private void fillMenuAttributes(Menu menu, NamedNodeMap map) {
        String icon = map.getNamedItem("icon").getNodeValue();
        String title = map.getNamedItem("title").getNodeValue();
        String bundleKey = Util.locale.getBundleKey("menu." + title);
        if (bundleKey != null) {
            title = bundleKey;
        }
        String url = map.getNamedItem("url").getNodeValue();
        String target = map.getNamedItem("target").getNodeValue();
        String description = map.getNamedItem("description").getNodeValue();
        icon = icon.equals("") ? "&nbsp;&nbsp;&nbsp;&nbsp;" : "<img src=\"" + icon + "\" align=\"absmiddle\">";
        menu.setIcon(icon);
        menu.setTitle(title);
        if (this.urlPrefix != null && url != null && !url.equals("") && !url.startsWith("javascript:")) {
            url = String.valueOf(this.urlPrefix) + url;
        }
        menu.setUrl(url);
        menu.setTarget(target);
        menu.setDescription(description);
    }
}

