/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.view.menu;

import br.com.linkcom.neo.view.menu.Menu;
import java.util.Iterator;

public class MenuBuilder {
    private int identation;

    public String build(Menu menu) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[').append('\n');
        this.identation = 1;
        Iterator<Menu> iter = menu.getSubmenus().iterator();
        while (iter.hasNext()) {
            Menu submenu = iter.next();
            this.build(submenu, stringBuilder, iter.hasNext());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private void build(Menu menu, StringBuilder stringBuilder, boolean hasNext) {
        this.ident(stringBuilder);
        if (menu.getTitle() != null && menu.getTitle().matches("--(-)+")) {
            stringBuilder.append("_cmSplit");
            if (hasNext) {
                stringBuilder.append(',');
            }
            return;
        }
        this.openMenu(stringBuilder);
        this.printItem(menu.getIcon(), stringBuilder);
        stringBuilder.append(',');
        this.printItem(menu.getTitle(), stringBuilder);
        stringBuilder.append(',');
        String url = menu.getUrl();
        this.printItem(url, stringBuilder);
        stringBuilder.append(',');
        this.printItem(menu.getTarget(), stringBuilder);
        stringBuilder.append(',');
        this.printItem(menu.getDescription(), stringBuilder);
        if (menu.containSubMenus()) {
            stringBuilder.append(',').append('\n');
            ++this.identation;
            Iterator<Menu> iter = menu.getSubmenus().iterator();
            while (iter.hasNext()) {
                Menu submenu = iter.next();
                this.build(submenu, stringBuilder, iter.hasNext());
            }
            --this.identation;
            this.ident(stringBuilder);
            this.closeMenu(stringBuilder, hasNext);
        } else {
            this.closeMenu(stringBuilder, hasNext);
        }
    }

    private void closeMenu(StringBuilder stringBuilder, boolean hasNext) {
        stringBuilder.append(']');
        if (hasNext) {
            stringBuilder.append(',');
        }
        stringBuilder.append('\n');
    }

    private void printItem(String texto, StringBuilder stringBuilder) {
        stringBuilder.append('\'');
        stringBuilder.append(texto);
        stringBuilder.append('\'');
    }

    private void openMenu(StringBuilder stringBuilder) {
        stringBuilder.append('[');
    }

    private void ident(StringBuilder stringBuilder) {
        int i = 0;
        while (i < this.identation) {
            stringBuilder.append("    ");
            ++i;
        }
    }
}

