/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.view.ajax;

import br.com.linkcom.neo.bean.PropertyDescriptor;
import br.com.linkcom.neo.controller.ServletRequestDataBinderNeo;
import br.com.linkcom.neo.core.standard.Neo;
import br.com.linkcom.neo.core.web.NeoWeb;
import br.com.linkcom.neo.persistence.GenericDAO;
import br.com.linkcom.neo.util.Util;
import br.com.linkcom.neo.view.ajax.AjaxCallback;
import br.com.linkcom.neo.view.ajax.CallbackFunctionRegistration;
import br.com.linkcom.neo.view.ajax.ComboFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.validation.BindException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboCallback
implements AjaxCallback {
    @Override
    public void doAjax(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ComboFilter comboFilter = new ComboFilter();
        ServletRequestDataBinderNeo dataBinder = new ServletRequestDataBinderNeo(comboFilter, "comboFilter");
        dataBinder.bind((ServletRequest)request);
        BindException errors = dataBinder.getErrors();
        if (errors.hasErrors()) {
            response.getWriter().println("var lista = [];");
            List allErrors = errors.getAllErrors();
            StringBuilder builder = new StringBuilder();
            for (Object object : allErrors) {
                builder.append(object.toString().replace("'", "\\'"));
                builder.append("\\n");
            }
            response.getWriter().println("alert('" + builder.toString() + "');");
        } else if (Util.strings.isEmpty(comboFilter.getLoadFunction())) {
            String[] stringArray;
            Class type = comboFilter.getType();
            if (type == null) {
                throw new RuntimeException("tipo nulo");
            }
            String simpleName = type.getSimpleName();
            if (!ComboCallback.isRegistered(simpleName, "findBy", new Class[0])) {
                throw new RuntimeException("N\u00e3o registrado para fazer a chamada. " + simpleName + ".findBy");
            }
            String daoName = String.valueOf(Util.strings.uncaptalize(simpleName)) + "DAO";
            DefaultListableBeanFactory defaultListableBeanFactory = Neo.getApplicationContext().getConfig().getDefaultListableBeanFactory();
            GenericDAO service = (GenericDAO)((Object)defaultListableBeanFactory.getBean(daoName));
            if (Util.strings.isEmpty(comboFilter.getLabel())) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = comboFilter.getLabel();
            }
            String[] label = stringArray;
            List lista = service.findBy(comboFilter.getParentValue(), true, label);
            String listaAttr = this.convertToJavaScript(lista, comboFilter.getLabel());
            response.getWriter().println(listaAttr);
        } else {
            String loadFunction = comboFilter.getLoadFunction();
            if (loadFunction.matches("\\w*\\.\\w*(\\(.*?\\))?")) {
                String[] loadFunctionSplit = loadFunction.split("\\.");
                String beanName = loadFunctionSplit[0];
                String function = loadFunctionSplit[1];
                Class[] paramClasses = comboFilter.getClasses();
                Object[] values = comboFilter.getValues(paramClasses);
                if (function.contains("(")) {
                    function = function.substring(0, function.indexOf(40));
                } else {
                    paramClasses = new Class[]{comboFilter.getParentValue().getClass()};
                    values = new Object[]{comboFilter.getParentValue()};
                }
                Object bean = Neo.getApplicationContext().getConfig().getDefaultListableBeanFactory().getBean(beanName);
                if (bean == null) {
                    throw new RuntimeException("nenhum bean encontrado com o nome " + beanName);
                }
                try {
                    if (!ComboCallback.isRegistered(beanName, function, paramClasses)) {
                        throw new RuntimeException("N\u00e3o registrado para fazer a chamada. " + beanName + "." + function);
                    }
                    Object lista = Util.objects.findAndInvokeMethod(bean, function, values, paramClasses);
                    if (!(lista instanceof List)) {
                        throw new RuntimeException("O retorno do m\u00e9todo " + loadFunction + " n\u00e3o foi uma lista");
                    }
                    String listaAttr = this.convertToJavaScript((List)lista, comboFilter.getLabel());
                    response.getWriter().println(listaAttr);
                }
                catch (Exception e) {
                    throw new RuntimeException("Erro ao executar " + function, e);
                }
            } else {
                throw new RuntimeException("Fun\u00e7\u00e3o inv\u00e1lida: " + loadFunction);
            }
        }
    }

    private String convertToJavaScript(List<?> lista, String label) {
        StringBuilder javascript = new StringBuilder();
        javascript.append("var lista = [");
        Iterator<?> iter = lista.iterator();
        while (iter.hasNext()) {
            String description;
            Object element = iter.next();
            if (Util.strings.isEmpty(label)) {
                description = Util.strings.toStringDescription(element);
            } else {
                PropertyDescriptor propertyDescriptor = Neo.getApplicationContext().getBeanDescriptor(element).getPropertyDescriptor(label);
                description = Util.strings.toStringDescription(propertyDescriptor.getValue());
            }
            description = this.escapeSingleQuotes(description);
            String id = Util.strings.toStringIdStyled(element);
            javascript.append("['" + id + "', '" + description + "']");
            if (!iter.hasNext()) continue;
            javascript.append(",");
        }
        javascript.append("];");
        return javascript.toString();
    }

    private String escapeSingleQuotes(String message) {
        return message.replace("'", "\\'").replace("\n", " ").replace("\r", " ");
    }

    public static boolean isRegistered(String object, String functionName, Class[] classes) {
        Set<CallbackFunctionRegistration> set = ComboCallback.getCallbackRegistrationList();
        return set.contains(new CallbackFunctionRegistration(object, functionName, classes));
    }

    public static void register(String object, String functionName, Class[] classes) {
        Set<CallbackFunctionRegistration> set = ComboCallback.getCallbackRegistrationList();
        set.add(new CallbackFunctionRegistration(object, functionName, classes));
    }

    private static Set<CallbackFunctionRegistration> getCallbackRegistrationList() {
        HttpSession session = NeoWeb.getRequestContext().getSession();
        HashSet attribute = (HashSet)session.getAttribute("CallbackFunctionRegistration");
        if (attribute == null) {
            attribute = new HashSet();
            session.setAttribute("CallbackFunctionRegistration", attribute);
        }
        return attribute;
    }
}

