/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.view;

import br.com.linkcom.neo.util.Util;
import br.com.linkcom.neo.view.AcceptPanelRenderedBlock;
import br.com.linkcom.neo.view.BaseTag;
import br.com.linkcom.neo.view.FormTag;
import br.com.linkcom.neo.view.PanelRenderedBlock;
import br.com.linkcom.neo.view.TabPanelBlock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabPanelTag
extends BaseTag
implements AcceptPanelRenderedBlock {
    protected List<PanelRenderedBlock> blocks = new ArrayList<PanelRenderedBlock>();
    protected String onSelectTab = null;
    protected Boolean renderScript = true;

    @Override
    protected void doComponent() throws Exception {
        String index;
        this.doBody();
        String idTabPanel = this.id != null ? this.id : this.generateUniqueId();
        int currentPanel = 0;
        ArrayList<TabPanelBlock> tabBlocks = new ArrayList<TabPanelBlock>();
        for (PanelRenderedBlock block : this.blocks) {
            tabBlocks.add(new TabPanelBlock(block, idTabPanel, currentPanel++));
        }
        int selectedIndex = 0;
        if (this.id != null && (index = this.getRequest().getParameter("TABPANEL_" + this.id)) != null) {
            selectedIndex = Integer.parseInt(index);
        }
        if (this.renderScript.booleanValue()) {
            this.renderScript(idTabPanel, tabBlocks, selectedIndex);
        }
        this.renderSelectArea(idTabPanel, tabBlocks, selectedIndex);
        this.renderPanels(idTabPanel, tabBlocks, selectedIndex);
    }

    private void renderPanels(String idTabPanel, List<TabPanelBlock> tabBlocks, int selectedIndex) throws IOException {
        int index = 0;
        if (tabBlocks.size() == 1) {
            this.getOut().println(tabBlocks.get(0).getBody());
        } else {
            for (TabPanelBlock block : tabBlocks) {
                if (index == selectedIndex) {
                    this.getOut().print("<div style=\"width: 100%; \" id=\"" + block.getId() + "\">");
                } else {
                    this.getOut().print("<div style=\"width: 100%; display: none;\" id=\"" + block.getId() + "\">");
                }
                this.getOut().println(block.getBody());
                this.getOut().print("</div>");
                ++index;
            }
        }
    }

    private void renderSelectArea(String idTabPanel, List<TabPanelBlock> tabBlocks, int selectedIndex) throws IOException {
        int index = 0;
        if (tabBlocks.size() > 1) {
            this.getOut().print("<div class=\"tabPanelLink\">");
            int i = 0;
            while (i < tabBlocks.size()) {
                TabPanelBlock block = tabBlocks.get(i);
                String className = i == selectedIndex ? "detailTabSelected" : "detailTabUnselected";
                String linkId = this.createLinkId(idTabPanel, i);
                this.getOut().print("<a href=\"javascript:show" + idTabPanel + "('" + block.getId() + "', " + index + ", '" + linkId + "'); " + this.escape(block.getOnSelectTab()) + "\" class=\"" + className + "\" id=\"" + linkId + "\">" + block.getTitle() + "</a> ");
                ++index;
                ++i;
            }
            this.getOut().print("</div>");
        }
    }

    private String createLinkId(String idTabPanel, int i) {
        return String.valueOf(idTabPanel) + "_link_" + i;
    }

    private void renderScript(String idTabPanel, List<TabPanelBlock> tabBlocks, int selectedIndex) throws IOException {
        if (tabBlocks.size() <= 1) {
            return;
        }
        if (this.id != null) {
            this.getOut().println("<input type=\"hidden\" name=\"TABPANEL_" + idTabPanel + "\" value=\"" + selectedIndex + "\"/>");
        }
        FormTag form = this.findParent(FormTag.class);
        this.getOut().println("<script language=\"javascript\">");
        this.getOut().println("    function show" + idTabPanel + "(panel, index, linkid) {");
        int i = 0;
        while (i < tabBlocks.size()) {
            TabPanelBlock block = tabBlocks.get(i);
            String linkId = this.createLinkId(idTabPanel, i);
            this.getOut().println("        hide" + idTabPanel + "('" + block.getId() + "')");
            this.getOut().println("        unselect" + idTabPanel + "('" + block.getId() + "', '" + linkId + "')");
            ++i;
        }
        this.getOut().println("        document.getElementById(panel).style.display = '';");
        this.getOut().println("        select" + idTabPanel + "(panel, index, linkid);");
        this.getOut().println("    }");
        this.getOut().println("    function hide" + idTabPanel + "(panel) {");
        this.getOut().println("        document.getElementById(panel).style.display = 'none';");
        this.getOut().println("    }");
        this.getOut().println("    function select" + idTabPanel + "(panel, index, linkid) {");
        if (form != null && this.id != null) {
            this.getOut().println("        " + form.getName() + ".TABPANEL_" + idTabPanel + ".value = index;");
        }
        this.getOut().println("        " + this.generateScriptOnSelectTab(idTabPanel));
        this.getOut().println("        document.getElementById(linkid).className = 'detailTabSelected';");
        this.getOut().println("    }");
        this.getOut().println("    function unselect" + idTabPanel + "(panel, linkid) {");
        this.getOut().println("        document.getElementById(linkid).className = 'detailTabUnselected';");
        this.getOut().println("    }");
        this.getOut().println("</script>");
    }

    private String generateScriptOnSelectTab(String idTabPanel) {
        if (Util.strings.isNotEmpty(idTabPanel) && Util.strings.isNotEmpty(this.onSelectTab)) {
            return String.valueOf(this.onSelectTab) + "('" + idTabPanel + "',index);";
        }
        return "";
    }

    @Override
    public boolean addBlock(PanelRenderedBlock o) {
        return this.blocks.add(o);
    }

    public String getOnSelectTab() {
        return this.onSelectTab;
    }

    public Boolean getRenderScript() {
        return this.renderScript;
    }

    public void setOnSelectTab(String onSelectTab) {
        this.onSelectTab = onSelectTab;
    }

    public void setRenderScript(Boolean renderScript) {
        this.renderScript = renderScript;
    }
}

