/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.view;

import br.com.linkcom.neo.controller.resource.Resource;
import br.com.linkcom.neo.view.ResourceUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ResourceServlet
extends HttpServlet {
    private static final String RESOURCE_LASTMOD = "RESOURCE_LASTMOD";
    public static final String RESOURCE = "resource";
    private static final long serialVersionUID = 1L;
    protected Map<String, String> map = new HashMap<String, String>();

    public ResourceServlet() {
        this.map.put("js/validation", "br/com/linkcom/neo/resource");
        this.map.put("js/inputs", "br/com/linkcom/neo/resource");
        this.map.put("js/ajax", "br/com/linkcom/neo/resource");
        this.map.put("js/util", "br/com/linkcom/neo/resource");
        this.map.put("js", "br/com/linkcom/neo/resource");
        this.map.put("menu", "br/com/linkcom/neo/resource/menu");
        this.map.put("htmlarea", "br/com/linkcom/neo/resource/htmlarea");
        this.map.put("css", "br/com/linkcom/neo/resource");
        this.map.put("img", "br/com/linkcom/neo/resource/imgs");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String tipo;
        String requestResource = this.getRequestedResource(request);
        int indexOfFile = requestResource.lastIndexOf(47);
        String file = null;
        if (indexOfFile < 0) {
            tipo = requestResource;
        } else {
            tipo = requestResource.substring(0, indexOfFile);
            file = requestResource.substring(indexOfFile);
        }
        if (tipo.equals(RESOURCE)) {
            Integer id;
            HttpSession session = request.getSession();
            Resource recurso = ResourceUtil.get(session, id = new Integer(request.getParameter("id")));
            if (recurso != null) {
                response.setContentType(recurso.getContentType());
                response.setHeader("Content-Disposition", "attachment; filename=\"" + recurso.getFileName() + "\";");
                response.getOutputStream().write(recurso.getContents());
            }
        } else {
            String basePath = this.map.get(tipo);
            if (basePath == null) {
                response.sendError(404);
            }
            String resourcePath = String.valueOf(basePath) + file;
            boolean useLastModified = true;
            InputStream inputStream = null;
            try {
                inputStream = request.getSession().getServletContext().getResourceAsStream("/WEB-INF/classes/" + resourcePath);
                if (inputStream == null) {
                    useLastModified = true;
                    inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resourcePath);
                }
                if (inputStream != null) {
                    if (useLastModified && request.getSession().getServletContext().getAttribute(RESOURCE_LASTMOD + resourcePath) == null) {
                        request.getSession().getServletContext().setAttribute(RESOURCE_LASTMOD + resourcePath, (Object)System.currentTimeMillis());
                    }
                    BufferedInputStream in = new BufferedInputStream(inputStream);
                    Object out = response.getOutputStream();
                    String ae = request.getHeader("accept-encoding");
                    if (ae != null && ae.indexOf("gzip") != -1 && (requestResource.endsWith("js") || requestResource.endsWith("css"))) {
                        response.addHeader("Content-Encoding", "gzip");
                        out = new GZIPOutputStream((OutputStream)out);
                    }
                    int b = 0;
                    while ((b = ((InputStream)in).read()) != -1) {
                        out.write(b);
                    }
                    if (out instanceof GZIPOutputStream) {
                        ((GZIPOutputStream)out).finish();
                    }
                    out.flush();
                } else {
                    response.sendError(404);
                }
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String getRequestedResource(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        requestURI = requestURI.replace("//", "/");
        String servletPath = request.getServletPath();
        int s = requestURI.indexOf(servletPath) + servletPath.length() + 1;
        String requestResource = requestURI.substring(s);
        return requestResource;
    }

    protected long getLastModified(HttpServletRequest request) {
        String basePath;
        String tipo;
        String requestResource = this.getRequestedResource(request);
        int indexOfFile = requestResource.lastIndexOf(47);
        String file = null;
        if (indexOfFile < 0) {
            tipo = requestResource;
        } else {
            tipo = requestResource.substring(0, indexOfFile);
            file = requestResource.substring(indexOfFile);
        }
        if (!tipo.equals(RESOURCE) && (basePath = this.map.get(tipo)) != null) {
            String resourcePath = String.valueOf(basePath) + file;
            Object last = request.getSession().getServletContext().getAttribute(RESOURCE_LASTMOD + resourcePath);
            if (last != null) {
                return (Long)last;
            }
        }
        return -1L;
    }
}

