/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.view;

import br.com.linkcom.neo.bean.BeanDescriptor;
import br.com.linkcom.neo.controller.Message;
import br.com.linkcom.neo.core.web.NeoWeb;
import br.com.linkcom.neo.core.web.WebRequestContext;
import br.com.linkcom.neo.exception.UsefullNeoException;
import br.com.linkcom.neo.util.Util;
import br.com.linkcom.neo.view.BaseTag;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagesTag
extends BaseTag {
    Set<String> printedErrors = new HashSet<String>();
    protected String titleClass = "messagetitle";
    protected String itemClass = "messageitem";
    protected String exceptionClass = "exceptionitem";
    protected String exceptionCauseClass = "causeitem";
    protected String fieldName = "fieldname";
    protected String bindErrorClass = "binderror";
    protected String validationErrorClass = "validationerror";
    protected String globalErrorclass = "globalerror";
    protected String debugClass = "debug";
    protected String traceClass = "trace";
    protected String infoClass = "info";
    protected String warnClass = "warn";
    protected String errorClass = "error";

    @Override
    protected void doComponent() throws Exception {
        WebRequestContext requestContext = NeoWeb.getRequestContext();
        Message[] messages = requestContext.getMessages();
        BindException errors = requestContext.getBindException();
        if (errors.hasErrors() && !"true".equalsIgnoreCase(this.getRequest().getParameter("suppressErrors"))) {
            List allErrors;
            this.getOut().println("<div class='bindblock' id='messageBlock'>");
            if (Util.config.getDefaultConfigBoolean(true, "showValidationMessageTitle")) {
                this.getOut().println("<span class=\"" + this.titleClass + "\">Valores incorretos encontrados em '" + errors.getObjectName() + "'.</span>");
            }
            if (errors.getGlobalErrorCount() > 0) {
                this.getOut().println("<ul>");
                List globalErrors = errors.getGlobalErrors();
                for (Object object : globalErrors) {
                    this.getOut().println("<li class=\"" + this.globalErrorclass + "\">" + ((ObjectError)object).getDefaultMessage() + "</li>");
                }
                this.getOut().println("</ul>");
            }
            if ((allErrors = errors.getAllErrors()).size() > 0) {
                this.getOut().println("<ul>");
                for (Object object : allErrors) {
                    if (!(object instanceof FieldError)) continue;
                    FieldError fieldError = (FieldError)object;
                    BeanDescriptor<Object> beanDescriptor = NeoWeb.getApplicationContext().getBeanDescriptor(errors.getTarget());
                    String field = fieldError.getField();
                    field = beanDescriptor.getPropertyDescriptor(field).getDisplayName();
                    if (fieldError.isBindingFailure()) {
                        this.getOut().println("<li class=\"" + this.bindErrorClass + "\"> <span class=\"" + this.fieldName + "\">" + field + "</span> " + fieldError.getDefaultMessage() + "</li>");
                        continue;
                    }
                    this.getOut().println("<li class=\"" + this.validationErrorClass + "\"> <span class=\"" + this.fieldName + "\">" + field + "</span> " + fieldError.getDefaultMessage() + "</li>");
                }
                this.getOut().println("</ul>");
            }
            this.getOut().println("</div>");
        }
        if (messages.length > 0) {
            errors.hasErrors();
            this.getOut().println("<div class='messageblock' id='messageBlock'>");
            this.getOut().println("<ul>");
            Message[] messageArray = messages;
            int n = messages.length;
            int n2 = 0;
            while (n2 < n) {
                Message message = messageArray[n2];
                String clazz = "";
                switch (message.getType()) {
                    case DEBUG: {
                        clazz = this.debugClass;
                        break;
                    }
                    case TRACE: {
                        clazz = this.traceClass;
                        break;
                    }
                    case INFO: {
                        clazz = this.infoClass;
                        break;
                    }
                    case WARN: {
                        clazz = this.warnClass;
                        break;
                    }
                    case ERROR: {
                        clazz = this.errorClass;
                    }
                }
                this.renderItem(message.getSource(), clazz);
                ++n2;
            }
            this.getOut().println("</ul>");
            this.getOut().println("</div>");
            this.getOut().println("<script language='javascript'>function clearMessages(){document.getElementById('messageBlock').style.display = 'none';}</script>");
        }
        requestContext.clearMessages();
    }

    private void renderItem(Object source, String clazz) throws IOException {
        String convertToMessage;
        if (source != null && Util.strings.isNotEmpty(convertToMessage = this.convertToMessage(source))) {
            this.getOut().println("<li class=\"" + clazz + "\">" + convertToMessage + "</li>");
        }
    }

    protected String convertToMessage(Object source) {
        if (source instanceof String) {
            return source.toString();
        }
        if (source instanceof Exception) {
            String message;
            Exception exception = (Exception)source;
            StringBuilder builder = new StringBuilder();
            this.getResumedStack(exception, true);
            if (exception instanceof DataAccessException) {
                if (exception instanceof DataIntegrityViolationException) {
                    builder.append("<span class=\"" + this.exceptionClass + "\">Integridade de dados violada</span>");
                    message = exception.getMessage();
                    this.printedErrors.add(message);
                    builder.append("<ul><li><span class=\"" + this.exceptionCauseClass + "\">" + message + "</span></li></ul>");
                } else if (exception instanceof DataRetrievalFailureException) {
                    builder.append("<span class=\"" + this.exceptionClass + "\">Erro ao ler dados</span>");
                    message = exception.getMessage();
                    this.printedErrors.add(message);
                    builder.append("<ul><li><span class=\"" + this.exceptionCauseClass + "\">" + message + "</span></li></ul>");
                } else if (exception instanceof ConcurrencyFailureException) {
                    builder.append("<span class=\"" + this.exceptionClass + "\">Problema com uso concorrente de dados</span>");
                    message = exception.getMessage();
                    this.printedErrors.add(message);
                    builder.append("<ul><li><span class=\"" + this.exceptionCauseClass + "\">" + message + "</span></li></ul>");
                } else {
                    message = exception.getMessage();
                    this.printedErrors.add(message);
                    builder.append("<span class=\"" + this.exceptionClass + "\">" + message + "</span>");
                }
            } else if (exception instanceof UsefullNeoException) {
                message = exception.getMessage();
                this.printedErrors.add(message);
                builder.append("<span class=\"" + this.exceptionClass + "\">" + message + "</span>");
            } else if (exception.getClass().getName().startsWith("java.lang")) {
                message = exception.getMessage();
                this.printedErrors.add(message);
                builder.append("<span class=\"" + this.exceptionClass + "\"> " + exception.getClass().getSimpleName() + ": " + message + "</span>");
            } else {
                message = exception.getMessage();
                this.printedErrors.add(message);
                builder.append("<span class=\"" + this.exceptionClass + "\">" + message + "</span>");
            }
            Throwable cause = exception;
            boolean first = true;
            while ((cause = cause.getCause()) != null) {
                String message2;
                if (first) {
                    this.getResumedStack(cause, true);
                    first = false;
                }
                if (cause instanceof DataAccessException) {
                    if (cause instanceof DataIntegrityViolationException) {
                        builder.append("<ul><li class=\"" + this.exceptionCauseClass + "\"><b>Integridade de dados violada</b></li></ul>");
                    }
                    if (cause instanceof DataRetrievalFailureException) {
                        builder.append("<ul><li class=\"" + this.exceptionCauseClass + "\"><b>Erro ao ler dados</b></li></ul>");
                    }
                    if (cause instanceof ConcurrencyFailureException) {
                        builder.append("<ul><li class=\"" + this.exceptionCauseClass + "\"><b>Problema com uso concorrente de dados</b></li></ul>");
                    }
                }
                if (cause instanceof SQLException) {
                    String message3;
                    SQLException exception2 = (SQLException)cause;
                    if (exception2.getNextException() != null) {
                        message3 = cause.getMessage();
                        String message22 = exception2.getNextException().getMessage();
                        if (!this.printedErrors.contains(message3)) {
                            this.printedErrors.add(message3);
                            builder.append("<ul><li class=\"" + this.exceptionCauseClass + "\">" + message3 + "</li></ul>");
                        }
                        if (this.printedErrors.contains(message22)) continue;
                        this.printedErrors.add(message22);
                        builder.append("<ul><li class=\"" + this.exceptionCauseClass + "\"><b>" + message22 + "</b></li></ul>");
                        continue;
                    }
                    if (cause.getCause() == null) {
                        message3 = cause.getMessage();
                        if (this.printedErrors.contains(message3)) continue;
                        this.printedErrors.add(message3);
                        builder.append("<ul><li class=\"" + this.exceptionCauseClass + "\"><b>" + message3 + "</b></li></ul>");
                        continue;
                    }
                    message3 = cause.getMessage();
                    if (this.printedErrors.contains(message3)) continue;
                    this.printedErrors.add(message3);
                    builder.append("<ul><li class=\"" + this.exceptionCauseClass + "\">" + message3 + "</li></ul>");
                    continue;
                }
                if (cause instanceof UsefullNeoException) {
                    message2 = cause.getMessage();
                    if (this.printedErrors.contains(message2)) continue;
                    this.printedErrors.add(message2);
                    builder.append("<ul><li class=\"" + this.exceptionCauseClass + "\"><b>" + message2.replaceAll("\n", "<BR>") + "</b></li></ul>");
                    continue;
                }
                if (cause.getClass().getName().startsWith("java.lang")) {
                    message2 = cause.getMessage();
                    if (this.printedErrors.contains(message2) && message2 != null) continue;
                    this.printedErrors.add(message2);
                    builder.append("<ul><li class=\"" + this.exceptionCauseClass + "\"><b>" + cause.getClass().getSimpleName() + ": " + message2 + "</b></li></ul>");
                    continue;
                }
                message2 = cause.getMessage();
                if (this.printedErrors.contains(message2)) continue;
                this.printedErrors.add(message2);
                builder.append("<ul><li class=\"" + this.exceptionCauseClass + "\">" + message2 + "</li></ul>");
            }
            return builder.toString();
        }
        return source.toString();
    }

    private void printApplicationStack(StringBuilder builder, Throwable cause) {
        List<StackTraceElement> elementsToPrint = this.getResumedStack(cause, false);
        builder.append("<ul> ");
        for (StackTraceElement element : elementsToPrint) {
            builder.append("<ul><li class=\"" + this.exceptionCauseClass + "\">" + element + "</li></ul>");
        }
        builder.append("</ul>");
    }

    private List<StackTraceElement> getResumedStack(Throwable cause, boolean printResume) {
        ArrayList<StackTraceElement> elementsToPrint = new ArrayList<StackTraceElement>();
        StackTraceElement[] stackTrace = cause.getStackTrace();
        ArrayList<String> fromClasses = new ArrayList<String>();
        int i = stackTrace.length - 1;
        while (i >= 0) {
            StackTraceElement element = stackTrace[i];
            if (!(element.getClassName().startsWith("br.com.linkcom.neo") || element.getClassName().startsWith("org.apache") || element.getClassName().startsWith("org.jboss") || element.getClassName().startsWith("java") || element.getClassName().startsWith("org.springframework") || element.getClassName().startsWith("sun") || element.getClassName().startsWith("org.hibernate") || element.getClassName().startsWith("net.sf"))) {
                if (fromClasses.contains(element.getClassName())) {
                    int indexOf = fromClasses.indexOf(element.getClassName());
                    fromClasses.remove(indexOf);
                    elementsToPrint.remove(indexOf);
                }
                elementsToPrint.add(element);
                fromClasses.add(element.getClassName());
            }
            --i;
        }
        if (printResume) {
            StackTraceElement[] last = cause.getStackTrace();
            Throwable exception = cause;
            StackTraceElement[] toArray = elementsToPrint.toArray(new StackTraceElement[elementsToPrint.size()]);
            exception.setStackTrace(toArray);
            for (StackTraceElement element : elementsToPrint) {
                this.log.error((Object)("Stack Resumido:\n\n\t" + element));
            }
            exception.setStackTrace(last);
        }
        return elementsToPrint;
    }

    public String getBindErrorClass() {
        return this.bindErrorClass;
    }

    public String getDebugClass() {
        return this.debugClass;
    }

    public String getErrorClass() {
        return this.errorClass;
    }

    public String getGlobalErrorclass() {
        return this.globalErrorclass;
    }

    public String getInfoClass() {
        return this.infoClass;
    }

    public String getTraceClass() {
        return this.traceClass;
    }

    public String getValidationErrorClass() {
        return this.validationErrorClass;
    }

    public String getWarnClass() {
        return this.warnClass;
    }

    public void setBindErrorClass(String bindErrorClass) {
        this.bindErrorClass = bindErrorClass;
    }

    public void setDebugClass(String debugClass) {
        this.debugClass = debugClass;
    }

    public void setErrorClass(String errorClass) {
        this.errorClass = errorClass;
    }

    public void setGlobalErrorclass(String globalErrorclass) {
        this.globalErrorclass = globalErrorclass;
    }

    public void setInfoClass(String infoClass) {
        this.infoClass = infoClass;
    }

    public void setTraceClass(String traceClass) {
        this.traceClass = traceClass;
    }

    public void setValidationErrorClass(String validationErrorClass) {
        this.validationErrorClass = validationErrorClass;
    }

    public void setWarnClass(String warnClass) {
        this.warnClass = warnClass;
    }
}

