/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.view;

import br.com.linkcom.neo.core.standard.Neo;
import br.com.linkcom.neo.exception.NeoException;
import br.com.linkcom.neo.util.Util;
import br.com.linkcom.neo.view.BaseTag;
import br.com.linkcom.neo.view.DataGridTag;
import br.com.linkcom.neo.view.template.PropertyConfigTag;

public class LinkTag
extends BaseTag {
    protected String confirmationMessage;
    protected String url;
    protected String action;
    protected String img;
    protected String description;
    protected String type;
    protected String parameters;
    private String onclick;

    protected void doComponent() throws Exception {
        boolean hasAuthorization = this.hasAuthorization();
        this.url = this.montarUrlCompleta();
        if (!hasAuthorization) {
            this.getOut().println("<!-- Sem autoriza\u00e7\u00e3o para acessar: " + this.url + "-->");
            return;
        }
        Tipo tipo = this.definirTipo();
        if (tipo == Tipo.BUTTON) {
            boolean disabled = "disabled".equals(this.getDynamicAttributesMap().get("disabled"));
            boolean enabled = "false".equals(this.getDynamicAttributesMap().get("disabled"));
            if (!enabled) {
                PropertyConfigTag propertyConfig = this.findParent(PropertyConfigTag.class);
                DataGridTag dataGridTag = this.findParent(DataGridTag.class);
                if (propertyConfig != null && Boolean.TRUE.equals(propertyConfig.getDisabled()) && (dataGridTag == null || dataGridTag.getCurrentStatus() != DataGridTag.Status.DYNALINE)) {
                    if (disabled) {
                        this.getDynamicAttributesMap().put("originaldisabled", "disabled");
                    }
                    this.getDynamicAttributesMap().put("disabled", "disabled");
                }
            } else {
                this.getDynamicAttributesMap().remove("disabled");
            }
        }
        switch (tipo) {
            case IMAGE: {
                this.includeTextTemplate("image");
                break;
            }
            case BUTTON: {
                this.url = this.url.startsWith("javascript:") ? this.url.substring("javascript:".length()) : "window.location='" + this.url + "'";
                this.includeTextTemplate("button");
                break;
            }
            case LINK: {
                this.includeTextTemplate("link");
            }
        }
    }

    private boolean hasAuthorization() {
        try {
            String partialURL = this.getPartialURL();
            if (partialURL.contains("?")) {
                partialURL = partialURL.substring(0, partialURL.indexOf(63));
            }
            return Neo.getApplicationContext().getAuthorizationManager().isAuthorized(partialURL, this.action, Neo.getRequestContext().getUser());
        }
        catch (Exception e) {
            throw new NeoException("Problema ao verificar autoriza\u00e7\u00e3o", e);
        }
    }

    private String getPartialURL() {
        if (this.url != null && this.url.startsWith(this.getRequest().getContextPath())) {
            return this.url.substring(this.getRequest().getContextPath().length());
        }
        String fullUrl = this.url == null ? Util.web.getFirstUrl() : (this.url.startsWith("/") ? this.url : this.url);
        return fullUrl;
    }

    private Tipo definirTipo() {
        Tipo tipo = Tipo.LINK;
        if ("button".equalsIgnoreCase(this.type)) {
            tipo = Tipo.BUTTON;
        }
        if (this.img != null) {
            tipo = Tipo.IMAGE;
        }
        return tipo;
    }

    private String montarUrlCompleta() {
        String separator;
        if (this.url != null && this.url.startsWith("javascript:")) {
            return this.url;
        }
        if (this.action != null && this.action.startsWith("javascript:")) {
            this.url = this.action;
            this.action = null;
            return this.url;
        }
        String fullUrl = this.url == null ? Util.web.getFirstFullUrl() : (this.url.startsWith("/") ? Util.web.getFullUrl(this.getRequest(), this.url) : this.url);
        String string = separator = fullUrl.contains("?") ? "&" : "?";
        if (this.action != null) {
            fullUrl = String.valueOf(fullUrl) + separator + "ACAO" + "=" + this.action;
            separator = "&";
        }
        if (this.parameters != null) {
            fullUrl = String.valueOf(fullUrl) + separator + this.parameters.replace(";", "&");
        }
        return fullUrl;
    }

    public String getOnclick() {
        return this.onclick;
    }

    public String getAction() {
        return this.action;
    }

    public String getDescription() {
        return this.description;
    }

    public String getImg() {
        return this.img;
    }

    public String getParameters() {
        return this.parameters;
    }

    public String getType() {
        return this.type;
    }

    public String getUrl() {
        Tipo tipo = this.definirTipo();
        if (this.confirmationMessage != null && (tipo == Tipo.LINK || tipo == Tipo.IMAGE)) {
            return "javascript: if(confirm('" + this.confirmationMessage + "')){window.location = '" + this.url + "';}";
        }
        return this.url;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setImg(String img) {
        this.img = img;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getConfirmationMessage() {
        return this.confirmationMessage;
    }

    public void setConfirmationMessage(String confirmationMessage) {
        this.confirmationMessage = confirmationMessage;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Tipo {
        BUTTON,
        IMAGE,
        LINK;

    }
}

