/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.view;

import br.com.linkcom.neo.authorization.User;
import br.com.linkcom.neo.bean.PropertyDescriptor;
import br.com.linkcom.neo.core.standard.Neo;
import br.com.linkcom.neo.core.web.WebRequestContext;
import br.com.linkcom.neo.exception.NeoException;
import br.com.linkcom.neo.persistence.GenericDAO;
import br.com.linkcom.neo.types.Cep;
import br.com.linkcom.neo.types.Cnpj;
import br.com.linkcom.neo.types.Cpf;
import br.com.linkcom.neo.types.File;
import br.com.linkcom.neo.types.Hora;
import br.com.linkcom.neo.types.InscricaoEstadual;
import br.com.linkcom.neo.types.Money;
import br.com.linkcom.neo.types.Password;
import br.com.linkcom.neo.types.Telefone;
import br.com.linkcom.neo.util.Util;
import br.com.linkcom.neo.validation.JavascriptValidationItem;
import br.com.linkcom.neo.validation.ValidationItem;
import br.com.linkcom.neo.validation.annotation.Required;
import br.com.linkcom.neo.view.BaseTag;
import br.com.linkcom.neo.view.BeanTag;
import br.com.linkcom.neo.view.ComboReloadGroupTag;
import br.com.linkcom.neo.view.DataGridTag;
import br.com.linkcom.neo.view.DownloadFileServlet;
import br.com.linkcom.neo.view.FormTag;
import br.com.linkcom.neo.view.PropertySetter;
import br.com.linkcom.neo.view.ValidationTag;
import br.com.linkcom.neo.view.ajax.ComboCallback;
import br.com.linkcom.neo.view.code.DebugInputsTag;
import br.com.linkcom.neo.view.template.PropertyConfigTag;
import br.com.linkcom.neo.view.util.DefaultFunctionCallInfo;
import br.com.linkcom.neo.view.util.FunctionCall;
import br.com.linkcom.neo.view.util.FunctionParameter;
import br.com.linkcom.neo.view.util.ParameterType;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputTag
extends BaseTag {
    protected String name;
    protected String label;
    protected Object type;
    protected Object autowiredType;
    protected Object value;
    protected String pattern;
    protected Boolean autowire = true;
    protected Boolean required;
    protected Boolean showLabel = false;
    protected Annotation[] annotations;
    protected Boolean reloadOnChange = false;
    protected Boolean onlyPositiveNumbers = false;
    protected Boolean write = false;
    protected String trueFalseNullLabels;
    protected Boolean booleanValue = null;
    protected boolean forceValidation = false;
    protected String selectOnePath;
    protected String selectOnePathParameters;
    protected String insertPath;
    protected Object itens;
    protected String selectLabelProperty;
    protected Boolean useAjax;
    protected Boolean autoSugestUniqueItem;
    protected String optionalParams = "";
    protected Boolean holdValue;
    protected PropertySetter propertySetter;
    protected String onLoadItens = "";
    protected Boolean includeBlank = true;
    protected String blankLabel = " ";
    protected Integer cols;
    protected Integer rows;
    protected boolean showRemoverButton = true;
    protected Boolean showFileLink = true;
    protected Type selectedType = Type.TEXT;
    protected static Map<String, Type> mapaTipos = new HashMap<String, Type>();
    protected static Map<Class, Type> mapaTiposClasses = new HashMap<Class, Type>();
    private String selectItensString;
    private String selectoneblankoption;
    private Boolean checked;
    private String checkboxValue = "true";
    private String labelStyle = "";
    private String labelStyleClass = "";
    protected Boolean transientFile;

    static {
        mapaTiposClasses.put(InscricaoEstadual.class, Type.INSCRICAO_ESTADUAL);
        mapaTiposClasses.put(Date.class, Type.DATE);
        mapaTiposClasses.put(Collection.class, Type.SELECT_MANY);
        mapaTiposClasses.put(java.util.Date.class, Type.DATE);
        mapaTiposClasses.put(Calendar.class, Type.DATE);
        mapaTiposClasses.put(Time.class, Type.TIME);
        mapaTiposClasses.put(Timestamp.class, Type.TIMESTAMP);
        mapaTiposClasses.put(Boolean.class, Type.CHECKBOX);
        mapaTiposClasses.put(Boolean.TYPE, Type.CHECKBOX);
        mapaTiposClasses.put(Integer.class, Type.INTEGER);
        mapaTiposClasses.put(Short.class, Type.INTEGER);
        mapaTiposClasses.put(Long.class, Type.INTEGER);
        mapaTiposClasses.put(Byte.class, Type.INTEGER);
        mapaTiposClasses.put(BigInteger.class, Type.INTEGER);
        mapaTiposClasses.put(Float.class, Type.FLOAT);
        mapaTiposClasses.put(Double.class, Type.FLOAT);
        mapaTiposClasses.put(BigDecimal.class, Type.FLOAT);
        mapaTiposClasses.put(Cep.class, Type.CEP);
        mapaTiposClasses.put(Telefone.class, Type.TELEFONE);
        mapaTiposClasses.put(Cpf.class, Type.CPF);
        mapaTiposClasses.put(Cnpj.class, Type.CNPJ);
        mapaTiposClasses.put(Hora.class, Type.TIME);
        mapaTiposClasses.put(Money.class, Type.MONEY);
        mapaTiposClasses.put(File.class, Type.FILE);
    }

    @Override
    protected void doComponent() throws Exception {
        DebugInputsTag debugInputsTag;
        int selectAll;
        this.autowireAttributes();
        BeanTag beanTag = this.findParent(BeanTag.class);
        if (Util.strings.isNotEmpty(this.onLoadItens) && (this.useAjax == null || !this.useAjax.booleanValue())) {
            throw new NeoException("N\u00e3o \u00e9 poss\u00edvel utilizar onLoadItens se useAjax n\u00e3o for true");
        }
        this.selectedType = this.chooseType();
        if ((this.selectedType == Type.SELECT_ONE || this.selectedType == Type.SELECT_ONE_INSERT || this.selectedType == Type.SELECT_ONE_RADIO || this.selectedType == Type.SELECT_MANY) && this.includeBlank.booleanValue()) {
            String value = "<null>";
            String label = this.blankLabel;
            this.selectoneblankoption = this.createOption(value, label);
        }
        boolean disabled = "disabled".equals(this.getDAAtribute("disabled", false));
        String loadItensFunction = "";
        if (this.selectedType == Type.SELECT_MANY || this.selectedType == Type.SELECT_ONE || this.selectedType == Type.SELECT_ONE_INSERT || this.selectedType == Type.SELECT_ONE_RADIO || this.selectedType == Type.SELECT_ONE_BUTTON) {
            List<String> organizeItens;
            ComboReloadGroupTag comboReload;
            InputTag lastInput = null;
            FunctionCall call = null;
            DefaultFunctionCallInfo callInfo = null;
            Class usingType = this.getClassType();
            selectAll = 0;
            if ("all".equalsIgnoreCase(Util.strings.toString(this.itens))) {
                this.itens = null;
                selectAll = 1;
            }
            if (this.selectedType != Type.SELECT_ONE_RADIO && this.selectedType != Type.SELECT_ONE_BUTTON) {
                comboReload = this.findParent(ComboReloadGroupTag.class);
                if (comboReload != null) {
                    String itensFunction;
                    if (this.useAjax == null) {
                        this.useAjax = comboReload.useAjax;
                    }
                    if ((itensFunction = Util.strings.toString(this.itens)) != null) {
                        itensFunction = itensFunction.trim();
                        if (beanTag == null && this.useAjax.booleanValue()) {
                            throw new RuntimeException("A tag input deve estar aninhada a uma tag bean para poder utilizar useAjax=true");
                        }
                        if (beanTag != null && this.useAjax.booleanValue() && !"all".equalsIgnoreCase(itensFunction)) {
                            call = new FunctionCall(itensFunction);
                            callInfo = this.montarCallInfo(call, beanTag);
                        }
                    }
                    if (!Enum.class.isAssignableFrom(usingType)) {
                        if (selectAll == 0) {
                            comboReload.registerProperty(this.getName(), call, this.includeBlank);
                            lastInput = comboReload.getLastInput(this);
                        } else {
                            comboReload.getLastInput(this);
                        }
                        if (call == null && lastInput != null) {
                            ComboCallback.register(usingType.getSimpleName(), "findBy", new Class[0]);
                        }
                    } else {
                        comboReload.getLastInput(this);
                    }
                    loadItensFunction = this.montarLoadItensFunction(call, callInfo, lastInput, usingType);
                }
            } else if (this.selectedType == Type.SELECT_ONE_BUTTON) {
                this.itens = new ArrayList();
                comboReload = this.findParent(ComboReloadGroupTag.class);
                if (comboReload != null) {
                    comboReload.getLastInput(this);
                }
            }
            if (this.itens != null && this.itens instanceof String) {
                if (this.useAjax == null || !this.useAjax.booleanValue()) {
                    String expression = (String)this.itens;
                    Object value = this.getOgnlValue(expression);
                    organizeItens = this.organizeItens(value);
                } else {
                    if (call == null || callInfo == null) {
                        throw new NullPointerException("Resultado inesperado. call ou callinfo nulos. O algoritmo do framework n\u00e3o est\u00e1 correto");
                    }
                    String functionName = call.getFunctionName();
                    Object bean = Neo.getApplicationContext().getConfig().getDefaultListableBeanFactory().getBean(call.getObject());
                    Class[] classes = null;
                    Object[] values = null;
                    boolean ignorecall = false;
                    if (call.getParameterArray().length == 0 && !call.getCall().endsWith("()")) {
                        if (lastInput.getValue() == null) {
                            organizeItens = new ArrayList<String>();
                            values = new Object[]{};
                            ignorecall = true;
                        } else {
                            classes = new Class[]{lastInput.getValue().getClass()};
                            values = new Object[]{lastInput.getValue()};
                        }
                    } else {
                        classes = new Class[call.getParameterArray().length];
                        values = new Object[call.getParameterArray().length];
                    }
                    int i = 0;
                    while (i < call.getParameterArray().length) {
                        classes[i] = callInfo.getType(call.getParameterArray()[i]);
                        values[i] = callInfo.getValue(call.getParameterArray()[i]);
                        ++i;
                    }
                    boolean anynull = false;
                    HashSet<String> optionalParametersSet = this.getOptionalParametersSet();
                    int i2 = 0;
                    Object[] objectArray = values;
                    int n = values.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        if (!optionalParametersSet.contains(call.getParameterArray()[i2].getParameterValue()) && object == null) {
                            anynull = true;
                            break;
                        }
                        ++i2;
                        ++n2;
                    }
                    ComboCallback.register(call.getObject(), call.getFunctionName(), classes);
                    boolean bl = ignorecall = (ignorecall || anynull) && call.getParameterArray().length != 0;
                    if (!ignorecall) {
                        Object lista = Util.objects.findAndInvokeMethod(bean, functionName, values, classes);
                        if (!(lista instanceof List)) {
                            throw new RuntimeException("O retorno do m\u00e9todo " + functionName + " n\u00e3o foi uma lista");
                        }
                        organizeItens = this.organizeItens((List)lista);
                    } else {
                        organizeItens = new ArrayList<String>();
                    }
                }
            } else if (this.itens != null) {
                organizeItens = this.organizeItens(this.itens);
            } else if (Enum.class.isAssignableFrom(usingType)) {
                Method method = usingType.getMethod("values", new Class[0]);
                Enum[] enumValues = (Enum[])method.invoke(null, new Object[0]);
                LinkedHashMap values = new LinkedHashMap();
                Enum[] enumArray = enumValues;
                int n = enumValues.length;
                int n3 = 0;
                while (n3 < n) {
                    Enum enumValue = enumArray[n3];
                    values.put(Enum.valueOf(usingType, enumValue.name()), enumValue.toString());
                    ++n3;
                }
                organizeItens = this.organizeItens(values);
            } else {
                organizeItens = this.organizeItens(this.doSelectAllFromService(lastInput));
            }
            this.selectItensString = this.toString(organizeItens);
        }
        if ((this.selectedType == Type.CHECKBOX || this.selectedType == Type.SELECT_ONE_RADIO) && Util.strings.isNotEmpty(this.trueFalseNullLabels) || Util.strings.isNotEmpty(this.trueFalseNullLabels)) {
            if (this.selectedType == Type.CHECKBOX) {
                this.selectedType = Type.SELECT_ONE;
            }
            String[] split = this.trueFalseNullLabels.split(",");
            LinkedHashMap<Boolean, String> mapa = new LinkedHashMap<Boolean, String>();
            mapa.put(Boolean.TRUE, split[0]);
            mapa.put(Boolean.FALSE, split[1]);
            if (split.length == 3) {
                this.selectoneblankoption = this.createOption("<null>", split[2], this.value == null);
            } else if (this.includeBlank != null && this.includeBlank.booleanValue()) {
                this.selectoneblankoption = this.createOption("<null>", this.blankLabel, this.value == null);
            }
            this.selectItensString = this.toString(this.organizeItens(mapa));
        }
        if (this.selectedType == Type.CHECKLIST) {
            if (this.value instanceof Collection || this.value != null && this.value.getClass().isArray()) {
                throw new NeoException("O atributo value da tag input n\u00e3o pode ser um Collection ou Array quando o tipo for CHECKLIST. Voc\u00ea deve ter utilizado a tag property para montar esse input. Nesse caso deve ser explicitado qual \u00e9 o valor desse checkbox ao inv\u00e9s de utilizar o value adquirido automaticamente pelo property. Coloque no atributo value desse input qual o valor que esse checkbox deve representar");
            }
            Object itensValue = null;
            if (this.itens != null && this.itens instanceof String) {
                String expression = (String)this.itens;
                itensValue = this.getOgnlValue(expression);
            } else if (this.itens != null) {
                itensValue = this.itens;
            }
            ArrayList<String> lista = new ArrayList<String>();
            if (itensValue instanceof Collection) {
                for (Object object : (Collection)itensValue) {
                    lista.add(this.getObjectValueToString(object));
                }
            } else if (itensValue != null && itensValue.getClass().isArray()) {
                Object[] array;
                Object[] objectArray = array = (Object[])itensValue;
                int organizeItens = array.length;
                selectAll = 0;
                while (selectAll < organizeItens) {
                    Object object = objectArray[selectAll];
                    lista.add(this.getObjectValueToString(object));
                    ++selectAll;
                }
            }
            String valueToString = this.getObjectValueToString(this.value);
            boolean toCheck = false;
            for (String string : lista) {
                if (!string.equals(valueToString)) continue;
                toCheck = true;
                break;
            }
            this.checked = toCheck;
            this.checkboxValue = valueToString;
        }
        if (this.showLabel.booleanValue() && this.label != null && this.label.trim().length() != 0) {
            boolean usespan = this.labelStyle != null && this.labelStyle.length() > 0 || this.labelStyleClass != null && this.labelStyleClass.length() > 0;
            this.getOut().print("<label for=\"" + this.getId() + "\">");
            if (usespan) {
                this.getOut().print("<span ");
                this.getOut().print("style=\"" + this.labelStyle + "\" ");
                this.getOut().print("class=\"" + this.labelStyleClass + "\"");
                this.getOut().print(">");
            }
            this.getOut().print(this.label);
            if (usespan) {
                this.getOut().print("</span>");
            }
            this.getOut().print("</label>");
        }
        PropertyConfigTag propertyConfig = this.findParent(PropertyConfigTag.class);
        DataGridTag dataGridTag = this.findParent(DataGridTag.class);
        if (propertyConfig != null && Boolean.TRUE.equals(propertyConfig.getDisabled()) && (dataGridTag == null || dataGridTag.getCurrentStatus() != DataGridTag.Status.DYNALINE)) {
            if (disabled) {
                this.getDynamicAttributesMap().put("originaldisabled", "disabled");
            }
            this.getDynamicAttributesMap().put("disabled", "disabled");
        }
        if (!disabled && (this.selectedType != Type.HIDDEN || this.forceValidation)) {
            ValidationTag validationTag;
            String labelSimples;
            ValidationItem validationItem = null;
            String string = labelSimples = this.label != null ? this.label.replaceAll("&nbsp;", "").replaceAll("<BR>", "") : "";
            if (this.type instanceof Class) {
                validationItem = Neo.getApplicationContext().getConfig().getValidatorRegistry().getExtractor().getValidationItem(labelSimples, (Class)this.type, this.annotations);
                this.addExtraValidation(beanTag, validationItem);
            } else if (this.type instanceof String) {
                validationItem = Neo.getApplicationContext().getConfig().getValidatorRegistry().getExtractor().getValidationItem(labelSimples, (String)this.type, this.annotations);
            } else if (this.type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)this.type;
                validationItem = Neo.getApplicationContext().getConfig().getValidatorRegistry().getExtractor().getValidationItem(labelSimples, (Class)parameterizedType.getRawType(), this.annotations);
            }
            if (validationItem != null && (validationItem.getTypeValidator() != null || validationItem.getValidations().size() > 0) && (validationTag = this.findParent(ValidationTag.class)) != null) {
                JavascriptValidationItem javascriptValidationItem = new JavascriptValidationItem(validationItem);
                javascriptValidationItem.setFieldDisplayName(labelSimples);
                javascriptValidationItem.setFieldName(this.name);
                validationTag.register(javascriptValidationItem);
            }
        }
        Annotation[] annotationArray = this.annotations;
        int validationTag = this.annotations.length;
        int labelSimples = 0;
        while (labelSimples < validationTag) {
            Annotation annotation = annotationArray[labelSimples];
            this.getInputListener(annotation).onRender(this, annotation);
            ++labelSimples;
        }
        if (this.selectedType == Type.CHECKLIST) {
            this.selectedType = Type.CHECKBOX;
        }
        if (this.selectedType == Type.FILE && Boolean.TRUE.equals(propertyConfig.getDisabled())) {
            this.showRemoverButton = false;
        }
        if ((debugInputsTag = this.findParent(DebugInputsTag.class, false)) != null) {
            boolean add = debugInputsTag.addProperty(this.name);
            if (!add) {
                this.getDynamicAttributesMap().put("style", "border: 1px solid red");
                this.getDynamicAttributesMap().put("title", "Propriedade duplicada: " + this.name);
            }
            try {
                Class class1 = debugInputsTag.getCommandClass();
                Neo.getApplicationContext().getBeanDescriptor(null, class1).getPropertyDescriptor(this.name);
            }
            catch (Exception e) {
                this.getDynamicAttributesMap().put("style", "border: 1px solid red");
                this.getDynamicAttributesMap().put("title", "Propriedade inv\u00e1lida: " + this.name);
            }
        }
        if (this.selectedType == Type.INTEGER || this.selectedType == Type.FLOAT || this.selectedType == Type.MONEY) {
            Object style = this.getDAAtribute("style", false);
            style = style != null ? "text-align: right; " + style : "text-align: right; ";
            this.setDynamicAttribute(null, "style", style);
        }
        if (this.selectedType == Type.DATE || this.selectedType == Type.TIME || this.selectedType == Type.TIMESTAMP) {
            if (Util.strings.isEmpty(this.pattern)) {
                this.pattern = this.selectedType == Type.DATE ? "dd/MM/yyyy" : (this.selectedType == Type.TIMESTAMP ? "dd/MM/yyyy HH:mm" : "HH:mm");
            }
            this.getDynamicAttributesMap().put("maxlength", this.pattern.length());
            this.getDynamicAttributesMap().put("size", this.pattern.length() + 1);
        }
        String renderRequiredType = Neo.getApplicationContext().getConfig().getRequiredRenderType();
        boolean skipRenderAsterisk = false;
        if (this.required != null && this.required.booleanValue() && "addclass".equals(renderRequiredType)) {
            skipRenderAsterisk = true;
            if (this.selectedType != Type.CHECKBOX) {
                if (this.getDynamicAttributesMap().containsKey("class")) {
                    this.getDynamicAttributesMap().put("class", "required " + this.getDynamicAttributesMap().get("class"));
                } else {
                    this.getDynamicAttributesMap().put("class", "required");
                }
            }
        }
        this.includeTemplate();
        if (!skipRenderAsterisk) {
            this.printRequired();
        }
        if ((this.selectedType == Type.SELECT_ONE || this.selectedType == Type.SELECT_MANY || this.selectedType == Type.SELECT_ONE_INSERT) && Util.strings.isNotEmpty(loadItensFunction.trim())) {
            this.getOut().println("<script language='javascript'>");
            this.getOut().println(loadItensFunction);
            this.getOut().println("</script>");
        }
    }

    private void addExtraValidation(BeanTag beanTag, ValidationItem validationItem) {
        if (!(this.name == null || !this.name.contains(".") || this.name.contains("{index}") || this.name.contains("[") && this.name.contains("]"))) {
            PropertyDescriptor propertyDescriptor = beanTag.getBeanDescriptor().getPropertyDescriptor(this.name.substring(0, this.name.indexOf(".")));
            Annotation[] annotationsValidators = propertyDescriptor.getAnnotations();
            boolean overrideValidation = Neo.getApplicationContext().getConfig().getValidatorRegistry().getExtractor().overrideValidation(validationItem, this.name, annotationsValidators);
            if (overrideValidation) {
                this.required = validationItem.existsRequired();
            }
        }
    }

    private Class getClassType() {
        Object o;
        Class class1;
        Class clazz = this.type instanceof Class ? (Class)this.type : (class1 = this.type instanceof ParameterizedType ? Util.generics.getActualClassesArgument((ParameterizedType)this.type)[0] : (Class)this.autowiredType);
        if (class1 == null && this.itens instanceof Collection && ((Collection)this.itens).size() > 0 && (o = ((Collection)this.itens).iterator().next()) != null) {
            return o.getClass();
        }
        return class1;
    }

    protected void includeTemplate() throws ServletException, IOException {
        this.includeJspTemplate(this.selectedType.toString().toLowerCase());
    }

    protected void printRequired() throws IOException {
        if (this.required != null && this.required.booleanValue() && this.selectedType != Type.HIDDEN && !this.getDynamicAttributesMap().containsKey("readonly")) {
            this.getOut().println("<span class='requiredMark'>*</span>");
        }
    }

    private String montarLoadItensFunction(FunctionCall call, DefaultFunctionCallInfo callInfo, InputTag lastInput, Class usingType) {
        if (this.useAjax == null || !this.useAjax.booleanValue()) {
            return "";
        }
        FormTag formTag = this.findParent(FormTag.class, true);
        String form = formTag.getName();
        String ifcode = "";
        HashSet<String> optionalParametersSet = this.getOptionalParametersSet();
        if (call != null) {
            FunctionParameter[] parameterArray;
            FunctionParameter[] functionParameterArray = parameterArray = call.getParameterArray();
            int n = parameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                FunctionParameter parameter = functionParameterArray[n2];
                if (parameter.getParameterType() == ParameterType.REFERENCE && !optionalParametersSet.contains(parameter.getParameterValue())) {
                    ifcode = String.valueOf(ifcode) + form + "['" + parameter.getParameterValue() + "'].value != '<null>' && ";
                }
                ++n2;
            }
        } else if (lastInput != null) {
            ifcode = String.valueOf(form) + "['" + lastInput.getName() + "'].value != '<null>' && ";
        }
        String listaParametrosFuncao = "var listaParametros = '";
        String listaClassesFuncao = "var listaClasses = '";
        if (call != null && call.getParameterArray().length > 0) {
            FunctionParameter[] parameterArray = call.getParameterArray();
            int j = 0;
            while (j < parameterArray.length) {
                String param = call.getParameterArray()[j].getParameterValue();
                switch (call.getParameterArray()[j].getParameterType()) {
                    case REFERENCE: {
                        listaParametrosFuncao = String.valueOf(listaParametrosFuncao) + "'+getInputValue(" + formTag.getName() + "['" + param + "'])+'";
                        listaClassesFuncao = String.valueOf(listaClassesFuncao) + callInfo.getType(call.getParameterArray()[j]).getName();
                        listaClassesFuncao = String.valueOf(listaClassesFuncao) + ";";
                        listaParametrosFuncao = String.valueOf(listaParametrosFuncao) + "#";
                        break;
                    }
                    case STRING: {
                        listaParametrosFuncao = String.valueOf(listaParametrosFuncao) + param;
                        listaClassesFuncao = String.valueOf(listaClassesFuncao) + String.class.getName();
                        listaClassesFuncao = String.valueOf(listaClassesFuncao) + ";";
                        listaParametrosFuncao = String.valueOf(listaParametrosFuncao) + "#";
                        break;
                    }
                    case BOOLEAN: {
                        listaParametrosFuncao = String.valueOf(listaParametrosFuncao) + param;
                        listaClassesFuncao = String.valueOf(listaClassesFuncao) + Boolean.class.getName();
                        listaClassesFuncao = String.valueOf(listaClassesFuncao) + ";";
                        listaParametrosFuncao = String.valueOf(listaParametrosFuncao) + "#";
                        break;
                    }
                    case USER: {
                        listaParametrosFuncao = String.valueOf(listaParametrosFuncao) + param;
                        listaClassesFuncao = String.valueOf(listaClassesFuncao) + User.class.getName();
                        listaClassesFuncao = String.valueOf(listaClassesFuncao) + ";";
                        listaParametrosFuncao = String.valueOf(listaParametrosFuncao) + "#";
                        break;
                    }
                    default: {
                        throw new RuntimeException("Tipo n\u00e3o suportado: " + (Object)((Object)call.getParameterArray()[j].getParameterType()));
                    }
                }
                ++j;
            }
        }
        listaParametrosFuncao = String.valueOf(listaParametrosFuncao) + "';";
        listaClassesFuncao = String.valueOf(listaClassesFuncao) + "';";
        String parentValue = "";
        parentValue = call == null && lastInput != null ? String.valueOf(form) + "['" + lastInput.getName() + "'].value" : "''";
        String holdValue = Util.booleans.isTrue(this.holdValue) ? ", " + form + "['" + this.getName() + "'].value" : "";
        String addItensHoldValue = Util.booleans.isTrue(this.holdValue) ? "true" : "false";
        ifcode = String.valueOf(ifcode) + "1 == 1";
        String functionCode = String.valueOf(form) + "['" + this.getName() + "'].loadItens = function(){\n";
        functionCode = String.valueOf(functionCode) + "    var executeOnchange = " + form + "['" + this.getName() + "'].value != '<null>' && " + form + "['" + this.getName() + "'].value != '';\n";
        functionCode = String.valueOf(functionCode) + "    " + form + "['" + this.getName() + "'].wasEmpty = !executeOnchange;\n";
        functionCode = String.valueOf(functionCode) + "    if(" + ifcode + "){\n";
        functionCode = String.valueOf(functionCode) + "        limparCombo(" + form + "['" + this.getName() + "'], " + this.includeBlank + " " + holdValue + ", '" + this.getBlankLabel() + "');\n";
        functionCode = String.valueOf(functionCode) + "        " + listaParametrosFuncao + "\n";
        functionCode = String.valueOf(functionCode) + "        " + listaClassesFuncao + "\n";
        functionCode = String.valueOf(functionCode) + "        ajaxLoadCombo('" + this.getRequest().getContextPath() + "', " + form + "['" + this.getName() + "'], '" + usingType.getName() + "', '" + Util.strings.escape(call != null ? call.getCall() : "") + "', listaClasses, listaParametros, '" + this.selectLabelProperty + "', " + parentValue + ");\n";
        functionCode = String.valueOf(functionCode) + "    }\n";
        functionCode = String.valueOf(functionCode) + "    else {\n";
        functionCode = String.valueOf(functionCode) + "        limparCombo(" + form + "['" + this.getName() + "'], " + this.includeBlank + ", '" + this.getBlankLabel() + "');\n";
        functionCode = String.valueOf(functionCode) + "        if(executeOnchange) " + form + "['" + this.getName() + "'].onchange();\n";
        functionCode = String.valueOf(functionCode) + "    }\n";
        functionCode = String.valueOf(functionCode) + "};\n\n";
        functionCode = String.valueOf(functionCode) + "form['" + this.getName() + "'].setItens = function(lista){\n";
        functionCode = String.valueOf(functionCode) + "      var valorMantido = addItensToCombo(" + form + "['" + this.getName() + "'], lista, " + addItensHoldValue + ");\n";
        if (this.autoSugestUniqueItem != null && this.autoSugestUniqueItem.booleanValue()) {
            String indice = this.includeBlank != false ? "1" : "0";
            functionCode = String.valueOf(functionCode) + "        if(lista.length >= 1){";
            functionCode = String.valueOf(functionCode) + "            if(lista.length == 1){" + form + "['" + this.getName() + "'].selectedIndex = " + indice + "; " + form + "['" + this.getName() + "'].onchange();" + "}/*AUTO SUGEST UNIQUE ITEM*/\n";
            functionCode = String.valueOf(functionCode) + "        }";
        }
        functionCode = String.valueOf(functionCode) + "       if(!" + form + "['" + this.getName() + "'].wasEmpty && !valorMantido){" + form + "['" + this.getName() + "'].onchange();}\n";
        functionCode = String.valueOf(functionCode) + "        " + this.onLoadItens + "\n";
        functionCode = String.valueOf(functionCode) + "};\n";
        return functionCode;
    }

    private HashSet<String> getOptionalParametersSet() {
        String[] split = this.optionalParams.split("( )*?,( )*?");
        int i = 0;
        while (i < split.length) {
            split[i] = split[i].trim();
            ++i;
        }
        HashSet<String> optionalParametersSet = new HashSet<String>((Collection)Arrays.asList(split));
        return optionalParametersSet;
    }

    private DefaultFunctionCallInfo montarCallInfo(FunctionCall call, BeanTag beanTag) {
        FunctionParameter[] parameterArray;
        if (call.getCall().equals("all")) {
            return null;
        }
        DefaultFunctionCallInfo callInfo = new DefaultFunctionCallInfo();
        FunctionParameter[] functionParameterArray = parameterArray = call.getParameterArray();
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object value;
            Class clazz;
            FunctionParameter param = functionParameterArray[n2];
            switch (param.getParameterType()) {
                case REFERENCE: {
                    PropertyDescriptor propertyDescriptor = beanTag.getBeanDescriptor().getPropertyDescriptor(param.getParameterValue());
                    clazz = propertyDescriptor.getPropertyInfo().getClazz();
                    value = propertyDescriptor.getPropertyInfo().getValue();
                    break;
                }
                case STRING: {
                    clazz = String.class;
                    value = param.getParameterValue();
                    break;
                }
                case BOOLEAN: {
                    clazz = Boolean.class;
                    value = new Boolean(param.getParameterValue());
                    break;
                }
                case USER: {
                    clazz = User.class;
                    value = Neo.getRequestContext().getUser();
                    break;
                }
                default: {
                    throw new RuntimeException("Tipo de parametro n\u00e3o suportado: " + (Object)((Object)param.getParameterType()) + "   " + param.getParameterValue());
                }
            }
            callInfo.addParam(param.getParameterValue(), value, clazz);
            ++n2;
        }
        return callInfo;
    }

    public String getFileName() {
        if (this.value instanceof File) {
            String name2 = ((File)this.value).getName();
            if (Util.strings.isEmpty(name2)) {
                return "[vazio]";
            }
            return this.escape(name2);
        }
        return "[vazio]";
    }

    private String createOption(String value, String label) {
        return this.createOption(value, label, false);
    }

    private String createOption(String value, String label, boolean selected) {
        return this.createOption(value, label, selected ? "selected=\"selected\"" : "");
    }

    private String createOption(String value, String label, String selected) {
        if (this.selectedType != Type.SELECT_ONE_RADIO) {
            return "<option value='" + (value != null ? value : "<null>") + "' " + selected + ">" + label + "</option>";
        }
        String inputId = String.valueOf(this.generateUniqueId()) + "_opt_" + this.name;
        selected = selected != null && selected.length() > 0 ? "checked=\"checked\"" : "";
        String disabled = "";
        Boolean consultar = (Boolean)this.getRequest().getAttribute("consultar");
        if (consultar != null && consultar.booleanValue()) {
            disabled = "disabled";
        }
        return "<input type='radio' id='" + inputId + "' class='radioClass' value='" + (value != null ? value : "<null>") + "' name='" + this.name + "' " + selected + " " + disabled + " /><label for='" + inputId + "'>" + label + "</label>";
    }

    public Object getOnKeyPress() {
        return this.getDAAtribute("onKeyPress", true);
    }

    public Object getOnKeyUp() {
        return this.getDAAtribute("onKeyUp", true);
    }

    private Object getDAAtribute(String string, boolean remove) {
        Set<String> keySet = this.getDynamicAttributesMap().keySet();
        for (String string2 : keySet) {
            if (!string2.equalsIgnoreCase(string)) continue;
            if (remove) {
                return this.getDynamicAttributesMap().remove(string2);
            }
            return this.getDynamicAttributesMap().get(string2);
        }
        return null;
    }

    public String getFileOnChange() {
        String complemento = "";
        if (this.showRemoverButton) {
            complemento = "document.getElementById('" + this.name + "_removerbtn').style.dysplay = '';";
        }
        String onchangestring = "document.getElementById('" + this.name + "_excludeField').value='false'; document.getElementById('" + this.name + "_div').style.textDecoration = 'line-through'; " + complemento + " ";
        String daOnChange = (String)this.getDAAtribute("onChange", true);
        if (daOnChange != null) {
            onchangestring = String.valueOf(onchangestring) + ";" + daOnChange;
        }
        return onchangestring;
    }

    public String getReloadOnChangeString() {
        String onchangestring = "";
        if (this.reloadOnChange != null && this.reloadOnChange.booleanValue()) {
            FormTag form = this.findParent(FormTag.class, true);
            onchangestring = String.valueOf(form.getName()) + ".validate = 'false'; " + form.getName() + ".suppressErrors.value = 'true';" + form.getName() + "." + "ACAO" + ".value = '" + Util.strings.toString(((WebRequestContext)Neo.getRequestContext()).getLastAction(), "") + "';" + form.getName() + ".suppressValidation.value = 'true';" + form.getSubmitFunction() + "()";
        } else {
            ComboReloadGroupTag comboReloadGroupTag = this.findParent(ComboReloadGroupTag.class);
            if (comboReloadGroupTag != null) {
                onchangestring = this.selectedType == Type.SELECT_ONE_BUTTON ? String.valueOf(comboReloadGroupTag.getFunctionName()) + "('" + this.getName() + "', form['" + this.name + "'].value);" : String.valueOf(comboReloadGroupTag.getFunctionName()) + "('" + this.getName() + "', this.value);";
            }
        }
        String daOnChange = (String)this.getDAAtribute("onChange", true);
        if (daOnChange != null) {
            onchangestring = String.valueOf(daOnChange) + ";" + onchangestring;
        }
        return onchangestring;
    }

    public String getReloadOnClickString() {
        String onchangestring = "";
        if (this.reloadOnChange != null && this.reloadOnChange.booleanValue()) {
            FormTag form = this.findParent(FormTag.class, true);
            onchangestring = String.valueOf(form.getName()) + ".validate = 'false'; " + form.getName() + ".suppressErrors.value = 'true';" + form.getName() + ".suppressValidation.value = 'true';" + form.getSubmitFunction() + "()";
        } else {
            ComboReloadGroupTag comboReloadGroupTag = this.findParent(ComboReloadGroupTag.class);
            if (comboReloadGroupTag != null) {
                onchangestring = String.valueOf(comboReloadGroupTag.getFunctionName()) + "('" + this.getName() + "');";
            }
        }
        String daOnClick = (String)this.getDAAtribute("onClick", true);
        if (daOnClick != null) {
            onchangestring = String.valueOf(daOnClick) + ";" + onchangestring;
        }
        return onchangestring;
    }

    private Object doSelectAllFromService(InputTag lastInput) {
        Object dao;
        String beanName;
        String parentProperty;
        block14: {
            parentProperty = "";
            if (lastInput != null) {
                parentProperty = "by_" + lastInput.getName();
            }
            try {
                if (this.type instanceof Class || this.autowiredType instanceof Class || this.type instanceof ParameterizedType && this.selectedType == Type.SELECT_MANY) {
                    Class usingType = this.getClassType();
                    beanName = Util.strings.uncaptalize(usingType.getSimpleName());
                    Object attribute = this.getRequest().getAttribute(String.valueOf(beanName) + "FINDALL_" + parentProperty);
                    if (attribute != null) {
                        return attribute;
                    }
                    dao = Neo.getApplicationContext().getBean(String.valueOf(beanName) + "DAO");
                    break block14;
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        if (dao != null) {
            List<Object> findAll;
            String[] extraFields = null;
            if (this.selectLabelProperty != null && this.selectLabelProperty.trim().length() > 0) {
                extraFields = new String[]{this.selectLabelProperty};
            }
            if (lastInput == null) {
                List findAll2;
                GenericDAO genericDao = (GenericDAO)((Object)dao);
                try {
                    findAll2 = genericDao.findForCombo(extraFields);
                }
                catch (Exception e) {
                    this.log.warn((Object)("findForCombo (propriedade: " + this.name + ") jogou exe\u00e7\u00e3o: " + e.getMessage() + "   Utilizando findAll()"));
                    findAll2 = genericDao.findAll();
                }
                this.getRequest().setAttribute(String.valueOf(beanName) + "FINDALL_" + parentProperty, findAll2);
                return findAll2;
            }
            GenericDAO genericDAO = (GenericDAO)((Object)dao);
            if (lastInput.getValue() != null && !Util.beans.isTransient(lastInput.getValue())) {
                try {
                    findAll = genericDAO.findBy(lastInput.getValue(), true, extraFields);
                }
                catch (Exception e) {
                    this.log.warn((Object)("findBy(" + lastInput.getValue().getClass().getSimpleName() + ") (propriedade: " + this.name + ") jogou exe\u00e7\u00e3o: " + e.getMessage() + "   Utilizando findBy sem especificar os campos"));
                    findAll = genericDAO.findBy(lastInput.getValue(), false, extraFields);
                }
            } else {
                findAll = new ArrayList();
            }
            this.getRequest().setAttribute(String.valueOf(beanName) + "FINDALL_" + parentProperty, findAll);
            return findAll;
        }
        return null;
    }

    private String toString(List<String> organizeItens) {
        StringBuilder builder = new StringBuilder();
        for (String string : organizeItens) {
            builder.append(string);
            builder.append("\n");
        }
        return builder.toString();
    }

    private List<String> organizeItens(Object itens) {
        ArrayList<String> valores;
        block13: {
            boolean first;
            boolean sugest;
            block14: {
                block12: {
                    sugest = false;
                    first = true;
                    if (this.autoSugestUniqueItem != null && this.autoSugestUniqueItem.booleanValue() && this.value == null) {
                        sugest = true;
                    }
                    valores = new ArrayList<String>();
                    if (itens == null) {
                        return valores;
                    }
                    if (!(itens instanceof Map)) break block12;
                    Map map = (Map)itens;
                    Set keySet = map.keySet();
                    sugest = sugest && keySet.size() == 1;
                    for (Object key : keySet) {
                        Object mapValue = map.get(key);
                        if (mapValue instanceof Collection || mapValue instanceof Map || mapValue.getClass().isArray()) {
                            if (this.selectedType != Type.SELECT_ONE_RADIO) {
                                valores.add("<optgroup label=\"" + key + "\">");
                            }
                            valores.addAll(this.organizeItens(mapValue));
                            if (this.selectedType != Type.SELECT_ONE_RADIO) {
                                valores.add("</optgroup>");
                            }
                        } else {
                            if (sugest || first && this.value == null && this.includeBlank != null && !this.includeBlank.booleanValue() && this.selectedType != Type.SELECT_MANY) {
                                this.value = key;
                                this.propertySetter.set(this.value);
                            }
                            String opDesc = this.getSelectLabel(mapValue);
                            String opValue = this.getObjectValueToString(key, false);
                            opValue = this.escapeSingleQuotes(opValue);
                            String selected = this.getSelectedString(key);
                            valores.add(this.createOption(opValue, opDesc, selected));
                        }
                        first = false;
                    }
                    break block13;
                }
                if (!(itens instanceof Collection)) break block14;
                Collection collection = (Collection)itens;
                sugest = collection.size() == 1 && sugest;
                for (Object object : collection) {
                    if (sugest || first && this.value == null && this.includeBlank != null && !this.includeBlank.booleanValue() && this.selectedType != Type.SELECT_MANY) {
                        this.value = object;
                        this.propertySetter.set(this.value);
                    }
                    String opDesc = this.getSelectLabel(object);
                    String opValue = this.getObjectValueToString(object, false);
                    opValue = this.escapeSingleQuotes(opValue);
                    String selected = this.getSelectedString(object);
                    valores.add(this.createOption(opValue, opDesc, selected));
                    first = false;
                }
                break block13;
            }
            if (!itens.getClass().isArray()) break block13;
            Object[] collection = (Object[])itens;
            sugest = collection.length == 1 && sugest;
            Object[] objectArray = collection;
            int n = collection.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (sugest || first && this.value == null && this.includeBlank != null && !this.includeBlank.booleanValue()) {
                    this.value = object;
                    this.propertySetter.set(this.value);
                }
                String opDesc = this.getSelectLabel(object);
                String opValue = this.getObjectValueToString(object, false);
                opValue = this.escapeSingleQuotes(opValue);
                String selected = this.getSelectedString(object);
                valores.add(this.createOption(opValue, opDesc, selected));
                first = false;
                ++n2;
            }
        }
        return valores;
    }

    private String getSelectLabel(Object value) {
        if (this.selectLabelProperty != null && this.selectLabelProperty.trim().length() != 0 && value != null) {
            return this.getObjectDescriptionToString(Neo.getApplicationContext().getBeanDescriptor(value).getPropertyDescriptor(this.getSelectLabelProperty()).getValue());
        }
        return this.getObjectDescriptionToString(value);
    }

    private String getSelectedString(Object optionValue) {
        String selected = "";
        if (this.value instanceof Collection) {
            Collection collection = (Collection)this.value;
            for (Object object : collection) {
                boolean eq = this.areEqual(optionValue, object);
                String string = selected = eq ? " selected='selected'" : "";
                if (!eq) {
                    continue;
                }
                break;
            }
        } else if (this.value != null && this.value.getClass().isArray()) {
            Object[] array;
            Object[] objectArray = array = (Object[])this.value;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                boolean eq = this.areEqual(optionValue, object);
                String string = selected = eq ? " selected='selected'" : "";
                if (!eq) {
                    ++n2;
                    continue;
                }
                break;
            }
        } else {
            selected = this.areEqual(optionValue, this.value) ? " selected='selected'" : "";
        }
        return selected;
    }

    protected void autowireAttributes() {
        if (this.autowire.booleanValue()) {
            this.autowiredType = this.getPageContext().findAttribute("type");
            if (this.type == null) {
                this.type = this.getPageContext().findAttribute("type");
            }
            if (this.name == null) {
                try {
                    this.name = (String)this.getPageContext().findAttribute("name");
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            if (this.value == null) {
                this.value = this.getPageContext().findAttribute("value");
            }
            if (this.propertySetter == null) {
                this.propertySetter = (PropertySetter)this.getPageContext().findAttribute("propertySetter");
                if (this.propertySetter == null) {
                    this.propertySetter = new PropertySetter(){

                        public void set(Object value) {
                            InputTag.this.log.warn((Object)(String.valueOf(InputTag.this.name) + " tentou setar o valor da propriedade, mas n\u00e3o existe propertySetter para essa propriedade"));
                        }
                    };
                }
            }
            if (this.required == null) {
                try {
                    this.required = (Boolean)this.getPageContext().findAttribute("required");
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            if (Util.strings.isEmpty(this.label)) {
                try {
                    this.label = this.getPageContext().findAttribute("label").toString();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            if (this.annotations == null) {
                try {
                    this.annotations = (Annotation[])this.getPageContext().findAttribute("annotations");
                }
                catch (Exception e) {
                    this.annotations = new Annotation[0];
                }
                if (this.annotations == null) {
                    this.annotations = new Annotation[0];
                }
            }
            if (this.required == null) {
                Annotation[] annotationArray = this.annotations;
                int n = this.annotations.length;
                int n2 = 0;
                while (n2 < n) {
                    Annotation ann = annotationArray[n2];
                    if (ann instanceof Required) {
                        this.required = true;
                        break;
                    }
                    ++n2;
                }
            }
        }
    }

    private Type chooseType() {
        Type selectedType;
        if (Util.objects.isEmpty(this.type)) {
            if (this.value == null) {
                throw new NullPointerException("Em uma tag input o atributo value e o type n\u00e3o podem ser ambos nulos");
            }
            Class<?> c = this.value.getClass();
            selectedType = this.chooseTypeByClass(c);
        } else if (this.type instanceof String) {
            String typeString = ((String)this.type).toUpperCase().replaceAll("-", "_");
            try {
                Type valueOf;
                selectedType = valueOf = Type.valueOf(typeString);
            }
            catch (IllegalArgumentException e) {
                throw new NeoException("Type n\u00e3o suportado por input: " + this.type);
            }
        } else if (this.type instanceof Class) {
            selectedType = this.chooseTypeByClass((Class)this.type);
        } else if (this.type instanceof ParameterizedType) {
            selectedType = this.chooseTypeByClass((Class)((ParameterizedType)this.type).getRawType());
        } else if (this.type instanceof Collection) {
            selectedType = Type.SELECT_MANY;
        } else {
            throw new IllegalArgumentException("Input n\u00e3o suporta valor '" + this.type + "' no atributo type");
        }
        if (selectedType == Type.TEXT && (this.rows != null && this.rows != 0 || this.cols != null && this.cols != 0) && !"text".equals(this.type)) {
            selectedType = Type.TEXT_AREA;
        }
        if (selectedType == Type.TEXT) {
            Annotation[] annotationArray = this.annotations;
            int n = this.annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation ann = annotationArray[n2];
                if (ann instanceof Password) {
                    selectedType = Type.PASSWORD;
                }
                ++n2;
            }
        }
        if (selectedType == Type.CHECKBOX && this.itens != null && !"".equals(this.itens) && this.value != null) {
            selectedType = Type.CHECKLIST;
        }
        if (this.type == null && this.itens != null && !"".equals(this.itens) && selectedType != Type.SELECT_MANY) {
            selectedType = Type.SELECT_ONE;
        }
        if (selectedType == Type.SELECT_ONE && Util.strings.isNotEmpty(this.selectOnePath)) {
            selectedType = Type.SELECT_ONE_BUTTON;
        }
        if (selectedType == Type.SELECT_ONE && Util.strings.isNotEmpty(this.insertPath)) {
            selectedType = Type.SELECT_ONE_INSERT;
        }
        return selectedType;
    }

    private Type chooseTypeByClass(Class c) {
        if (Map.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("O input n\u00e3o suporta valores do tipo Map");
        }
        if (Enum.class.isAssignableFrom(c)) {
            return Type.SELECT_ONE;
        }
        if (File.class.isAssignableFrom(c)) {
            return Type.FILE;
        }
        if (this.isEntity(c)) {
            return Type.SELECT_ONE;
        }
        if (Collection.class.isAssignableFrom(c)) {
            return Type.SELECT_MANY;
        }
        if (this.itens != null) {
            return Type.SELECT_ONE;
        }
        Type type2 = mapaTiposClasses.get(c);
        if (type2 == null) {
            type2 = Type.TEXT;
        }
        return type2;
    }

    public String getValueToString() {
        if (this.value == null && this.selectedType == Type.HIDDEN) {
            return "<null>";
        }
        if (this.value instanceof String) {
            return (String)this.value;
        }
        if (this.pattern != null && this.value != null) {
            try {
                if (this.selectedType == Type.DATE || this.selectedType == Type.TIME || this.selectedType == Type.TIMESTAMP) {
                    if (this.value instanceof Calendar) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat(this.pattern);
                        return dateFormat.format(((Calendar)this.value).getTime());
                    }
                    SimpleDateFormat dateFormat = new SimpleDateFormat(this.pattern);
                    return dateFormat.format(this.value);
                }
                if (this.selectedType == Type.FLOAT) {
                    DecimalFormat decimalFormat = new DecimalFormat(this.pattern);
                    String format = decimalFormat.format(this.value);
                    if (format.startsWith(",")) {
                        format = "0" + format;
                    }
                    return format;
                }
            }
            catch (Exception e) {
                throw new NeoException("Erro ao utilizar pattern. Valor: " + this.value.getClass().getName() + " " + this.value + "   ." + e.getMessage(), e);
            }
        }
        return this.getObjectValueToString(this.value, false);
    }

    public String getEscapeValueToString() {
        String opValue;
        if (this.value == null) {
            if (this.selectedType == Type.HIDDEN) {
                return "<null>";
            }
            if (this.selectedType == Type.TEXT) {
                return "";
            }
        }
        if ((opValue = this.selectedType == Type.TEXT && this.hasId(this.value.getClass()) ? this.getObjectDescriptionToString(this.value) : this.getObjectValueToString(this.value, false)) == null) {
            return null;
        }
        return opValue.replaceAll("\\\\", "\\\\").replaceAll("\"", "&#34;");
    }

    public String getValueWithDescriptionToString() {
        if (this.value == null) {
            return "<null>";
        }
        return this.getObjectValueToString(this.value, true);
    }

    public Boolean getWrite() {
        return this.write;
    }

    public void setWrite(Boolean write) {
        this.write = write;
    }

    public String getBooleanDescriptionToString() {
        if (this.write != null && this.write.booleanValue()) {
            String booleanDescription = null;
            try {
                if ((this.value instanceof Boolean || this.value == null) && Util.strings.isNotEmpty(this.trueFalseNullLabels)) {
                    String[] split = this.trueFalseNullLabels.split(",");
                    String trueString = split[0];
                    String falseString = split[1];
                    String nullString = "";
                    if (split.length == 3) {
                        nullString = split[2];
                    }
                    if (this.value == null) {
                        booleanDescription = nullString;
                    } else if (this.value instanceof Boolean) {
                        booleanDescription = (Boolean)this.value != false ? trueString : falseString;
                    }
                    return booleanDescription;
                }
                if (this.value instanceof Boolean) {
                    booleanDescription = (Boolean)this.value != false ? "Sim" : "N\u00e3o";
                    return booleanDescription;
                }
                if (this.value instanceof Number && Util.strings.isNotEmpty(this.pattern)) {
                    DecimalFormat decimalFormat = new DecimalFormat(this.pattern);
                    return decimalFormat.format(this.value);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new NeoException("trueFalseNullLabels inv\u00e1lido " + this.trueFalseNullLabels + ". Esse atributo deve ser uma string separada por v\u00edrgula indicando o valor de TRUE FALSE e NULL. ex.: sim,n\u00e3o,vazio");
            }
            return this.getObjectDescriptionToString(this.value);
        }
        return "";
    }

    public String getDescriptionToString() {
        return this.getObjectDescriptionToString(this.value);
    }

    public String getSelectOneButtonOnClick() {
        if (this.selectOnePath == null) {
            throw new NeoException("Quando o tipo do input for select-one-button o atributo selectOnePath \u00e9 obrigat\u00f3rio");
        }
        String contextPath = this.getRequest().getContextPath();
        String fullPath = String.valueOf(contextPath) + "/SELECIONARCADASTRAR" + this.selectOnePath;
        if (Util.strings.isNotEmpty(this.selectOnePathParameters)) {
            if (!fullPath.contains("?")) {
                fullPath = String.valueOf(fullPath) + "?";
            }
            fullPath = this.selectOnePathParameters.startsWith("javascript:") ? String.valueOf(fullPath) + "' +" + this.selectOnePathParameters.substring("javascript:".length()) + " + '" : String.valueOf(fullPath) + this.selectOnePathParameters;
        }
        FormTag form = this.findParent(FormTag.class, true);
        String typeString = "java.lang.Object";
        if (this.type instanceof Class) {
            typeString = ((Class)this.type).getName();
        }
        String onclick = "var c = new selecionarCallbackObject(" + form.getName() + "['" + this.getName() + "'], " + form.getName() + "['" + this.getName() + "_label'], '" + typeString + "', " + form.getName() + "['" + this.getName() + "_btn'], " + form.getName() + "['" + this.getName() + "_btnUnselect']" + "); var win = open('" + fullPath + "','filha" + (int)(Math.random() * 100000.0) + "','width=' + (window.document.body.clientWidth) + ', height=' + (window.document.body.clientHeight) + ', top=50, left=0, resizable, scrollbars'); win.selecionarCallback = c;";
        return onclick;
    }

    public String getSelectOneInsertOnClick() {
        if (this.selectOnePath == null) {
            throw new NeoException("Quando o tipo do input for select-one-insert o atributo insertPath \u00e9 obrigat\u00f3rio");
        }
        String contextPath = this.getRequest().getContextPath();
        String fullPath = String.valueOf(contextPath) + "/SELECIONARCADASTRAR" + this.insertPath;
        fullPath = fullPath.contains("?") ? String.valueOf(fullPath) + "&" : String.valueOf(fullPath) + "?";
        fullPath = String.valueOf(fullPath) + "ACAO=criar&fromInsertOne=true";
        FormTag form = this.findParent(FormTag.class, true);
        String typeString = "java.lang.Object";
        if (this.type instanceof Class) {
            typeString = ((Class)this.type).getName();
        }
        String onclick = "var c = new selecionarCallbackObject(" + form.getName() + "['" + this.getName() + "'], " + "null, '" + typeString + "', " + "null, null, function(label,valor){" + form.getName() + "['" + this.getName() + "'].options.add(new Option(label, valor, false, true)); " + "}); var win = open('" + fullPath + "','filha" + (int)(Math.random() * 100000.0) + "','width=' + 780 + ', height=' + 580 + ', top=50, left=115, resizable, scrollbars, status=yes'); win.selecionarCallback = c;";
        return onclick;
    }

    public String getChecked() {
        if (this.checked != null) {
            return this.checked != false ? "checked" : null;
        }
        if (this.value != null && new Boolean(this.value.toString()).booleanValue()) {
            return "checked";
        }
        return null;
    }

    public Boolean getAutowire() {
        return this.autowire;
    }

    public Integer getCols() {
        return this.cols;
    }

    public Boolean getIncludeBlank() {
        return this.includeBlank;
    }

    public Object getItens() {
        return this.itens;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public Integer getRows() {
        return this.rows;
    }

    public Object getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setAutowire(Boolean autowire) {
        this.autowire = autowire;
    }

    public void setCols(Integer cols) {
        this.cols = cols;
    }

    public void setIncludeBlank(Boolean includeBlank) {
        this.includeBlank = includeBlank;
    }

    public void setItens(Object itens) {
        this.itens = itens;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public void setRows(Integer rows) {
        this.rows = rows;
    }

    public void setType(Object type) {
        this.type = type;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getSelectItensString() {
        return this.selectItensString;
    }

    public String getSelectoneblankoption() {
        return this.selectoneblankoption;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Boolean getShowLabel() {
        return this.showLabel;
    }

    public void setShowLabel(Boolean showLabel) {
        this.showLabel = showLabel;
    }

    public String getSelectOnePath() {
        return this.selectOnePath;
    }

    public void setSelectOnePath(String selectOnePath) {
        this.selectOnePath = selectOnePath;
    }

    public Boolean getReloadOnChange() {
        return this.reloadOnChange;
    }

    public void setReloadOnChange(Boolean reloadOnChange) {
        this.reloadOnChange = reloadOnChange;
    }

    public Boolean getOnlyPositiveNumbers() {
        return this.onlyPositiveNumbers;
    }

    public void setOnlyPositiveNumbers(Boolean onlyPositiveNumbers) {
        this.onlyPositiveNumbers = onlyPositiveNumbers;
    }

    public String getTrueFalseNullLabels() {
        return this.trueFalseNullLabels;
    }

    public void setTrueFalseNullLabels(String trueFalseNullValues) {
        this.trueFalseNullLabels = trueFalseNullValues;
    }

    public String getShowRemoverBtn() {
        if (this.value instanceof File) {
            String name2;
            Long cdfile = ((File)this.value).getCdfile();
            try {
                name2 = ((File)this.value).getName();
            }
            catch (Exception e) {
                return "style=\"color: red\"";
            }
            if (Util.strings.isEmpty(name2) || cdfile == null) {
                return "style=\"display: none\"";
            }
            return "";
        }
        return "style=\"display: none\"";
    }

    public String getArquivoLink() {
        if (this.showFileLink.booleanValue()) {
            Long cdfile;
            String fileName;
            try {
                fileName = this.getFileName();
            }
            catch (Exception e) {
                return "<span style=\"color: red\"><B>Erro ao adquirir nome do arquivo.</B> " + e.getMessage() + "</span>";
            }
            if (this.transientFile != null && this.transientFile.booleanValue()) {
                return "<span id=\"" + this.getName() + "_div\">" + fileName + "</span>";
            }
            if (fileName.equals("[vazio]")) {
                return "<span id=\"" + this.getName() + "_div\">" + fileName + "</span>";
            }
            try {
                cdfile = ((File)this.value).getCdfile();
            }
            catch (Exception e) {
                return "<span id=\"" + this.getName() + "_div\" style=\"color: red\"><B>Ocorreu um erro ao adquirir o c\u00f3digo do arquivo.</B> " + e.getMessage() + "</span>";
            }
            DownloadFileServlet.addCdfile(this.getRequest().getSession(), cdfile);
            return cdfile == null ? "<span id=\"" + this.getName() + "_div\">[Escolha o arquivo novamente]</span>" : "<a href=\"" + this.getRequest().getContextPath() + "/DOWNLOADFILE/" + cdfile + "\">" + "<span id=\"" + this.getName() + "_div\">" + fileName + "</span>" + "</a>";
        }
        return "";
    }

    public String getFileValue() {
        if (this.value instanceof File) {
            String name2 = ((File)this.value).getName();
            Long cdfile = ((File)this.value).getCdfile();
            if (Util.strings.isEmpty(name2) || cdfile != null) {
                return "";
            }
            return this.escape(name2);
        }
        return "";
    }

    public String getSelectOneUnselectButtonStyle() {
        if (Util.objects.isEmpty(this.value) || this.value.equals("<null>")) {
            return "display:none";
        }
        return "";
    }

    public String getSelectOneButtonStyle() {
        if (Util.objects.isEmpty(this.value) || this.value.equals("<null>")) {
            return "";
        }
        return "display:none";
    }

    public String getSelectLabelProperty() {
        return this.selectLabelProperty;
    }

    public void setSelectLabelProperty(String selectLabelProperty) {
        this.selectLabelProperty = selectLabelProperty;
    }

    public String getCheckboxValue() {
        return this.checkboxValue;
    }

    public String getLabelStyle() {
        return this.labelStyle;
    }

    public String getLabelStyleClass() {
        return this.labelStyleClass;
    }

    public void setLabelStyle(String labelStyle) {
        this.labelStyle = labelStyle;
    }

    public void setLabelStyleClass(String labelStyleClass) {
        this.labelStyleClass = labelStyleClass;
    }

    public Boolean getUseAjax() {
        return this.useAjax;
    }

    public void setUseAjax(Boolean useAjax) {
        this.useAjax = useAjax;
    }

    public String getOnLoadItens() {
        return this.onLoadItens;
    }

    public void setOnLoadItens(String onLoadItens) {
        this.onLoadItens = onLoadItens;
    }

    public Boolean getAutoSugestUniqueItem() {
        return this.autoSugestUniqueItem;
    }

    public String getBlankLabel() {
        return this.blankLabel;
    }

    public void setAutoSugestUniqueItem(Boolean autoSugestUniqueItem) {
        this.autoSugestUniqueItem = autoSugestUniqueItem;
    }

    public Boolean getBooleanValue() {
        return this.booleanValue;
    }

    public Boolean getTransientFile() {
        return this.transientFile;
    }

    public void setTransientFile(Boolean transientFile) {
        this.transientFile = transientFile;
    }

    public void setBlankLabel(String blankLabel) {
        this.blankLabel = blankLabel;
    }

    public String getOptionalParams() {
        return this.optionalParams;
    }

    public void setOptionalParams(String optionalParams) {
        this.optionalParams = optionalParams;
    }

    public boolean isForceValidation() {
        return this.forceValidation;
    }

    public void setForceValidation(boolean forceValidation) {
        this.forceValidation = forceValidation;
    }

    public boolean isShowRemoverButton() {
        return this.showRemoverButton;
    }

    public void setShowRemoverButton(boolean showRemoverButon) {
        this.showRemoverButton = showRemoverButon;
    }

    public Boolean getHoldValue() {
        return this.holdValue;
    }

    public Boolean getShowFileLink() {
        return this.showFileLink;
    }

    public void setShowFileLink(Boolean showFileLink) {
        this.showFileLink = showFileLink;
    }

    public void setHoldValue(Boolean holdValue) {
        this.holdValue = holdValue;
    }

    public String getInsertPath() {
        return this.insertPath;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getSelectOnePathParameters() {
        return this.selectOnePathParameters;
    }

    public void setInsertPath(String insertPath) {
        this.insertPath = insertPath;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setSelectOnePathParameters(String selectOnePathParameters) {
        this.selectOnePathParameters = selectOnePathParameters;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Type {
        BUTTON,
        CHECKBOX,
        CHECKLIST,
        FILE,
        HIDDEN,
        IMAGE,
        PASSWORD,
        RADIO,
        RESET,
        SUBMIT,
        TEXT,
        DATE,
        TIMESTAMP,
        TIME,
        FLOAT,
        INTEGER,
        MONEY,
        CPF,
        CNPJ,
        CEP,
        INSCRICAO_ESTADUAL,
        CREDIT_CARD,
        SELECT_ONE,
        SELECT_MANY,
        SELECT_ONE_BUTTON,
        SELECT_ONE_RADIO,
        SELECT_ONE_INSERT,
        TEXT_AREA,
        TELEFONE,
        HTML;

    }
}

