/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.view;

import br.com.linkcom.neo.util.Util;
import br.com.linkcom.neo.view.BaseTag;
import br.com.linkcom.neo.view.BeanTag;
import br.com.linkcom.neo.view.ColumnTag;
import br.com.linkcom.neo.view.PanelRenderedBlock;
import br.com.linkcom.neo.view.PropertyTag;
import br.com.linkcom.neo.view.combo.ComboTag;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.jstl.core.LoopTagStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataGridTag
extends BaseTag {
    protected String property;
    protected Object itemType;
    protected Object itens;
    protected String style;
    protected String styleClass = "dataGrid";
    protected String headerStyleClass = "dataGridHeader";
    protected String headerStyle;
    protected String bodyStyleClasses = "dataGridBody1, dataGridBody2";
    protected String bodyStyles;
    protected String footerStyleClass = "dataGridFooter";
    protected String footerStyle;
    protected Boolean dynaLine = false;
    protected String varStatus;
    protected String var = "row";
    protected String varIndex = "index";
    protected String varRowIndex = "rowIndex";
    protected Status currentStatus = Status.REGISTER;
    protected boolean renderHeader = false;
    protected boolean renderBody = false;
    protected boolean renderFooter = false;
    protected List<PanelRenderedBlock> blocks = new ArrayList<PanelRenderedBlock>();
    private Map<String, CyclicIterator> rowAttributes = new LinkedHashMap<String, CyclicIterator>();
    private String rowSeparator;
    private String row;
    protected Object _current;
    protected int _index;
    protected int _count;
    protected boolean _isFirst;
    protected boolean _isLast;
    protected Integer _begin = 0;
    protected Integer _end;
    protected Integer _step = 1;
    Iterator<String> bodyStyleIterator;
    Iterator<String> bodyStyleClassIterator;
    protected List<ColumnTag> columns = new ArrayList<ColumnTag>();
    private boolean hasColumns = false;

    @Override
    protected void doComponent() throws Exception {
        Collection collection;
        String id;
        if (this.itens != null && this.property != null) {
            throw new RuntimeException("O dataGrid n\u00e3o pode ter as propriedades property e itens configuradas ao mesmo tempo. ");
        }
        if (this.itemType != null && this.property != null) {
            throw new RuntimeException("O dataGrid n\u00e3o pode ter as propriedades property e itemType configuradas ao mesmo tempo. ");
        }
        if (this.property != null) {
            PropertyTag propertyTag = new PropertyTag();
            propertyTag.setName(this.property);
            ComboTag.TagHolder tagHolderPropertyTag = new ComboTag.TagHolder(propertyTag);
            this.property = null;
            ComboTag.TagHolder tagHolderDataGrid = new ComboTag.TagHolder(this, "itens", "${value}");
            BeanTag beanTag = new BeanTag();
            beanTag.setJspBody(this.getJspBody());
            tagHolderPropertyTag.addChild(tagHolderDataGrid);
            ComboTag.TagHolder tagHolderBean = new ComboTag.TagHolder(beanTag, "name", this.var, "valueType", "${parameterizedTypes[0]}", "propertyIndex", "${" + this.varIndex + "}", "propertyPrefix", "${name}");
            tagHolderDataGrid.addChild(tagHolderBean);
            ComboTag.TagHolderFragment fragment = new ComboTag.TagHolderFragment(this.getJspContext(), Arrays.asList(tagHolderPropertyTag), this);
            fragment.invoke((Writer)this.getOut());
            return;
        }
        if (this.itemType != null) {
            Class itemClass;
            if (!(this.itemType instanceof String) && !(this.itemType instanceof Class)) {
                throw new RuntimeException("O atributo item type deve ser do typo String ou Class");
            }
            try {
                itemClass = this.itemType instanceof Class ? this.itemType : Class.forName((String)this.itemType);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Atributo itemType inv\u00e1lido: " + this.itemType, e);
            }
            BeanTag beanTag = new BeanTag();
            beanTag.setName(this.var);
            beanTag.setValueType(itemClass);
            beanTag.setJspBody(this.getJspBody());
            ComboTag.TagHolder tagHolderBeanTag = new ComboTag.TagHolder(beanTag);
            this.itemType = null;
            ComboTag.TagHolder tagHolderDataGrid = new ComboTag.TagHolder(this);
            tagHolderDataGrid.addChild(tagHolderBeanTag);
            ComboTag.TagHolderFragment fragment = new ComboTag.TagHolderFragment(this.getJspContext(), Arrays.asList(tagHolderDataGrid), this.getParent());
            fragment.invoke((Writer)this.getOut());
            return;
        }
        Object requestObject = this.getRequest().getAttribute(this.var);
        Object sessionObject = this.getRequest().getSession().getAttribute(this.var);
        Object contextAttribute = this.getRequest().getSession().getServletContext().getAttribute(this.var);
        this.getRequest().setAttribute(this.var, null);
        this.getRequest().getSession().setAttribute(this.var, null);
        this.getRequest().getSession().getServletContext().setAttribute(this.var, null);
        if (this.itens != null && this.itens instanceof String) {
            String expression = (String)this.itens;
            Collection value = this.getOgnlValue(expression, Collection.class);
            this.itens = value;
        }
        if (this.itens != null && this.itens.getClass().isArray() && !this.itens.getClass().getComponentType().isPrimitive()) {
            Object[] array = (Object[])this.itens;
            this.itens = new ArrayList();
            int i = 0;
            while (i < array.length) {
                ((List)this.itens).add(array[i]);
                ++i;
            }
        }
        if (this.itens == null) {
            this.itens = new ArrayList();
        }
        if (!(this.itens instanceof Collection)) {
            throw new IllegalArgumentException("Tipo de itens n\u00e3o suportado por dataGrid: " + this.itens);
        }
        this.bodyStyleIterator = this.getBodyStyles();
        this.bodyStyleClassIterator = this.getBodyStyleClasses();
        LinkedHashSet daKeys = new LinkedHashSet(this.getDynamicAttributesMap().keySet());
        for (String daKey : daKeys) {
            if (!daKey.startsWith("row")) continue;
            CyclicIterator cyclicIterator = new CyclicIterator(this.toStringArray(this.getDynamicAttributesMap().get(daKey)));
            this.rowAttributes.put(daKey.substring(3), cyclicIterator);
            this.getDynamicAttributesMap().remove(daKey);
        }
        String styleString = this.style != null ? " style=\"" + this.style + "\"" : "";
        String classString = this.styleClass != null ? " class=\"" + this.styleClass + "\"" : "";
        String string = id = this.id == null ? "" : "id=\"" + this.id + "\"";
        if (!this.getDynamicAttributesMap().containsKey("width")) {
            this.getDynamicAttributesMap().put("width", "100%");
        }
        if (!this.getDynamicAttributesMap().containsKey("cellspacing")) {
            this.getDynamicAttributesMap().put("cellspacing", "1");
        }
        if (this.getJspBody() != null) {
            PrintWriter writer = new PrintWriter(new ByteArrayOutputStream());
            this.getJspBody().invoke((Writer)writer);
        }
        if (this.hasColumns) {
            this.getOut().println("<table" + styleString + classString + this.getDynamicAttributesToString() + id + ">");
            if (this.renderHeader) {
                this.currentStatus = Status.HEADER;
                this.renderHeader();
            }
            collection = (Collection)this.itens;
            if (Util.strings.isNotEmpty(this.varStatus)) {
                this.getRequest().setAttribute(this.varStatus, (Object)this.getLoopTagStatus());
            }
            this.currentStatus = Status.BODY;
            this._count = collection.size();
            if (this._end == null) {
                this._end = this._count - 1;
            }
            this.getOut().print("<tbody>");
            this.iterate(collection);
            this.getOut().print("</tbody>");
            if (this.renderFooter) {
                this.currentStatus = Status.FOOTER;
                this.renderFooter();
            }
            this.getOut().println("</table>");
            if (this.dynaLine.booleanValue()) {
                this.currentStatus = Status.DYNALINE;
                this.pushAttribute("dataGridDynaline", true);
                this.renderDynaLine();
                this.popAttribute("dataGridDynaline");
            }
        } else {
            collection = (Collection)this.itens;
            if (Util.strings.isNotEmpty(this.varStatus)) {
                this.getRequest().setAttribute(this.varStatus, (Object)this.getLoopTagStatus());
            }
            this.currentStatus = Status.BODY;
            this._count = collection.size();
            if (this._end == null) {
                this._end = this._count - 1;
            }
            this.iterate(collection);
        }
        this.getRequest().setAttribute(this.var, requestObject);
        this.getRequest().getSession().setAttribute(this.var, sessionObject);
        this.getRequest().getSession().getServletContext().setAttribute(this.var, contextAttribute);
    }

    private String[] toStringArray(Object object) {
        if (object == null) {
            object = "";
        }
        if (this.rowSeparator == null) {
            return new String[]{object.toString()};
        }
        return object.toString().split(this.rowSeparator);
    }

    private void renderDynaLine() throws ELException, IOException, JspException, ServletException {
        this.getRequest().setAttribute(this.var, null);
        this.getRequest().setAttribute(this.varIndex, (Object)"{index}");
        this.getRequest().setAttribute(this.varRowIndex, (Object)"{indexplus}");
        this.doBody();
        this.getOut().println("<script language=\"javascript\">");
        ArrayList<String> tdBodys = new ArrayList<String>();
        for (PanelRenderedBlock block : this.blocks) {
            tdBodys.add(block.body);
        }
        this.getOut().println(this.enhanceProperty(this.id, "trClassModel", Util.strings.isEmpty(this.bodyStyleClasses) ? Arrays.asList("") : Arrays.asList(this.bodyStyleClasses.split(","))));
        this.getOut().println(this.enhanceProperty(this.id, "tdClassModel", Arrays.asList("")));
        this.getOut().println(this.enhanceProperty(this.id, "dataModel", tdBodys));
        this.getOut().println(this.enhanceProperty(this.id, "indexName", "{index}"));
        this.getOut().println(this.enhanceProperty(this.id, "indexPlusName", "{indexplus}"));
        this.includeTextTemplate("newLineFunction");
        this.getOut().println("</script>");
    }

    private void renderHeader() throws ELException, IOException, JspException {
        String styleString = this.headerStyle != null ? " style=\"" + this.headerStyle + "\"" : "";
        String classString = this.headerStyleClass != null ? " class=\"" + this.headerStyleClass + "\"" : "";
        this.getOut().print("<thead>");
        this.getOut().print("<tr" + styleString + classString + ">");
        this.doBody();
        this.getOut().print("</tr>");
        this.getOut().print("</thead>");
    }

    protected void renderBody(Object current) throws ELException, IOException, JspException {
        String classString;
        String style = this.bodyStyleIterator.next();
        String styleClass = this.bodyStyleClassIterator.next();
        String styleString = style != null ? " style=\"" + style + "\"" : "";
        String string = classString = styleClass != null ? " class=\"" + styleClass + "\"" : "";
        if (this.hasColumns) {
            String daattributes = "";
            Set<String> attributes = this.rowAttributes.keySet();
            for (String attr : attributes) {
                daattributes = String.valueOf(daattributes) + " " + attr + "=\"" + this.escape(this.rowAttributes.get(attr).next()) + "\"";
            }
            this.renderRow(styleString, classString, daattributes, current);
        } else {
            this.doBody();
        }
    }

    protected void renderRow(String styleString, String classString, String daattributes, Object current) throws IOException, JspException {
        this.getOut().print("<tr" + styleString + classString + daattributes + ">");
        this.doBody();
        this.getOut().print("</tr>");
    }

    private void renderFooter() throws ELException, IOException, JspException {
        String styleString = this.footerStyle != null ? " style=\"" + this.footerStyle + "\"" : "";
        String classString = this.footerStyleClass != null ? " class=\"" + this.footerStyleClass + "\"" : "";
        this.getOut().print("<tr" + styleString + classString + ">");
        this.doBody();
        this.getOut().print("</tr>");
    }

    private void iterate(Collection collection) throws ELException, IOException, JspException {
        this._isFirst = true;
        for (Object this._current : collection) {
            this.getRequest().setAttribute(this.var, this._current);
            this.getRequest().setAttribute(this.varIndex, (Object)this._index);
            this.getRequest().setAttribute(this.varRowIndex, (Object)(this._index + 1));
            this.renderBody(this._current);
            ++this._index;
        }
        this._current = null;
        this.getRequest().setAttribute(this.var, null);
        this.getRequest().setAttribute(this.varIndex, null);
    }

    public void registerColumn(ColumnTag columnTag) {
        this.columns.add(columnTag);
    }

    private LoopTagStatus getLoopTagStatus() {
        return new LoopTagStatus(){

            public Object getCurrent() {
                return DataGridTag.this._current;
            }

            public int getIndex() {
                return DataGridTag.this._index;
            }

            public int getCount() {
                return DataGridTag.this._count;
            }

            public boolean isFirst() {
                return DataGridTag.this._isFirst;
            }

            public boolean isLast() {
                return DataGridTag.this._isLast;
            }

            public Integer getBegin() {
                return DataGridTag.this._begin;
            }

            public Integer getEnd() {
                return DataGridTag.this._end;
            }

            public Integer getStep() {
                return DataGridTag.this._step;
            }
        };
    }

    private CyclicIterator getBodyStyleClasses() {
        if (Util.strings.isEmpty(this.bodyStyleClasses)) {
            return new CyclicIterator(null);
        }
        return new CyclicIterator(this.bodyStyleClasses.split(","));
    }

    private CyclicIterator getBodyStyles() {
        if (Util.strings.isEmpty(this.bodyStyles)) {
            return new CyclicIterator(null);
        }
        return new CyclicIterator(this.bodyStyles.split(","));
    }

    public Status getCurrentStatus() {
        return this.currentStatus;
    }

    public String getFooterStyle() {
        return this.footerStyle;
    }

    public String getFooterStyleClass() {
        return this.footerStyleClass;
    }

    public String getHeaderStyle() {
        return this.headerStyle;
    }

    public String getHeaderStyleClass() {
        return this.headerStyleClass;
    }

    public Object getItens() {
        return this.itens;
    }

    public void setBodyStyleClasses(String bodyStyleClasses) {
        this.bodyStyleClasses = bodyStyleClasses;
    }

    public void setBodyStyles(String bodyStyles) {
        this.bodyStyles = bodyStyles;
    }

    public void setFooterStyle(String footerStyle) {
        this.footerStyle = footerStyle;
    }

    public void setFooterStyleClass(String footerStyleClass) {
        this.footerStyleClass = footerStyleClass;
    }

    public void setHeaderStyle(String headerStyle) {
        this.headerStyle = headerStyle;
    }

    public void setHeaderStyleClass(String headerStyleClass) {
        this.headerStyleClass = headerStyleClass;
    }

    public void setItens(Object itens) {
        this.itens = itens;
    }

    public String getVar() {
        return this.var;
    }

    public String getVarStatus() {
        return this.varStatus;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setVarStatus(String varStatus) {
        this.varStatus = varStatus;
    }

    public boolean isRenderBody() {
        return this.renderBody;
    }

    public boolean isRenderFooter() {
        return this.renderFooter;
    }

    public boolean isRenderHeader() {
        return this.renderHeader;
    }

    public void setRenderBody(boolean renderBody) {
        this.renderBody = renderBody;
    }

    public void setRenderFooter(boolean renderFooter) {
        this.renderFooter = renderFooter;
    }

    public void setRenderHeader(boolean renderHeader) {
        this.renderHeader = renderHeader;
    }

    @Override
    public String getBody() throws JspException, IOException {
        return super.getBody();
    }

    public Boolean getDynaLine() {
        return this.dynaLine;
    }

    public String getVarIndex() {
        return this.varIndex;
    }

    public void setDynaLine(Boolean dynaLine) {
        this.dynaLine = dynaLine;
    }

    public void setVarIndex(String varIndex) {
        this.varIndex = varIndex;
    }

    public boolean add(PanelRenderedBlock o) {
        return this.blocks.add(o);
    }

    public String enhanceProperty(String id, String propertyName, String value) {
        return "document.getElementById('" + id + "')." + propertyName + " = \"" + value + "\";";
    }

    public String enhanceProperty(String id, String propertyName, List<String> value) {
        return "document.getElementById('" + id + "')." + propertyName + " = [\n" + this.toStringEnhancedProperty(value) + "\n];";
    }

    private String toStringEnhancedProperty(List<String> value) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        int lastIndex = value.size() - 1;
        for (String string : value) {
            boolean isLast = i == lastIndex;
            string = string.replaceAll("\n", " ");
            string = string.replaceAll("\t", " ");
            string = string.replaceAll("\r", " ");
            string = this.escape(string.trim());
            string = "\"" + string + "\"";
            if (!isLast) {
                string = String.valueOf(string) + ", \n";
            }
            builder.append(string);
            ++i;
        }
        return builder.toString();
    }

    public String getVarRowIndex() {
        return this.varRowIndex;
    }

    public void setVarRowIndex(String varRowIndex) {
        this.varRowIndex = varRowIndex;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setHasColumns(boolean b) {
        this.hasColumns = b;
    }

    public String getRow() {
        return this.row;
    }

    public String getRowSeparator() {
        return this.rowSeparator;
    }

    public void setRow(String row) {
        this.row = row;
    }

    public void setRowSeparator(String rowSeparator) {
        this.rowSeparator = rowSeparator;
    }

    public Object getItemType() {
        return this.itemType;
    }

    public void setItemType(Object itemType) {
        this.itemType = itemType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CyclicIterator
    implements Iterator<String> {
        private String[] strings;
        int i = 0;

        public CyclicIterator(String[] strings) {
            this.strings = strings;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public String next() {
            if (this.strings == null || this.strings.length == 0) {
                return null;
            }
            if (this.i >= this.strings.length) {
                this.i = 0;
            }
            return this.strings[this.i++];
        }

        public String[] getStrings() {
            return this.strings;
        }

        @Override
        public void remove() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        REGISTER,
        HEADER,
        BODY,
        DYNALINE,
        FOOTER;

    }
}

