/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.validation.validators;

import br.com.linkcom.neo.validation.JavascriptValidationItem;
import br.com.linkcom.neo.validation.ObjectAnnotationValidator;
import br.com.linkcom.neo.validation.PropertyValidator;
import br.com.linkcom.neo.validation.ValidatorMapper;
import br.com.linkcom.neo.validation.annotation.MinValue;
import java.lang.annotation.Annotation;
import java.text.NumberFormat;
import java.util.List;
import org.springframework.validation.Errors;

public class MinValueValidator
implements PropertyValidator {
    public void validate(Object bean, Object property, String fieldName, String fieldDisplayName, Annotation annotation, Errors errors, ObjectAnnotationValidator annotationValidator) {
        if (property != null && !property.toString().trim().equals("")) {
            MinValue minValue = (MinValue)annotation;
            double min = minValue.value();
            if (Double.parseDouble(property.toString()) < min) {
                errors.rejectValue(fieldName, "minValue", "O campo " + fieldDisplayName + " deve ter um valor maior ou igual a " + min + ".");
            }
        }
    }

    public String getValidationName() {
        return "floatMinValue";
    }

    public String getValidationFunctionName() {
        return "FloatMinValue";
    }

    public String getJavascriptFunctionPath() {
        return "br/com/linkcom/neo/validation/validators/javascript/validateFloatMinValue.js";
    }

    public String getJavascriptFunction(JavascriptValidationItem validationItem) {
        List<ValidatorMapper> validations = validationItem.getValidations();
        double min = 0.0;
        for (ValidatorMapper mapper : validations) {
            if (!MinValue.class.isAssignableFrom(mapper.getAnnotation().getClass())) continue;
            min = ((MinValue)mapper.getAnnotation()).value();
            break;
        }
        return "new Function (\"varName\", \"this.min='" + min + "';  return this[varName];\")";
    }

    public String getMessage(JavascriptValidationItem validationItem) {
        List<ValidatorMapper> validations = validationItem.getValidations();
        double min = 0.0;
        for (ValidatorMapper mapper : validations) {
            if (!MinValue.class.isAssignableFrom(mapper.getAnnotation().getClass())) continue;
            min = ((MinValue)mapper.getAnnotation()).value();
            break;
        }
        String minValue = String.valueOf(min);
        if (new Integer((int)min).doubleValue() == min) {
            minValue = NumberFormat.getIntegerInstance().format(min);
        }
        return "O campo " + validationItem.getFieldDisplayName() + " deve ter valor maior ou igual a " + minValue + ".";
    }
}

