/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.validation.validators;

import br.com.linkcom.neo.validation.JavascriptValidationItem;
import br.com.linkcom.neo.validation.ObjectAnnotationValidator;
import br.com.linkcom.neo.validation.PropertyValidator;
import br.com.linkcom.neo.validation.ValidatorMapper;
import br.com.linkcom.neo.validation.annotation.MaxValue;
import java.lang.annotation.Annotation;
import java.text.NumberFormat;
import java.util.List;
import org.springframework.validation.Errors;

public class MaxValueValidator
implements PropertyValidator {
    public void validate(Object bean, Object property, String fieldName, String fieldDisplayName, Annotation annotation, Errors errors, ObjectAnnotationValidator annotationValidator) {
        if (property != null && !property.toString().trim().equals("")) {
            MaxValue maxValue = (MaxValue)annotation;
            double max = maxValue.value();
            if (Double.parseDouble(property.toString()) > max) {
                errors.rejectValue(fieldName, "maxValue", "O campo " + fieldDisplayName + " deve ter um valor menor ou igual a " + max + ".");
            }
        }
    }

    public String getValidationName() {
        return "floatMaxValue";
    }

    public String getValidationFunctionName() {
        return "FloatMaxValue";
    }

    public String getJavascriptFunctionPath() {
        return "br/com/linkcom/neo/validation/validators/javascript/validateFloatMaxValue.js";
    }

    public String getJavascriptFunction(JavascriptValidationItem validationItem) {
        List<ValidatorMapper> validations = validationItem.getValidations();
        double max = 0.0;
        for (ValidatorMapper mapper : validations) {
            if (!MaxValue.class.isAssignableFrom(mapper.getAnnotation().getClass())) continue;
            max = ((MaxValue)mapper.getAnnotation()).value();
            break;
        }
        return "new Function (\"varName\", \"this.max='" + max + "';  return this[varName];\")";
    }

    public String getMessage(JavascriptValidationItem validationItem) {
        List<ValidatorMapper> validations = validationItem.getValidations();
        double max = 0.0;
        for (ValidatorMapper mapper : validations) {
            if (!MaxValue.class.isAssignableFrom(mapper.getAnnotation().getClass())) continue;
            max = ((MaxValue)mapper.getAnnotation()).value();
            break;
        }
        String maxValue = String.valueOf(max);
        if (new Integer((int)max).doubleValue() == max) {
            maxValue = NumberFormat.getIntegerInstance().format(max);
        }
        return "O campo " + validationItem.getFieldDisplayName() + " deve ter valor menor ou igual a " + maxValue + ".";
    }
}

