/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.validation.validators;

import br.com.linkcom.neo.validation.JavascriptValidationItem;
import br.com.linkcom.neo.validation.ObjectAnnotationValidator;
import br.com.linkcom.neo.validation.PropertyValidator;
import br.com.linkcom.neo.validation.ValidatorMapper;
import br.com.linkcom.neo.validation.annotation.MaxLength;
import java.lang.annotation.Annotation;
import java.util.List;
import org.apache.commons.validator.GenericValidator;
import org.springframework.validation.Errors;

public class MaxLengthValidator
implements PropertyValidator {
    public void validate(Object bean, Object property, String fieldName, String fieldDisplayName, Annotation annotation, Errors errors, ObjectAnnotationValidator annotationValidator) {
        if (property != null && !property.toString().trim().equals("")) {
            MaxLength maxLength = (MaxLength)annotation;
            int max = maxLength.value();
            if (!GenericValidator.maxLength((String)property.toString(), (int)max)) {
                errors.rejectValue(fieldName, "maxLenght", "O campo " + fieldDisplayName + " deve ter um tamanho menor ou igual \u00e0 " + max + ".");
            }
        }
    }

    public String getValidationName() {
        return "maxlength";
    }

    public String getValidationFunctionName() {
        return "MaxLength";
    }

    public String getJavascriptFunctionPath() {
        return "br/com/linkcom/neo/validation/validators/javascript/validateMaxLength.js";
    }

    public String getJavascriptFunction(JavascriptValidationItem validationItem) {
        List<ValidatorMapper> validations = validationItem.getValidations();
        int max = 0;
        for (ValidatorMapper mapper : validations) {
            if (!MaxLength.class.isAssignableFrom(mapper.getAnnotation().getClass())) continue;
            max = ((MaxLength)mapper.getAnnotation()).value();
            break;
        }
        return "new Function (\"varName\", \"this.maxlength='" + max + "';  return this[varName];\")";
    }

    public String getMessage(JavascriptValidationItem validationItem) {
        List<ValidatorMapper> validations = validationItem.getValidations();
        int max = 0;
        for (ValidatorMapper mapper : validations) {
            if (!MaxLength.class.isAssignableFrom(mapper.getAnnotation().getClass())) continue;
            max = ((MaxLength)mapper.getAnnotation()).value();
            break;
        }
        return "O campo " + validationItem.getFieldDisplayName() + " comporta no m\u00e1ximo " + max + " caracteres.";
    }
}

