/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.validation.validators;

import br.com.linkcom.neo.core.config.ValidatorRegistry;
import br.com.linkcom.neo.validation.JavascriptValidationItem;
import br.com.linkcom.neo.validation.PropertyValidator;
import br.com.linkcom.neo.validation.validators.ValidationHolder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavascriptValidationFunctionBuilder {
    protected List<JavascriptValidationItem> validations;
    protected String formName;
    protected ValidatorRegistry validatorRegistry;
    protected ServletContext context;
    private String functionName;

    public JavascriptValidationFunctionBuilder(List<JavascriptValidationItem> validations, String formName, String functionName, ValidatorRegistry validatorRegistry, ServletContext context) {
        this.validations = validations;
        this.formName = formName;
        this.context = context;
        this.validatorRegistry = validatorRegistry;
        this.functionName = functionName;
    }

    public String buildValidation() {
        if (this.validations.size() == 0) {
            return "    function " + this.functionName + "() {return true}";
        }
        ValidationHolder holder = new ValidationHolder(this.validations, this.validatorRegistry);
        StringBuilder builder = new StringBuilder();
        builder.append("<!-- Begin ").append("\n");
        builder.append("    var bCancel = false; ").append("\n");
        builder.append("    function " + this.functionName + "() {").append("\n");
        builder.append("       var formObject = document.getElementsByName('" + this.formName + "')[0];").append("\n");
        builder.append("       if (bCancel) ").append("\n");
        builder.append("            return true; ").append("\n");
        builder.append("        try{organizeProperties(formObject);}catch(e){} ").append("\n");
        builder.append("        var formValidationResult;").append("\n");
        builder.append("        try {").append("\n");
        builder.append("        formValidationResult =");
        Set<PropertyValidator> propertyValidators = holder.getValidationMap().keySet();
        Iterator<PropertyValidator> iter = propertyValidators.iterator();
        while (iter.hasNext()) {
            PropertyValidator propertyValidator = iter.next();
            builder.append(" validate" + StringUtils.capitalize((String)propertyValidator.getValidationFunctionName()) + "(formObject)");
            if (!iter.hasNext()) continue;
            builder.append(" &&");
        }
        builder.append(";").append("\n");
        builder.append("        return (formValidationResult == 1);").append("\n");
        builder.append("        } catch(e){ return true;}").append("\n");
        builder.append("    }").append("\n");
        for (PropertyValidator validator : propertyValidators) {
            builder.append((CharSequence)this.createValidationFunction(validator, holder.getValidationMap().get(validator)));
        }
        builder.append(" //End --> ").append("\n");
        return builder.toString();
    }

    protected StringBuilder createValidationFunction(PropertyValidator validator, List<JavascriptValidationItem> javascriptValidationItens) {
        StringBuilder builder = new StringBuilder();
        builder.append("function " + this.formName + "_" + validator.getValidationName() + "() {\n");
        int index = 0;
        ArrayList<String> names = new ArrayList<String>();
        for (JavascriptValidationItem item : javascriptValidationItens) {
            if (this.isIndexed(item.getFieldName())) {
                String[] property = this.separateIndexedProperty(item.getFieldName());
                String function = validator.getJavascriptFunction(item);
                if (names.contains(String.valueOf(property[0]) + "[]" + property[1])) continue;
                names.add(String.valueOf(property[0]) + "[]" + property[1]);
                builder.append("  formIndexedProperties(this, \"a" + index + "\", \"" + property[1] + "\", \"" + validator.getMessage(item) + "\", " + function + ", \"" + property[0] + "\", " + this.formName + ");\n");
            } else {
                String function = validator.getJavascriptFunction(item);
                builder.append("  this.a" + index + " = new Array(\"" + item.getFieldName() + "\", \"" + validator.getMessage(item) + "\", " + function + ");\n");
            }
            ++index;
        }
        builder.append("}\n\n");
        return builder;
    }

    private String[] separateIndexedProperty(String fieldName) {
        int oi = fieldName.lastIndexOf(91);
        int ci = fieldName.lastIndexOf(93);
        String indexedProperty = fieldName.substring(0, oi);
        String property = fieldName.substring(ci + 2);
        return new String[]{indexedProperty, property};
    }

    private boolean isIndexed(String fieldName) {
        return fieldName.indexOf(91) > 0;
    }
}

