/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.validation.validators;

import br.com.linkcom.neo.validation.JavascriptValidationItem;
import br.com.linkcom.neo.validation.ObjectAnnotationValidator;
import br.com.linkcom.neo.validation.PropertyValidator;
import java.lang.annotation.Annotation;
import org.apache.commons.validator.GenericValidator;
import org.springframework.validation.Errors;

public class EmailValidator
implements PropertyValidator {
    public void validate(Object bean, Object property, String fieldName, String fieldDisplayName, Annotation annotation, Errors errors, ObjectAnnotationValidator annotationValidator) {
        if (property != null && !property.toString().trim().equals("") && !GenericValidator.isEmail((String)property.toString())) {
            errors.rejectValue(fieldName, "email", "O campo " + fieldDisplayName + " deve ser um email.");
        }
    }

    public String getValidationName() {
        return "email";
    }

    public String getJavascriptFunctionPath() {
        return "br/com/linkcom/neo/validation/validators/javascript/validateEmail.js";
    }

    public String getMessage(JavascriptValidationItem validationItem) {
        return "O campo " + validationItem.getFieldDisplayName() + " deve ser um email.";
    }

    public String getJavascriptFunction(JavascriptValidationItem validationItem) {
        return "new Function (\"varName\", \" return this[varName];\")";
    }

    public String getValidationFunctionName() {
        return "Email";
    }
}

