/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.validation;

import br.com.linkcom.neo.core.config.ValidatorRegistry;
import br.com.linkcom.neo.types.Cep;
import br.com.linkcom.neo.types.Cnpj;
import br.com.linkcom.neo.types.Cpf;
import br.com.linkcom.neo.types.Hora;
import br.com.linkcom.neo.types.InscricaoEstadual;
import br.com.linkcom.neo.types.Telefone;
import br.com.linkcom.neo.validation.PropertyValidator;
import br.com.linkcom.neo.validation.ValidatorAnnotationExtractor;
import br.com.linkcom.neo.validation.ValidatorAnnotationExtractorImpl;
import br.com.linkcom.neo.validation.annotation.Email;
import br.com.linkcom.neo.validation.annotation.MaxLength;
import br.com.linkcom.neo.validation.annotation.MaxValue;
import br.com.linkcom.neo.validation.annotation.MinLength;
import br.com.linkcom.neo.validation.annotation.MinValue;
import br.com.linkcom.neo.validation.annotation.Required;
import br.com.linkcom.neo.validation.annotation.Year;
import br.com.linkcom.neo.validation.validators.ByteValidator;
import br.com.linkcom.neo.validation.validators.CepValidator;
import br.com.linkcom.neo.validation.validators.CnpjValidator;
import br.com.linkcom.neo.validation.validators.CpfValidator;
import br.com.linkcom.neo.validation.validators.DateValidator;
import br.com.linkcom.neo.validation.validators.EmailValidator;
import br.com.linkcom.neo.validation.validators.FloatValidator;
import br.com.linkcom.neo.validation.validators.InscricaoEstadualValidator;
import br.com.linkcom.neo.validation.validators.IntegerValidator;
import br.com.linkcom.neo.validation.validators.MaxLengthValidator;
import br.com.linkcom.neo.validation.validators.MaxValueValidator;
import br.com.linkcom.neo.validation.validators.MinLengthValidator;
import br.com.linkcom.neo.validation.validators.MinValueValidator;
import br.com.linkcom.neo.validation.validators.RequiredValidator;
import br.com.linkcom.neo.validation.validators.ShortValidator;
import br.com.linkcom.neo.validation.validators.TelefoneValidator;
import br.com.linkcom.neo.validation.validators.TimeValidator;
import br.com.linkcom.neo.validation.validators.YearValidator;
import java.lang.annotation.Annotation;
import java.sql.Date;
import java.sql.Time;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorRegistryImpl
implements ValidatorRegistry {
    protected Map<Class<? extends Annotation>, PropertyValidator> validators = new HashMap<Class<? extends Annotation>, PropertyValidator>();
    protected Map<Class<?>, PropertyValidator> typeValidators = new HashMap();
    protected Map<String, PropertyValidator> typeValidatorsString = new HashMap<String, PropertyValidator>();
    protected ValidatorAnnotationExtractor annotationExtractor = new ValidatorAnnotationExtractorImpl(this);

    public ValidatorRegistryImpl() {
        this.register(Required.class, new RequiredValidator());
        this.register(Email.class, new EmailValidator());
        this.register(MaxLength.class, new MaxLengthValidator());
        this.register(MinLength.class, new MinLengthValidator());
        this.register(MaxValue.class, new MaxValueValidator());
        this.register(MinValue.class, new MinValueValidator());
        this.register(Year.class, new YearValidator());
        this.registerType(Float.class, new FloatValidator());
        this.registerType(Double.class, new FloatValidator());
        this.registerType(Integer.class, new IntegerValidator());
        this.registerType(Long.class, new IntegerValidator());
        this.registerType(Byte.class, new ByteValidator());
        this.registerType(Short.class, new ShortValidator());
        this.registerType(Date.class, new DateValidator());
        this.registerType(java.util.Date.class, new DateValidator());
        this.registerType(Time.class, new TimeValidator());
        this.registerType(Hora.class, new TimeValidator());
        this.registerType(Cpf.class, new CpfValidator());
        this.registerType(Cnpj.class, new CnpjValidator());
        this.registerType(InscricaoEstadual.class, new InscricaoEstadualValidator());
        this.registerType(Cep.class, new CepValidator());
        this.registerType(Telefone.class, new TelefoneValidator());
    }

    @Override
    public PropertyValidator getPropertyValidator(Class<? extends Annotation> key) {
        return this.validators.get(key);
    }

    @Override
    public PropertyValidator getTypeValidator(Class<?> key) {
        return this.typeValidators.get(key);
    }

    public PropertyValidator register(Class<? extends Annotation> key, PropertyValidator value) {
        return this.validators.put(key, value);
    }

    public PropertyValidator registerType(Class<?> key, PropertyValidator value) {
        return this.typeValidators.put(key, value);
    }

    public void clear() {
        this.validators.clear();
        this.typeValidators.clear();
    }

    @Override
    public ValidatorAnnotationExtractor getExtractor() {
        return this.annotationExtractor;
    }

    @Override
    public PropertyValidator getTypeValidator(String key) {
        return this.typeValidatorsString.get(key);
    }
}

