/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.validation;

import br.com.linkcom.neo.core.config.ValidatorRegistry;
import br.com.linkcom.neo.validation.PropertyValidator;
import br.com.linkcom.neo.validation.ValidationItem;
import br.com.linkcom.neo.validation.ValidatorAnnotationExtractor;
import br.com.linkcom.neo.validation.ValidatorMapper;
import br.com.linkcom.neo.validation.annotation.ValidationOverride;
import br.com.linkcom.neo.validation.annotation.ValidationOverrides;
import java.lang.annotation.Annotation;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorAnnotationExtractorImpl
implements ValidatorAnnotationExtractor {
    public static final String VALIDATOR_ANNOTATION_EXTRACTOR_BEAN_NAME = "validatorAnnotationExtractor";
    protected ValidatorRegistry validatorRegistry;

    public ValidatorAnnotationExtractorImpl(ValidatorRegistry registry) {
        this.validatorRegistry = registry;
    }

    @Override
    public ValidationItem getValidationItem(String fieldName, Class<?> type, Annotation[] annotations) {
        Annotation[] methodAnnotations;
        ValidationItem validationItem = new ValidationItem();
        validationItem.setFieldName(fieldName);
        Annotation[] annotationArray = methodAnnotations = annotations;
        int n = methodAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (this.validatorRegistry.getPropertyValidator(annotation.annotationType()) != null) {
                validationItem.addValidation(annotation);
            }
            ++n2;
        }
        Class<?> returnType = type;
        PropertyValidator typeValidator = this.validatorRegistry.getTypeValidator(returnType);
        if (typeValidator != null) {
            validationItem.setTypeValidator(typeValidator);
        }
        return validationItem;
    }

    @Override
    public ValidationItem getValidationItem(String fieldName, String type, Annotation[] annotations) {
        Annotation[] methodAnnotations;
        ValidationItem validationItem = new ValidationItem();
        validationItem.setFieldName(fieldName);
        Annotation[] annotationArray = methodAnnotations = annotations;
        int n = methodAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (this.validatorRegistry.getPropertyValidator(annotation.annotationType()) != null) {
                validationItem.addValidation(annotation);
            }
            ++n2;
        }
        String returnType = type;
        PropertyValidator typeValidator = this.validatorRegistry.getTypeValidator(returnType);
        if (typeValidator != null) {
            validationItem.setTypeValidator(typeValidator);
        }
        return validationItem;
    }

    @Override
    public boolean overrideValidation(ValidationItem validationItem, String name, Annotation[] annotations) {
        if (name != null && name.contains(".")) {
            Annotation[] annotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (annotation.annotationType().equals(ValidationOverride.class)) {
                    ValidationOverride override = (ValidationOverride)annotation;
                    this.clearValidationItemList(validationItem);
                    if (override.field().equals(name)) {
                        this.setAnnotationValidators(validationItem, override);
                        return true;
                    }
                }
                if (annotation.annotationType().equals(ValidationOverrides.class)) {
                    ValidationOverride[] override;
                    this.clearValidationItemList(validationItem);
                    ValidationOverrides overrides = (ValidationOverrides)annotation;
                    ValidationOverride[] validationOverrideArray = override = overrides.value();
                    int n3 = override.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ValidationOverride validationOverride = validationOverrideArray[n4];
                        if (validationOverride.field().equals(name)) {
                            this.setAnnotationValidators(validationItem, validationOverride);
                            return true;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    private void clearValidationItemList(ValidationItem item) {
        item.setValidations(new ArrayList<ValidatorMapper>());
    }

    private void setAnnotationValidators(ValidationItem validationItem, ValidationOverride override) {
        if (override.email().length > 0) {
            validationItem.addValidation(override.email()[0]);
        }
        if (override.maxLength().length > 0) {
            validationItem.addValidation(override.maxLength()[0]);
        }
        if (override.minValue().length > 0) {
            validationItem.addValidation(override.minValue()[0]);
        }
        if (override.regex().length > 0) {
            validationItem.addValidation(override.regex()[0]);
        }
        if (override.required().length > 0) {
            validationItem.addValidation(override.required()[0]);
        }
        if (override.year().length > 0) {
            validationItem.addValidation(override.year()[0]);
        }
    }
}

