/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.validation;

import br.com.linkcom.neo.core.config.ValidatorRegistry;
import br.com.linkcom.neo.core.standard.Neo;
import br.com.linkcom.neo.exception.NeoException;
import br.com.linkcom.neo.validation.PropertyValidator;
import br.com.linkcom.neo.validation.ValidatorMapper;
import br.com.linkcom.neo.validation.validators.RequiredValidator;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationItem {
    protected List<ValidatorMapper> validations = new ArrayList<ValidatorMapper>();
    protected String fieldName;
    protected PropertyValidator typeValidator;

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public ValidationItem(String fieldName, List<ValidatorMapper> validations) {
        this.fieldName = fieldName;
        this.validations = validations;
    }

    public ValidationItem() {
    }

    public List<ValidatorMapper> getValidations() {
        return this.validations;
    }

    public void setValidations(List<ValidatorMapper> validations) {
        this.validations = validations;
    }

    public boolean addValidation(Annotation o) {
        if (o == null) {
            throw new NeoException("A annotation n\u00e3o deve ser null");
        }
        ValidatorRegistry validatorRegistry = Neo.getApplicationContext().getConfig().getValidatorRegistry();
        return this.validations.add(new ValidatorMapper(validatorRegistry.getPropertyValidator(o.annotationType()), o));
    }

    public boolean addValidation(ValidatorMapper o) {
        return this.validations.add(o);
    }

    public int validationSize() {
        return this.validations.size();
    }

    public PropertyValidator getTypeValidator() {
        return this.typeValidator;
    }

    public void setTypeValidator(PropertyValidator typeValidator) {
        this.typeValidator = typeValidator;
    }

    public boolean existsRequired() {
        for (ValidatorMapper mapper : this.validations) {
            if (!(mapper.getPropertyValidator() instanceof RequiredValidator)) continue;
            return true;
        }
        return false;
    }
}

