/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.validation;

import br.com.linkcom.neo.bean.BeanDescriptor;
import br.com.linkcom.neo.bean.PropertyDescriptor;
import br.com.linkcom.neo.core.config.ValidatorRegistry;
import br.com.linkcom.neo.core.standard.Neo;
import br.com.linkcom.neo.core.web.WebApplicationContext;
import br.com.linkcom.neo.core.web.WebRequestContext;
import br.com.linkcom.neo.validation.PropertyValidator;
import br.com.linkcom.neo.validation.ValidationItem;
import br.com.linkcom.neo.validation.ValidatorMapper;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectAnnotationValidator
extends WebApplicationObjectSupport
implements Validator {
    protected WebRequestContext context;

    public ObjectAnnotationValidator(WebRequestContext context) {
        this.context = context;
    }

    public boolean supports(Class clazz) {
        return true;
    }

    public void validate(Object obj, Errors errors) {
        WebApplicationContext webApplicationContext = this.context.getWebApplicationContext();
        ValidatorRegistry validatorRegistry = webApplicationContext.getConfig().getValidatorRegistry();
        HttpServletRequest servletRequest = this.context.getServletRequest();
        this.validateFile(servletRequest, errors);
        Map parameterMap = servletRequest.getParameterMap();
        Set keySet = parameterMap.keySet();
        BeanDescriptor<Object> beanDescriptor = webApplicationContext.getBeanDescriptor(obj);
        for (String parametro : keySet) {
            Annotation[] annotations;
            PropertyDescriptor propertyDescriptor;
            if (parametro.startsWith("_")) {
                parametro = parametro.substring(1);
            }
            try {
                propertyDescriptor = beanDescriptor.getPropertyDescriptor(parametro);
            }
            catch (NotReadablePropertyException e) {
                continue;
            }
            if (this.overrideValidation(beanDescriptor, parametro, obj, propertyDescriptor, errors)) continue;
            Annotation[] annotationArray = annotations = propertyDescriptor.getAnnotations();
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                PropertyValidator propertyValidator = validatorRegistry.getPropertyValidator(annotation.annotationType());
                if (propertyValidator != null) {
                    propertyValidator.validate(obj, propertyDescriptor.getValue(), parametro, propertyDescriptor.getDisplayName(), annotation, errors, this);
                }
                ++n2;
            }
        }
    }

    private void validateFile(HttpServletRequest servletRequest, Errors errors) {
        if (servletRequest instanceof MultipartHttpServletRequest) {
            MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)servletRequest;
            Iterator fileNames = multipartHttpServletRequest.getFileNames();
            while (fileNames.hasNext()) {
                String filename = (String)fileNames.next();
                MultipartFile file = multipartHttpServletRequest.getFile(filename);
                if (file.getOriginalFilename() == null || file.getOriginalFilename().length() <= 0 || file.getSize() != 0L) continue;
                errors.reject("", "O arquivo '" + filename + "' n\u00e3o pode ter tamanho 0 (zero)");
            }
        }
    }

    private boolean overrideValidation(BeanDescriptor<Object> beanDescriptor, String name, Object obj, PropertyDescriptor propertyDescriptorParameter, Errors errors) {
        if (name != null && name.contains(".")) {
            ValidationItem validationItem = new ValidationItem();
            PropertyDescriptor propertyDescriptor = beanDescriptor.getPropertyDescriptor(name.substring(0, name.indexOf(".")));
            Annotation[] annotationsValidators = propertyDescriptor.getAnnotations();
            boolean overrideValidation = Neo.getApplicationContext().getConfig().getValidatorRegistry().getExtractor().overrideValidation(validationItem, name, annotationsValidators);
            if (overrideValidation) {
                List<ValidatorMapper> validations = validationItem.getValidations();
                for (ValidatorMapper validatorMapper : validations) {
                    PropertyValidator propertyValidator = validatorMapper.getPropertyValidator();
                    propertyValidator.validate(obj, propertyDescriptor.getValue(), name, propertyDescriptorParameter.getDisplayName(), validatorMapper.getAnnotation(), errors, this);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

