/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.util;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.hibernate.proxy.HibernateProxy;

public class ObjectUtils {
    public boolean isEmpty(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            return map.isEmpty();
        }
        if (o instanceof Collection) {
            Collection c = (Collection)o;
            return c.isEmpty();
        }
        if (o.getClass().isArray()) {
            return Array.getLength(o) == 0;
        }
        if (o instanceof String) {
            return ((String)o).length() == 0;
        }
        if (o instanceof HibernateProxy) {
            return false;
        }
        return o.toString().equals("");
    }

    public boolean isNotEmpty(Object type) {
        return !this.isEmpty(type);
    }

    public Method findMethod(Object object, String methodName, Class ... arguments) {
        if (object == null) {
            throw new NullPointerException("N\u00e3o foi poss\u00edvel encontrar m\u00e9todo " + methodName + ": objeto nulo ");
        }
        try {
            Object[] parameterTypes;
            Method method;
            Method[] methods;
            Method[] methodArray = methods = object.getClass().getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                method = methodArray[n2];
                parameterTypes = method.getParameterTypes();
                if (method.getName().equals(methodName) && Arrays.deepEquals(parameterTypes, arguments)) {
                    return method;
                }
                ++n2;
            }
            methodArray = methods;
            n = methods.length;
            n2 = 0;
            while (n2 < n) {
                method = methodArray[n2];
                if (method.getName().equals(methodName) && (parameterTypes = method.getParameterTypes()).length == arguments.length) {
                    boolean match = true;
                    int i = 0;
                    while (i < parameterTypes.length) {
                        Object class1 = parameterTypes[i];
                        Class class2 = arguments[i];
                        if (!(this.isBoolean((Class)class1) && this.isBoolean(class2) || ((Class)class1).isAssignableFrom(class2))) {
                            match = false;
                            break;
                        }
                        ++i;
                    }
                    if (match) {
                        return method;
                    }
                }
                ++n2;
            }
            throw new NoSuchMethodException();
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("M\u00e9todo " + methodName + " n\u00e3o encontrado", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isBoolean(Class class2) {
        return class2.equals(Boolean.TYPE) || class2.equals(Boolean.class);
    }

    public Object findAndInvokeMethod(Object object, String methodName, Object ... params) {
        Class[] argumentTypes = new Class[params.length];
        int i = 0;
        while (i < argumentTypes.length) {
            if (params[i] != null) {
                argumentTypes[i] = params[i].getClass();
            }
            ++i;
        }
        Method findMethod = this.findMethod(object, methodName, argumentTypes);
        try {
            return findMethod.invoke(object, params);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Argumentos inv\u00e1lidos ao chamar m\u00e9todo " + methodName, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Acesso ilegal ao chamar m\u00e9todo " + methodName, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("M\u00e9todo " + methodName + " lan\u00e7ou exe\u00e7\u00e3o " + e.getClass().getSimpleName(), e);
        }
    }

    public Object findAndInvokeMethod(Object object, String methodName, Object[] params, Class[] classes) {
        Method findMethod = this.findMethod(object, methodName, classes);
        try {
            return findMethod.invoke(object, params);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Argumentos inv\u00e1lidos ao chamar m\u00e9todo " + methodName, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Acesso ilegal ao chamar m\u00e9todo " + methodName, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("M\u00e9todo " + methodName + " lan\u00e7ou exe\u00e7\u00e3o " + e.getTargetException().getClass().getSimpleName(), e.getTargetException());
        }
    }
}

