/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.types;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;

public class Telefone
implements UserType,
Serializable {
    private static final long serialVersionUID = 1L;
    private String value;

    @Deprecated
    public Telefone() {
    }

    public Telefone(String telefone) {
        if (telefone == null) {
            throw new NullPointerException();
        }
        this.checkPattern(telefone);
        this.value = telefone = this.removeSymbols(telefone);
    }

    private void checkPattern(String value) throws IllegalArgumentException {
        if (!value.trim().equals("") && !value.matches("(\\(\\d{2}\\)( )?)?\\d{4}-\\d{4}|\\d{8}|\\d{10}")) {
            throw new IllegalArgumentException("N\u00e3o foi poss\u00edvel converter \"" + value + "\" para um telefone v\u00e1lido");
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    protected Telefone clone() throws CloneNotSupportedException {
        return new Telefone(this.value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Telefone)) {
            return false;
        }
        if (this.value == null && ((Telefone)obj).value == null) {
            return true;
        }
        if (this.value == null || ((Telefone)obj).value == null) {
            return false;
        }
        return this.value.equals(((Telefone)obj).value);
    }

    public int hashCode() {
        if (this.value == null) {
            return super.hashCode();
        }
        return this.value.hashCode();
    }

    public String toString() {
        if (StringUtils.isEmpty((String)this.value)) {
            return "";
        }
        try {
            StringBuilder builder = new StringBuilder(this.value);
            int size = this.value.length();
            builder.insert(size == 10 ? 6 : 4, '-');
            if (size == 10) {
                builder.insert(2, ' ');
                builder.insert(2, ')');
                builder.insert(0, '(');
            }
            return builder.toString();
        }
        catch (IndexOutOfBoundsException e) {
            return this.value;
        }
    }

    public int[] sqlTypes() {
        return new int[]{12};
    }

    public Class returnedClass() {
        return Telefone.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (!(x != null && ((Telefone)x).value != null || y != null && ((Telefone)y).value != null)) {
            return true;
        }
        if (x == null && ((Telefone)x).value == null || y == null && ((Telefone)y).value == null) {
            return false;
        }
        return x.equals(y);
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        String value = rs.getString(names[0]);
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        return new Telefone(value);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value instanceof Telefone) {
            String value2 = ((Telefone)value).getValue();
            if (value2 == null) {
                st.setNull(index, 12);
            } else {
                st.setString(index, this.removeSymbols(value2));
            }
        } else {
            st.setNull(index, 12);
        }
    }

    private String removeSymbols(String value2) {
        return value2.replaceAll("\\(|\\)| ", "").replace("-", "");
    }

    public Object deepCopy(Object value) throws HibernateException {
        if (value == null) {
            return new Telefone();
        }
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Telefone)value;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }
}

