/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.types;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;

public class Money
implements Serializable,
Comparable,
UserType {
    private static final Log log = LogFactory.getLog(Money.class);
    private static final long serialVersionUID = 1L;
    protected BigDecimal value = null;
    protected MathContext mathContext = new MathContext(50, RoundingMode.HALF_EVEN);
    protected boolean isNull = false;

    public Money() {
        this.value = BigDecimal.ZERO;
    }

    public Money(boolean nullValue) {
        this();
        this.isNull = nullValue;
    }

    public boolean isNull() {
        return this.isNull && this.value.intValue() == 0;
    }

    public Money(BigDecimal value, int precision, RoundingMode roundingMode) {
        this.value = value;
        this.mathContext = new MathContext(precision, roundingMode);
    }

    public Money(Money money) {
        this(money.value, money.mathContext.getPrecision(), money.mathContext.getRoundingMode());
    }

    public Money(Number value, boolean multipliedBy100) {
        this.value = new BigDecimal(value.toString());
        if (multipliedBy100) {
            this.value = this.value.movePointLeft(2);
        }
    }

    public Money(long value, boolean multipliedBy100) {
        this(new Long(value), multipliedBy100);
    }

    public Money(double value) {
        this(new Double(value), false);
    }

    public Money(String value) {
        this.value = new BigDecimal(value);
    }

    public Money round() {
        return new Money(this.value.setScale(2, this.mathContext.getRoundingMode()), this.mathContext.getPrecision(), this.mathContext.getRoundingMode());
    }

    public long toLong() {
        return this.value.setScale(2, this.mathContext.getRoundingMode()).movePointRight(2).longValue();
    }

    public int getPrecision() {
        return this.mathContext.getPrecision();
    }

    public Money setPrecision(int precision) {
        Money resultado = new Money(this);
        resultado.mathContext = new MathContext(precision, this.mathContext.getRoundingMode());
        return resultado;
    }

    public RoundingMode getRoundingMode() {
        return this.mathContext.getRoundingMode();
    }

    public Money setRoundingMode(RoundingMode roundingMode) {
        Money resultado = new Money(this);
        resultado.mathContext = new MathContext(this.mathContext.getPrecision(), roundingMode);
        return resultado;
    }

    public String toString() {
        return new DecimalFormat("#,##0.00").format(this.value);
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public int compareTo(Object object) {
        if (object instanceof Money) {
            return ((Money)object).value.compareTo(this.value);
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).compareTo(this.value);
        }
        if (object instanceof Number) {
            return new Money((Number)((Number)object), (boolean)false).value.compareTo(this.value);
        }
        throw new IllegalArgumentException();
    }

    public int[] sqlTypes() {
        return new int[]{-5};
    }

    public Class returnedClass() {
        return Money.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x != null) {
            return ((Money)x).compareTo(y) == 0;
        }
        return x == null && y == null;
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        Object obj = rs.getObject(names[0]);
        if (obj == null) {
            return new Money();
        }
        if (!(obj instanceof Number)) {
            String msg = "O campo de uma propriedade do tipo Money n\u00e3o est\u00e1 com o tipo long no banco.";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        Long value = ((Number)obj).longValue();
        return new Money(value, true);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value instanceof Money) {
            if (((Money)value).isNull()) {
                st.setNull(index, -5);
            } else {
                st.setLong(index, ((Money)value).toLong());
            }
        } else {
            st.setNull(index, -5);
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Money)value;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public Money divide(Money money) {
        return new Money(this.value.divide(money.value, this.mathContext), this.mathContext.getPrecision(), this.mathContext.getRoundingMode());
    }

    public Money multiply(Money money) {
        return new Money(this.value.multiply(money.value, this.mathContext), this.mathContext.getPrecision(), this.mathContext.getRoundingMode());
    }

    public Money subtract(Money money) {
        return new Money(this.value.subtract(money.value, this.mathContext), this.mathContext.getPrecision(), this.mathContext.getRoundingMode());
    }

    public Money add(Money money) {
        return new Money(this.value.add(money.value, this.mathContext), this.mathContext.getPrecision(), this.mathContext.getRoundingMode());
    }
}

