/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.types;

import br.com.linkcom.neo.types.CadastroPessoa;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;

public class Cpf
implements UserType,
Serializable,
CadastroPessoa {
    private static final long serialVersionUID = 1L;
    private String value;

    @Deprecated
    public Cpf() {
    }

    public Cpf(String cpf) {
        if (cpf == null) {
            throw new NullPointerException();
        }
        this.checkPattern(cpf);
        cpf = this.removeSymbols(cpf);
        this.value = cpf.trim().equals("") ? null : cpf;
    }

    public static boolean cpfValido(String strCpf) {
        if (strCpf.length() != 11) {
            return false;
        }
        int d2 = 0;
        int d1 = 0;
        int resto = 0;
        int digito2 = 0;
        int digito1 = 0;
        int nCount = 1;
        while (nCount < strCpf.length() - 1) {
            int digitoCPF = Integer.valueOf(strCpf.substring(nCount - 1, nCount));
            d1 += (11 - nCount) * digitoCPF;
            d2 += (12 - nCount) * digitoCPF;
            ++nCount;
        }
        resto = d1 % 11;
        digito1 = resto < 2 ? 0 : 11 - resto;
        resto = (d2 += 2 * digito1) % 11;
        digito2 = resto < 2 ? 0 : 11 - resto;
        String nDigVerific = strCpf.substring(strCpf.length() - 2, strCpf.length());
        String nDigResult = String.valueOf(String.valueOf(digito1)) + String.valueOf(digito2);
        return nDigVerific.equals(nDigResult);
    }

    private void checkPattern(String value) throws IllegalArgumentException {
        if (!value.trim().equals("") && !value.matches("\\d{3}\\.?\\d{3}\\.?\\d{3}-?\\d{2}")) {
            throw new IllegalArgumentException("N\u00e3o foi poss\u00edvel converter \"" + value + "\" para um CPF v\u00e1lido");
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    protected Cpf clone() throws CloneNotSupportedException {
        return new Cpf(this.value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Cpf)) {
            return false;
        }
        if (this.value == null && ((Cpf)obj).value == null) {
            return true;
        }
        if (this.value == null || ((Cpf)obj).value == null) {
            return false;
        }
        return this.value.equals(((Cpf)obj).value);
    }

    public int hashCode() {
        if (this.value == null) {
            return super.hashCode();
        }
        return this.value.hashCode();
    }

    public String toString() {
        if (StringUtils.isEmpty((String)this.value)) {
            return "";
        }
        try {
            StringBuilder builder = new StringBuilder(this.value);
            builder.insert(9, '-');
            builder.insert(6, '.');
            builder.insert(3, '.');
            return builder.toString();
        }
        catch (IndexOutOfBoundsException e) {
            return this.value;
        }
    }

    public int[] sqlTypes() {
        return new int[]{12};
    }

    public Class returnedClass() {
        return Cpf.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (!(x != null && ((Cpf)x).value != null || y != null && ((Cpf)y).value != null)) {
            return true;
        }
        if (x == null && ((Cpf)x).value == null || y == null && ((Cpf)y).value == null) {
            return false;
        }
        return x.equals(y);
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        String value = rs.getString(names[0]);
        if (StringUtils.isEmpty((String)value)) {
            return new Cpf();
        }
        return new Cpf(value);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value instanceof Cpf) {
            String value2 = ((Cpf)value).getValue();
            if (value2 == null) {
                st.setNull(index, 12);
            } else {
                st.setString(index, this.removeSymbols(value2));
            }
        } else {
            st.setNull(index, 12);
        }
    }

    private String removeSymbols(String value2) {
        return value2.replace(".", "").replace("-", "");
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Cpf)value;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public static void main(String[] args) {
        String c = "073.572.796-18";
        new Cpf(c);
        System.out.println(Cpf.cpfValido(c));
    }
}

