/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.types;

import br.com.linkcom.neo.types.CadastroPessoa;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;

public class Cnpj
implements UserType,
CadastroPessoa {
    private String value;

    @Deprecated
    public Cnpj() {
    }

    public Cnpj(String cnpj) {
        if (cnpj == null) {
            throw new NullPointerException();
        }
        this.checkPattern(cnpj);
        String original = cnpj;
        cnpj = this.removeSymbols(cnpj);
        if (!Cnpj.cnpjValido(cnpj)) {
            throw new IllegalArgumentException("N\u00e3o foi poss\u00edvel converter \"" + original + "\" para um CNPJ v\u00e1lido");
        }
        this.value = cnpj.trim().equals("") ? null : cnpj;
    }

    public static boolean cnpjValido(String str_cnpj) {
        if (str_cnpj.length() != 15 && str_cnpj.length() != 14) {
            return false;
        }
        if (str_cnpj.length() == 15) {
            str_cnpj = str_cnpj.substring(1, 15);
        }
        int soma = 0;
        String cnpj_calc = str_cnpj.substring(0, 12);
        if (str_cnpj.length() != 14) {
            return false;
        }
        char[] chr_cnpj = str_cnpj.toCharArray();
        int i = 0;
        while (i < 4) {
            if (chr_cnpj[i] - 48 >= 0 && chr_cnpj[i] - 48 <= 9) {
                soma += (chr_cnpj[i] - 48) * (6 - (i + 1));
            }
            ++i;
        }
        i = 0;
        while (i < 8) {
            if (chr_cnpj[i + 4] - 48 >= 0 && chr_cnpj[i + 4] - 48 <= 9) {
                soma += (chr_cnpj[i + 4] - 48) * (10 - (i + 1));
            }
            ++i;
        }
        int dig = 11 - soma % 11;
        cnpj_calc = String.valueOf(cnpj_calc) + (dig == 10 || dig == 11 ? "0" : Integer.toString(dig));
        soma = 0;
        i = 0;
        while (i < 5) {
            if (chr_cnpj[i] - 48 >= 0 && chr_cnpj[i] - 48 <= 9) {
                soma += (chr_cnpj[i] - 48) * (7 - (i + 1));
            }
            ++i;
        }
        i = 0;
        while (i < 8) {
            if (chr_cnpj[i + 5] - 48 >= 0 && chr_cnpj[i + 5] - 48 <= 9) {
                soma += (chr_cnpj[i + 5] - 48) * (10 - (i + 1));
            }
            ++i;
        }
        dig = 11 - soma % 11;
        cnpj_calc = String.valueOf(cnpj_calc) + (dig == 10 || dig == 11 ? "0" : Integer.toString(dig));
        return str_cnpj.equals(cnpj_calc);
    }

    private void checkPattern(String value) throws IllegalArgumentException {
        if (!value.trim().equals("") && !value.matches("\\d{2,3}\\.?\\d{3}\\.?\\d{3}/?\\d{4}-?\\d{2}")) {
            throw new IllegalArgumentException("N\u00e3o foi poss\u00edvel converter \"" + value + "\" para um CNPJ v\u00e1lido");
        }
    }

    public String getValue() {
        return this.value;
    }

    protected Cnpj clone() throws CloneNotSupportedException {
        return new Cnpj(this.value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Cnpj)) {
            return false;
        }
        if (this.value == null && ((Cnpj)obj).value == null) {
            return true;
        }
        if (this.value == null || ((Cnpj)obj).value == null) {
            return false;
        }
        return this.value.equals(((Cnpj)obj).value);
    }

    public int hashCode() {
        if (this.value == null) {
            return super.hashCode();
        }
        return this.value.hashCode();
    }

    public String toString() {
        if (StringUtils.isEmpty((String)this.value)) {
            return "";
        }
        try {
            StringBuilder builder = new StringBuilder(this.value);
            builder.insert(12, '-');
            builder.insert(8, '/');
            builder.insert(5, '.');
            builder.insert(2, '.');
            return builder.toString();
        }
        catch (IndexOutOfBoundsException e) {
            return this.value;
        }
    }

    public int[] sqlTypes() {
        return new int[]{12};
    }

    public Class returnedClass() {
        return Cnpj.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (!(x != null && ((Cnpj)x).value != null || y != null && ((Cnpj)y).value != null)) {
            return true;
        }
        if (x == null && ((Cnpj)x).value == null || y == null && ((Cnpj)y).value == null) {
            return false;
        }
        return x.equals(y);
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        String value = rs.getString(names[0]);
        if (value == null) {
            return new Cnpj();
        }
        Cnpj cnpj = new Cnpj();
        cnpj.value = value;
        return cnpj;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value instanceof Cnpj) {
            String value2 = ((Cnpj)value).getValue();
            if (StringUtils.isEmpty((String)value2)) {
                st.setNull(index, 12);
            } else {
                st.setString(index, this.removeSymbols(value2));
            }
        } else {
            st.setNull(index, 12);
        }
    }

    private String removeSymbols(String value2) {
        return value2.replace(".", "").replace("-", "").replace("/", "");
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return ((Cnpj)value).getValue();
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return new Cnpj((String)((Object)cached));
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public static void main(String[] args) {
        String c = "006.213.117/0001-30";
        new Cnpj(c);
        System.out.println(Cnpj.cnpjValido(c));
    }
}

