/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.types;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;

public class Cep
implements UserType,
Serializable {
    private static final long serialVersionUID = 1L;
    private String value;

    @Deprecated
    public Cep() {
    }

    public Cep(String cep) {
        if (cep == null) {
            throw new NullPointerException();
        }
        this.checkPattern(cep);
        cep = this.removeSymbols(cep);
        this.value = cep.trim().equals("") ? null : cep;
    }

    public Cep formatCep(Cep cep) {
        cep.setValue(String.format("%08d", Integer.parseInt(cep.getValue())));
        return cep;
    }

    private void checkPattern(String value) throws IllegalArgumentException {
        if (!value.trim().equals("") && !value.matches("\\d{5}[-\\.]?\\d{3}")) {
            throw new IllegalArgumentException("N\u00e3o foi poss\u00edvel converter \"" + value + "\" para um CEP v\u00e1lido");
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    protected Cep clone() throws CloneNotSupportedException {
        return new Cep(this.value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Cep)) {
            return false;
        }
        if (this.value == null && ((Cep)obj).value == null) {
            return true;
        }
        if (this.value == null || ((Cep)obj).value == null) {
            return false;
        }
        return this.value.equals(((Cep)obj).value);
    }

    public int hashCode() {
        if (this.value == null) {
            return super.hashCode();
        }
        return this.value.hashCode();
    }

    public String toString() {
        if (StringUtils.isEmpty((String)this.value)) {
            return "";
        }
        try {
            this.formatCep(this);
            StringBuilder builder = new StringBuilder(this.value);
            builder.insert(5, '-');
            return builder.toString();
        }
        catch (IndexOutOfBoundsException e) {
            return this.value;
        }
    }

    public int[] sqlTypes() {
        return new int[]{12};
    }

    public Class returnedClass() {
        return Cep.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (!(x != null && ((Cep)x).value != null || y != null && ((Cep)y).value != null)) {
            return true;
        }
        if (x == null && ((Cep)x).value == null || y == null && ((Cep)y).value == null) {
            return false;
        }
        return x.equals(y);
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        String value = rs.getString(names[0]);
        if (value == null) {
            return new Cep();
        }
        Cep cep = new Cep();
        cep.value = value;
        return cep;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value instanceof Cep) {
            String value2 = ((Cep)value).getValue();
            if (StringUtils.isEmpty((String)value2)) {
                st.setNull(index, 12);
            } else {
                st.setString(index, this.removeSymbols(value2));
            }
        } else {
            st.setNull(index, 12);
        }
    }

    private String removeSymbols(String value2) {
        return value2.replace(".", "").replace("-", "");
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Cep)value;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }
}

