/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.rtf;

import br.com.linkcom.neo.exception.RTFException;
import br.com.linkcom.neo.rtf.RTF;
import br.com.linkcom.neo.rtf.RTFGenerator;
import br.com.linkcom.neo.rtf.RTFNameResolver;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Map;

public class RTFGeneratorImpl
implements RTFGenerator {
    private RTFNameResolver nameResolver;

    public RTFGeneratorImpl(RTFNameResolver nameResolver) {
        this.nameResolver = nameResolver;
    }

    public byte[] generate(RTF rtf) {
        ByteArrayOutputStream out;
        InputStream in = null;
        try {
            try {
                Map<String, String> parameterMap = rtf.getParameterMap();
                if (parameterMap == null) {
                    throw new NullPointerException("RTF n\u00e3o possui parameterMap");
                }
                in = this.nameResolver.resolveName(rtf.getName());
                out = new ByteArrayOutputStream();
                int i = 0;
                boolean inTag = false;
                StringBuilder currentTag = new StringBuilder();
                while ((i = in.read()) != -1) {
                    if (i == 60) {
                        inTag = true;
                        continue;
                    }
                    if (i == 62) {
                        inTag = false;
                        String param = currentTag.toString();
                        String value = parameterMap.get(param);
                        if (value != null) {
                            byte[] bytes = value.getBytes("ISO8859-1");
                            out.write(bytes);
                        }
                        currentTag = new StringBuilder();
                        continue;
                    }
                    if (inTag) {
                        currentTag.append((char)i);
                        continue;
                    }
                    out.write(i);
                }
            }
            catch (Exception e) {
                throw new RTFException(e);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return out.toByteArray();
    }
}

