/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.report;

import br.com.linkcom.neo.exception.ReportException;
import br.com.linkcom.neo.report.IReport;
import br.com.linkcom.neo.report.JRIteratorDataSource;
import br.com.linkcom.neo.report.ReportGenerator;
import br.com.linkcom.neo.report.ReportTranslator;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRResultSetDataSource;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperRunManager;
import net.sf.jasperreports.engine.data.JRBeanArrayDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.data.JRMapArrayDataSource;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportGeneratorImpl
implements ReportGenerator {
    protected ReportTranslator reportTranslator;

    public ReportGeneratorImpl(ReportTranslator translator) {
        if (translator == null) {
            throw new NullPointerException();
        }
        this.reportTranslator = translator;
    }

    @Override
    public byte[] toPdf(IReport report) throws ReportException {
        Iterator iterator;
        Map<String, JasperReport> subReportParameters;
        JasperReport jasperReport;
        try {
            jasperReport = this.reportTranslator.translate(report);
            subReportParameters = this.subReportParameters(report, this.reportTranslator);
        }
        catch (JRException e1) {
            throw new ReportException(e1);
        }
        HashMap<String, Object> allParameters = new HashMap<String, Object>();
        allParameters.putAll(subReportParameters);
        this.reportParameters(report, allParameters);
        Object ds = report.getDataSource();
        Object dataSource = null;
        if (ds instanceof JRDataSource) {
            dataSource = (JRDataSource)ds;
        } else if (ds instanceof ResultSet) {
            dataSource = new JRResultSetDataSource((ResultSet)ds);
        } else if (ds instanceof Object[]) {
            Object[] array = (Object[])ds;
            dataSource = array.length > 0 && array[0] instanceof Map ? new JRMapArrayDataSource(array) : new JRBeanArrayDataSource(array);
        } else if (ds instanceof Collection) {
            iterator = ((Collection)ds).iterator();
            Object primeiroElemento = null;
            if (iterator.hasNext()) {
                primeiroElemento = iterator.next();
            }
            dataSource = primeiroElemento instanceof Map ? new JRMapCollectionDataSource((Collection)ds) : new JRBeanCollectionDataSource((Collection)ds);
        } else if (ds instanceof Iterator) {
            iterator = (Iterator)ds;
            dataSource = new JRIteratorDataSource(iterator);
        } else if (ds == null) {
            dataSource = new JREmptyDataSource();
        } else {
            throw new ReportException("O tipo de datasource \u00e9 inv\u00e1lido! " + dataSource.getClass());
        }
        try {
            byte[] byArray = JasperRunManager.runReportToPdf((JasperReport)jasperReport, allParameters, (JRDataSource)dataSource);
            return byArray;
        }
        catch (JRException e) {
            throw new ReportException(e);
        }
        finally {
            if (report.getDataSource() instanceof ResultSet) {
                try {
                    ResultSet rs = (ResultSet)report.getDataSource();
                    rs.getStatement().getConnection().close();
                }
                catch (Exception e) {
                    System.out.println("Aten\u00e7\u00e3o! N\u00e3o foi poss\u00edvel fechar conex\u00e3o ap\u00f3s gerar relat\u00f3rio!");
                }
            }
        }
    }

    private void reportParameters(IReport report, Map<String, Object> allParameters) {
        allParameters.putAll(report.getParameters());
        Map<String, IReport> subReportMap = report.getSubReportMap();
        for (String name : subReportMap.keySet()) {
            IReport ireport = subReportMap.get(name);
            this.reportParameters(ireport, allParameters);
        }
    }

    protected Map<String, JasperReport> subReportParameters(IReport jasperReport, ReportTranslator reportTranslator) throws JRException {
        Map<String, IReport> subReportMap = jasperReport.getSubReportMap();
        HashMap<String, JasperReport> result = new HashMap<String, JasperReport>();
        for (String name : subReportMap.keySet()) {
            IReport ireport = subReportMap.get(name);
            JasperReport jreport = reportTranslator.translate(ireport);
            result.putAll(this.subReportParameters(ireport, reportTranslator));
            result.put(name, jreport);
        }
        return result;
    }
}

