/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.persistence;

import br.com.linkcom.neo.core.standard.Neo;
import br.com.linkcom.neo.util.ReflectionCache;
import br.com.linkcom.neo.util.ReflectionCacheFactory;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLServerSQLErrorCodeSQLExceptionTranslator
extends SQLErrorCodeSQLExceptionTranslator {
    static String errorRegex = "(.*) statement conflicted with COLUMN (?:SAME TABLE )?REFERENCE constraint '(.*?)'. The conflict occurred in database '(?:.*?)', table '(.*?)', column '(.*?)'.";
    static Pattern pattern = Pattern.compile(errorRegex);
    static final Log log = LogFactory.getLog(SQLServerSQLErrorCodeSQLExceptionTranslator.class);
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
        this.dataSource = dataSource;
    }

    private String getTableName(Class<?> entityClass) {
        ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
        Table table = reflectionCache.getAnnotation(entityClass, Table.class);
        if (table != null) {
            return table.name().toUpperCase();
        }
        return entityClass.getSimpleName().toUpperCase();
    }

    protected DataAccessException customTranslate(String task, String sql, SQLException sqlEx) {
        if (sqlEx.getErrorCode() == 547) {
            Matcher matcher = pattern.matcher(sqlEx.getMessage());
            if (!matcher.find()) {
                return null;
            }
            String fk_name = matcher.group(2);
            String fk_table_name = matcher.group(3).toUpperCase();
            String pk_table_name = null;
            String fkTableDisplayName = null;
            String pkTableDisplayName = null;
            try {
                DatabaseMetaData metaData = this.dataSource.getConnection().getMetaData();
                ResultSet importedKeys = metaData.getImportedKeys(null, null, fk_table_name);
                while (importedKeys.next()) {
                    if (!importedKeys.getString("FK_NAME").equals(fk_name) || (pk_table_name = importedKeys.getString("PKTABLE_NAME")) == null) continue;
                    pk_table_name = pk_table_name.toUpperCase();
                }
            }
            catch (SQLException e) {
                log.warn((Object)"N\u00e3o foi poss\u00edvel conseguir o metadata do banco para ler informacoes de FK.");
                return null;
            }
            Class<?>[] entities = Neo.getApplicationContext().getClassManager().getClassesWithAnnotation(Entity.class);
            pkTableDisplayName = pk_table_name;
            fkTableDisplayName = fk_table_name;
            Class<?>[] classArray = entities;
            int n = entities.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> entityClass = classArray[n2];
                String tableName = this.getTableName(entityClass);
                if (tableName.equals(pk_table_name)) {
                    pkTableDisplayName = Neo.getApplicationContext().getBeanDescriptor(null, entityClass).getDisplayName();
                }
                if (tableName.equals(fk_table_name)) {
                    fkTableDisplayName = Neo.getApplicationContext().getBeanDescriptor(null, entityClass).getDisplayName();
                }
                ++n2;
            }
            String mensagem = null;
            sql = matcher.group(1);
            mensagem = sql.toLowerCase().trim().startsWith("delete") ? "N\u00e3o foi poss\u00edvel remover " + pkTableDisplayName.toLowerCase() + ". Existe(m) registro(s) vinculado(s) em " + fkTableDisplayName.toLowerCase() + "." : (sql.toLowerCase().trim().startsWith("update") ? "N\u00e3o foi poss\u00edvel atualizar " + fkTableDisplayName.toLowerCase() + ". A refer\u00eancia para " + pkTableDisplayName.toLowerCase() + " \u00e9 inv\u00e1lida." : (sql.toLowerCase().trim().startsWith("insert") ? "N\u00e3o foi poss\u00edvel inserir " + fkTableDisplayName.toLowerCase() + ". A refer\u00eancia para " + pkTableDisplayName.toLowerCase() + " \u00e9 inv\u00e1lida." : "N\u00e3o foi poss\u00edvel efetuar opera\u00e7\u00e3o em " + pkTableDisplayName.toLowerCase() + ". Existe(m) registro(s) vinculado(s) em " + fkTableDisplayName.toLowerCase() + "."));
            return new ForeignKeyException(mensagem);
        }
        return null;
    }

    public static class ForeignKeyException
    extends DataAccessException {
        private static final long serialVersionUID = 1L;

        public ForeignKeyException(String msg) {
            super(msg);
        }
    }
}

