/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.persistence;

import br.com.linkcom.neo.bean.BeanDescriptor;
import br.com.linkcom.neo.bean.BeanDescriptorFactory;
import br.com.linkcom.neo.bean.BeanDescriptorFactoryImpl;
import br.com.linkcom.neo.exception.NeoException;
import br.com.linkcom.neo.persistence.AliasMap;
import br.com.linkcom.neo.persistence.ObjectMapper;
import br.com.linkcom.neo.persistence.ObjectTree;
import br.com.linkcom.neo.persistence.ObjectTreeBuilder;
import br.com.linkcom.neo.persistence.QueryBuilderResultTranslator;
import br.com.linkcom.neo.util.Util;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryBuilderResultTranslatorImpl
implements QueryBuilderResultTranslator {
    boolean debug = false;
    String resultAlias;
    static BeanDescriptorFactory beanDescriptorFactory = new BeanDescriptorFactoryImpl();
    ObjectTreeBuilder treeBuilder = new ObjectTreeBuilder();
    ObjectMapper mapper = new ObjectMapper();
    List<String> extraFields = new ArrayList<String>();

    @Override
    public void init(String[] selectedProperties, AliasMap[] aliasMaps) {
        HashSet<String> aliases = new HashSet<String>();
        AliasMap[] aliasMapArray = aliasMaps;
        int n = aliasMaps.length;
        int n2 = 0;
        while (n2 < n) {
            AliasMap map = aliasMapArray[n2];
            if (!aliases.add(map.alias)) {
                throw new NeoException("Alias duplicado na query: " + map.alias);
            }
            ++n2;
        }
        this.organizeAliasMaps(aliasMaps, selectedProperties);
        this.treeBuilder.init(aliasMaps);
        this.mapper.init(aliasMaps, selectedProperties);
        String[] newSelectedProperties = new String[selectedProperties.length + this.extraFields.size()];
        System.arraycopy(selectedProperties, 0, newSelectedProperties, 0, selectedProperties.length);
        String[] extraFields2 = this.getExtraFields();
        System.arraycopy(extraFields2, 0, newSelectedProperties, selectedProperties.length - 1, extraFields2.length);
        selectedProperties = newSelectedProperties;
    }

    private void organizeAliasMaps(AliasMap[] aliasMaps, String[] selectedProperties) {
        int i = 0;
        while (i < aliasMaps.length) {
            AliasMap aliasMap = aliasMaps[i];
            if (aliasMap.type == null) {
                Type type = QueryBuilderResultTranslatorImpl.getAliasType(aliasMap.path, aliasMaps);
                if (type instanceof Class) {
                    aliasMap.type = (Class)type;
                } else if (type instanceof ParameterizedType) {
                    ParameterizedType parameterizedType = (ParameterizedType)type;
                    if (Set.class.isAssignableFrom((Class)parameterizedType.getRawType())) {
                        aliasMap.collectionType = (Class)parameterizedType.getActualTypeArguments()[0];
                        aliasMap.type = LinkedHashSet.class;
                    } else if (List.class.isAssignableFrom((Class)parameterizedType.getRawType())) {
                        aliasMap.collectionType = (Class)parameterizedType.getActualTypeArguments()[0];
                        aliasMap.type = ArrayList.class;
                    } else {
                        throw new RuntimeException("Tipo n\u00e3o suportado: " + parameterizedType.getRawType() + " alias: " + aliasMap.alias);
                    }
                    if (aliasMap.dependencias == null) {
                        if (this.debug) {
                            System.out.println("\nProcurando dependencias (m\u00e9todo inicial) de " + aliasMap);
                        }
                        aliasMap.dependencias = this.getDependencias(aliasMaps, aliasMap);
                    }
                } else {
                    throw new RuntimeException("Tipo n\u00e3o suportado: " + type + " alias: " + aliasMap.alias);
                }
            }
            if (aliasMap.pkPropertyIndex == -1) {
                aliasMap.pkPropertyIndex = this.lookForPk(aliasMap, selectedProperties);
            }
            ++i;
        }
    }

    private Set<AliasMap> getDependencias(AliasMap[] aliasMaps, AliasMap aliasMap) {
        if (aliasMap.dependencias != null) {
            if (this.debug) {
                System.out.println("\nJ\u00e1 foi configurado as dependencias de " + aliasMap);
            }
            return aliasMap.dependencias;
        }
        HashSet<AliasMap> dependencias = new HashSet<AliasMap>();
        if (aliasMap.path == null) {
            dependencias.add(aliasMap);
            if (this.debug) {
                System.out.println("\nRoot encontrado " + aliasMap + ". Retornando dependencia simples");
            }
            return dependencias;
        }
        String ownerProperty = aliasMap.path.split("\\.")[0];
        if (this.debug) {
            System.out.println("\nEntrando no loop para procurar alias " + ownerProperty + " referenciado em " + aliasMap);
        }
        int i = 0;
        while (i < aliasMaps.length) {
            AliasMap map = aliasMaps[i];
            if (map.alias.equals(ownerProperty)) {
                dependencias.add(aliasMap);
                if (this.debug) {
                    System.out.println("\nEncontrado alias " + ownerProperty + ". Procurando dependencias de " + ownerProperty);
                }
                dependencias.addAll(this.getDependencias(aliasMaps, map));
            }
            ++i;
        }
        return dependencias;
    }

    private int lookForPk(AliasMap aliasMap, String[] selectedProperties) {
        Class type = aliasMap.getType();
        if (aliasMap.collectionType != null) {
            type = aliasMap.collectionType;
        }
        BeanDescriptor<Object> bd = beanDescriptorFactory.createBeanDescriptor(null, type);
        String pkname = bd.getIdPropertyName();
        String fullProperty = String.valueOf(aliasMap.alias) + "." + pkname;
        int i = 0;
        while (i < selectedProperties.length) {
            if (selectedProperties[i].equals(fullProperty)) {
                return i;
            }
            ++i;
        }
        this.extraFields.add(fullProperty);
        return this.extraFields.size() + selectedProperties.length - 1;
    }

    public static Type getAliasType(String path, AliasMap[] aliasMaps) {
        Type type = null;
        String ownerproperty = path.substring(0, path.indexOf(46));
        String property = path.substring(path.indexOf(46) + 1);
        Class ownerpropertyType = QueryBuilderResultTranslatorImpl.getOwner(aliasMaps, ownerproperty);
        if (property.contains(".")) {
            throw new RuntimeException("n\u00e3o \u00e9 poss\u00edvel ter propriedade de propriedade nos joins: " + path);
        }
        String getterName = "get" + Util.strings.captalize(property);
        try {
            Method getter = ownerpropertyType.getMethod(getterName, new Class[0]);
            type = getter.getGenericReturnType();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return type;
    }

    public List translate(List values) {
        ArrayList<Object> list = new ArrayList<Object>();
        ObjectTreeBuilder treeBuilder = this.getThreadSafeTreeBuilder();
        for (Object object : values) {
            Object translate;
            if (!(object instanceof Object[])) {
                object = new Object[]{object};
            }
            if ((translate = this.translate((Object[])object, treeBuilder)) == null) continue;
            list.add(translate);
        }
        return list;
    }

    private ObjectTreeBuilder getThreadSafeTreeBuilder() {
        return this.treeBuilder.getThreadSafeInstance();
    }

    public Object translate(Object[] values, ObjectTreeBuilder treeBuilder) {
        ObjectTree objectTree = treeBuilder.buildObjectTree(values);
        this.mapper.map(values, objectTree);
        if (objectTree.isNew) {
            if (this.resultAlias != null) {
                Object object = objectTree.getAliasObject().get(this.resultAlias);
                if (object == null) {
                    throw new NeoException("Tentativa de achar um objeto falhou ao traduzir o resultado. Alias n\u00e3o encontrado: " + this.resultAlias + ".");
                }
                return object;
            }
            return objectTree.getRoot();
        }
        return null;
    }

    public Object translate(Object[] values) {
        ObjectTree objectTree = this.treeBuilder.buildObjectTree(values);
        this.mapper.map(values, objectTree);
        if (objectTree.isNew) {
            if (this.resultAlias != null) {
                Object object = objectTree.getAliasObject().get(this.resultAlias);
                if (object == null) {
                    throw new NeoException("Tentativa de achar um objeto falhou ao traduzir o resultado. Alias n\u00e3o encontrado: " + this.resultAlias + ".");
                }
                return object;
            }
            return objectTree.getRoot();
        }
        return null;
    }

    @Override
    public String[] getExtraFields() {
        return this.extraFields.toArray(new String[this.extraFields.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Class getOwner(AliasMap[] aliasMaps, String owneralias) {
        Class owner = null;
        int j = 0;
        while (j < aliasMaps.length) {
            AliasMap aliasMap = aliasMaps[j];
            if (aliasMap.alias.equals(owneralias)) {
                if (aliasMap.type == null) {
                    Type type = QueryBuilderResultTranslatorImpl.getAliasType(aliasMap.path, aliasMaps);
                    if (type instanceof Class) {
                        aliasMap.type = (Class)type;
                    } else {
                        if (!(type instanceof ParameterizedType)) throw new RuntimeException("Tipo n\u00e3o suportado: " + type + " alias: " + aliasMap.alias);
                        ParameterizedType parameterizedType = (ParameterizedType)type;
                        if (Set.class.isAssignableFrom((Class)parameterizedType.getRawType())) {
                            aliasMap.collectionType = (Class)parameterizedType.getActualTypeArguments()[0];
                            aliasMap.type = LinkedHashSet.class;
                        } else {
                            if (!List.class.isAssignableFrom((Class)parameterizedType.getRawType())) throw new RuntimeException("Tipo n\u00e3o suportado: " + parameterizedType.getRawType() + " alias: " + aliasMap.alias);
                            aliasMap.collectionType = (Class)parameterizedType.getActualTypeArguments()[0];
                            aliasMap.type = ArrayList.class;
                        }
                    }
                }
                if (aliasMap.collectionType == null) return aliasMap.type;
                return aliasMap.collectionType;
            }
            ++j;
        }
        return owner;
    }

    public String getResultAlias() {
        return this.resultAlias;
    }

    @Override
    public void setResultAlias(String resultAlias) {
        this.resultAlias = resultAlias;
    }
}

