/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.persistence;

import br.com.linkcom.neo.controller.crud.FiltroListagem;
import br.com.linkcom.neo.core.standard.Neo;
import br.com.linkcom.neo.exception.UsefullNeoException;
import br.com.linkcom.neo.persistence.AliasMap;
import br.com.linkcom.neo.persistence.JoinMode;
import br.com.linkcom.neo.persistence.ListagemResult;
import br.com.linkcom.neo.persistence.QueryBuilderResultTranslator;
import br.com.linkcom.neo.persistence.QueryBuilderResultTranslatorImpl;
import br.com.linkcom.neo.util.ReflectionCache;
import br.com.linkcom.neo.util.ReflectionCacheFactory;
import br.com.linkcom.neo.util.Util;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.CacheMode;
import org.hibernate.EntityMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryBuilder<E> {
    private static final Log log = LogFactory.getLog(QueryBuilder.class);
    private Select select;
    private From from;
    private List<Join> joins = new ArrayList<Join>();
    private List<String> fetchs = new ArrayList<String>();
    private Where where = new Where();
    private GroupBy groupBy;
    private String orderby;
    private String alias;
    private HibernateTemplate hibernateTemplate;
    protected int maxResults = Integer.MIN_VALUE;
    protected int firstResult = Integer.MIN_VALUE;
    protected boolean hasSelect = false;
    protected boolean ignoreAllJoinPath = false;
    protected boolean useCache = false;
    protected CacheMode cacheMode;
    protected boolean useTranslator = true;
    protected String translatorAlias;
    private boolean inOr = false;
    private boolean bypassedlastWhere = false;
    private int subConditionStack = 0;
    private Set<String> ignoreJoinPaths = new HashSet<String>();

    public boolean isUseTranslator() {
        return this.useTranslator;
    }

    public QueryBuilder<E> setUseTranslator(boolean useTranslator) {
        this.useTranslator = useTranslator;
        return this;
    }

    public QueryBuilder<E> setTranslatorAlias(String alias) {
        this.translatorAlias = alias;
        return this;
    }

    public ListagemResult<E> pageAndOrder(FiltroListagem filtroListagem) {
        return new ListagemResult(this, filtroListagem);
    }

    public QueryBuilder<E> setPageNumberAndSize(int pageNumber, int pageSize) {
        this.maxResults = pageSize;
        this.firstResult = pageSize * pageNumber;
        return this;
    }

    public QueryBuilder(HibernateTemplate hibernateTemplate) {
        if (hibernateTemplate == null) {
            throw new NullPointerException("O construtor do QueryBuilder foi chamado com hibernateTemplate igual a null!");
        }
        this.hibernateTemplate = hibernateTemplate;
    }

    public QueryBuilder<E> from(Class clazz) {
        return this.from(clazz, StringUtils.uncapitalize((String)clazz.getSimpleName()));
    }

    public QueryBuilder<E> useCache(boolean usecache) {
        return this.useCache(usecache, null);
    }

    public QueryBuilder<E> useCache(boolean usecache, CacheMode cacheMode) {
        this.useCache = usecache;
        this.cacheMode = cacheMode;
        return this;
    }

    public QueryBuilder<E> from(Class _clazz, String _alias) {
        if (!this.hasSelect) {
            this.select(_alias);
        }
        this.from = new From(_clazz);
        this.alias = _alias;
        return this;
    }

    public QueryBuilder<E> from(From from) {
        this.from(from.getFromClass(), StringUtils.uncapitalize((String)from.getFromClass().getSimpleName()));
        return this;
    }

    public QueryBuilder<E> select(String select) {
        this.select = new Select(select);
        this.hasSelect = true;
        return this;
    }

    public QueryBuilder<E> select(Select select) {
        this.select = select;
        this.hasSelect = true;
        return this;
    }

    public QueryBuilder<E> fetchCollection(String path) {
        this.fetchs.add(path);
        return this;
    }

    public QueryBuilder<E> join(JoinMode joinMode, boolean fetch, String path) {
        String path2;
        Join join = new Join(joinMode, fetch, path);
        this.joins.add(join);
        if (this.ignoreAllJoinPath && (path2 = this.getPath(path)) != null) {
            this.ignoreJoin(path2);
        }
        return this;
    }

    private String getPath(String path) {
        String[] split = path.split("[ ]+");
        if (split.length == 2) {
            return split[1];
        }
        split = path.split("\\.");
        if (split.length == 2) {
            return split[1];
        }
        return null;
    }

    public QueryBuilder<E> join(String path) {
        return this.join(JoinMode.INNER, false, path);
    }

    public QueryBuilder<E> joinFetch(String path) {
        return this.join(JoinMode.INNER, true, path);
    }

    public QueryBuilder<E> leftOuterJoin(String path) {
        return this.join(JoinMode.LEFT_OUTER, false, path);
    }

    public QueryBuilder<E> leftOuterJoinFetch(String path) {
        return this.join(JoinMode.LEFT_OUTER, true, path);
    }

    public QueryBuilder<E> whereLike(String whereClause, String parameter) {
        if (parameter != null && !parameter.equals("")) {
            if (parameter.indexOf(63) > 0) {
                throw new IllegalArgumentException("A cl\u00e1usula where do QueryBuilder n\u00e3o pode ter o caracter '?'. Deve ser passada apenas a express\u00e3o que se dejesa fazer o like. Veja javadoc!");
            }
            this.where(String.valueOf(whereClause) + " like ?", "%" + parameter + "%");
        }
        return this;
    }

    public QueryBuilder<E> whereIntervalMatches(String beginfield, String endfield, Object begin, Object end) {
        this.openParentheses().openParentheses().where(String.valueOf(beginfield) + " >= ?", begin).where(String.valueOf(endfield) + " <= ?", end).closeParentheses().or().openParentheses().where(String.valueOf(beginfield) + " >= ?", begin).where(String.valueOf(beginfield) + " <= ?", end).closeParentheses().or().openParentheses().where(String.valueOf(endfield) + " >= ?", begin).where(String.valueOf(endfield) + " <= ?", end).closeParentheses().or().openParentheses().where(String.valueOf(beginfield) + " <= ?", begin).where(String.valueOf(endfield) + " >= ?", end).closeParentheses().closeParentheses();
        return this;
    }

    public QueryBuilder<E> whereLikeIgnoreAll(String whereClause, String parameter) {
        if (parameter != null && !parameter.equals("")) {
            if (parameter.indexOf(63) > 0) {
                throw new IllegalArgumentException("A cl\u00e1usula where do QueryBuilder n\u00e3o pode ter o caracter '?'. Deve ser passada apenas a express\u00e3o que se deseja fazer o like. Veja javadoc!");
            }
            String funcaoTiraacento = Neo.getApplicationContext().getConfig().getProperties().getProperty("funcaoTiraacento");
            if (funcaoTiraacento != null) {
                this.where("UPPER(" + funcaoTiraacento + "(" + whereClause + ")) LIKE '%'||?||'%'", Util.strings.tiraAcento(parameter).toUpperCase());
            } else {
                this.where("UPPER(" + whereClause + ") LIKE '%'||?||'%'", Util.strings.tiraAcento(parameter).toUpperCase());
            }
        }
        return this;
    }

    public QueryBuilder<E> whereIn(String whereClause, Collection<?> collection, boolean emptyCollectionReturnTrue) {
        if (collection != null) {
            if (collection.isEmpty()) {
                if (!emptyCollectionReturnTrue) {
                    this.where("1 = 0");
                }
            } else {
                this.where(String.valueOf(whereClause) + " in (?)", collection);
            }
        } else if (!emptyCollectionReturnTrue) {
            this.where("1 = 0");
        }
        return this;
    }

    public QueryBuilder<E> whereIn(String whereClause, String values, boolean emptyCollectionReturnTrue) {
        if (values != null) {
            if (StringUtils.isEmpty((String)values)) {
                if (!emptyCollectionReturnTrue) {
                    this.where("1 = 0");
                }
            } else {
                this.where(String.valueOf(whereClause) + " in (" + values + ")");
            }
        } else if (!emptyCollectionReturnTrue) {
            this.where("1 = 0");
        }
        return this;
    }

    public QueryBuilder<E> whereIn(String whereClause, String values) {
        return this.whereIn(whereClause, values, true);
    }

    public QueryBuilder<E> whereIn(String whereClause, Collection<?> collection) {
        return this.whereIn(whereClause, collection, true);
    }

    public QueryBuilder<E> where(String whereClause, Object parameter, boolean addClause) {
        if (addClause) {
            this.where(whereClause, parameter);
        } else {
            this.bypassedlastWhere = true;
        }
        if (this.inOr) {
            this.inOr = false;
        }
        return this;
    }

    public QueryBuilder<E> where(String whereClause, Object parameter) {
        if (!(parameter == null || parameter instanceof String && parameter.equals(""))) {
            if (this.inOr) {
                this.where.or();
                this.inOr = false;
            } else {
                this.where.and();
            }
            this.where.append(whereClause, parameter);
            this.bypassedlastWhere = false;
        } else {
            this.bypassedlastWhere = true;
        }
        if (this.inOr) {
            this.inOr = false;
        }
        return this;
    }

    public QueryBuilder<E> where(String whereClause, Object[] parameters) {
        if (parameters == null) {
            return this;
        }
        boolean allBlank = true;
        int i = 0;
        while (i < parameters.length) {
            if (!(parameters[i] == null || parameters[i] instanceof String && parameters[i].equals(""))) {
                allBlank = false;
                break;
            }
            ++i;
        }
        if (!allBlank) {
            if (this.inOr) {
                this.where.or();
                this.inOr = false;
            } else {
                this.where.and();
            }
            this.where.append(whereClause, parameters);
            this.bypassedlastWhere = false;
        } else {
            this.bypassedlastWhere = true;
        }
        return this;
    }

    public QueryBuilder<E> where(String whereClause) {
        if (this.inOr) {
            this.where.or();
            this.inOr = false;
        } else {
            this.where.and();
        }
        this.where.append(whereClause);
        this.bypassedlastWhere = false;
        return this;
    }

    public QueryBuilder<E> where(String whereClause, boolean addClause) {
        if (addClause) {
            this.where(whereClause);
        }
        return this;
    }

    public QueryBuilder<E> whereWhen(String whereClause, Boolean include) {
        if (include != null && include.booleanValue()) {
            if (this.inOr) {
                this.where.or();
                this.inOr = false;
            } else {
                this.where.and();
            }
            this.where.append(whereClause);
            this.bypassedlastWhere = false;
        } else {
            this.bypassedlastWhere = true;
        }
        return this;
    }

    public QueryBuilder<E> where(Where where) {
        this.where = where;
        return this;
    }

    public QueryBuilder<E> orderBy(String order) {
        if (order != null && !order.trim().equals("")) {
            this.orderby = order;
        }
        return this;
    }

    public QueryBuilder<E> openParentheses() {
        if (this.inOr) {
            this.where.or();
            this.inOr = false;
        } else {
            this.where.and();
        }
        this.where.append("(");
        ++this.subConditionStack;
        return this;
    }

    public QueryBuilder<E> closeParentheses() {
        if (this.inOr) {
            this.inOr = false;
        }
        this.bypassedlastWhere = false;
        this.where.append(")");
        --this.subConditionStack;
        if (this.subConditionStack < 0) {
            throw new RuntimeException("N\u00e3o existem subcondicoes a serem fechadas");
        }
        return this;
    }

    public QueryBuilder<E> or() {
        if (!this.bypassedlastWhere) {
            this.inOr = true;
        }
        return this;
    }

    public QueryBuilder<E> idEq(Serializable serializable) {
        String idPropertyName = this.hibernateTemplate.getSessionFactory().getClassMetadata(this.from.getFromClass()).getIdentifierPropertyName();
        this.where(String.valueOf(this.alias) + "." + idPropertyName + " = ?", serializable);
        return this;
    }

    public QueryBuilder<E> entity(Object object) {
        if (object == null) {
            throw new NullPointerException("entity null");
        }
        Serializable id = this.hibernateTemplate.getSessionFactory().getClassMetadata(this.from.getFromClass()).getIdentifier(object, EntityMode.POJO);
        this.idEq(id);
        return this;
    }

    public QueryBuilder<E> groupBy(String groupBy, String having) {
        this.groupBy = new GroupBy(groupBy, having);
        return this;
    }

    public QueryBuilder<E> groupBy(String groupBy) {
        this.groupBy = new GroupBy(groupBy, null);
        return this;
    }

    public List<E> list() {
        QueryBuilderResultTranslator qbt = this.getQueryBuilderResultTranslator();
        Object execute = this.hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = QueryBuilder.this.createQuery(session);
                if (QueryBuilder.this.maxResults != Integer.MIN_VALUE) {
                    query.setMaxResults(QueryBuilder.this.maxResults);
                }
                if (QueryBuilder.this.firstResult != Integer.MIN_VALUE) {
                    query.setFirstResult(QueryBuilder.this.firstResult);
                }
                query.setCacheable(QueryBuilder.this.useCache);
                if (QueryBuilder.this.cacheMode != null) {
                    query.setCacheMode(QueryBuilder.this.cacheMode);
                }
                List list = query.list();
                try {
                    for (Object object : list) {
                        QueryBuilder.this.initializeProxys(object);
                    }
                }
                catch (RuntimeException e) {
                    StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                    throw new RuntimeException("Erro ao inicializar Proxys (Cole\u00e7\u00f5es). " + stackTrace[7], e);
                }
                LinkedHashSet linkedHashSet = new LinkedHashSet(list);
                ArrayList arrayList = new ArrayList(linkedHashSet);
                return arrayList;
            }
        });
        if (qbt != null) {
            execute = this.organizeListWithResultTranslator(qbt, (List)execute);
        }
        return (List)execute;
    }

    public Iterator<E> iterate() {
        final Session session = SessionFactoryUtils.getNewSession((SessionFactory)this.hibernateTemplate.getSessionFactory(), (Interceptor)this.hibernateTemplate.getEntityInterceptor());
        Query query = this.createQuery(session);
        if (this.maxResults != Integer.MIN_VALUE) {
            query.setMaxResults(this.maxResults);
        }
        if (this.firstResult != Integer.MIN_VALUE) {
            query.setFirstResult(this.firstResult);
        }
        final Iterator iterator = query.iterate();
        Iterator closeSessionIterator = new Iterator<E>(){

            @Override
            public boolean hasNext() {
                boolean hasNext = iterator.hasNext();
                if (!hasNext && session.isConnected()) {
                    session.close();
                }
                return hasNext;
            }

            @Override
            public E next() {
                Object next = iterator.next();
                QueryBuilder.this.initializeProxys(next);
                return next;
            }

            @Override
            public void remove() {
                iterator.remove();
            }

            protected void finalize() throws Throwable {
                if (session.isConnected()) {
                    session.close();
                }
            }
        };
        return closeSessionIterator;
    }

    public E unique() {
        QueryBuilderResultTranslator qbt = this.getQueryBuilderResultTranslator();
        final boolean useUnique = qbt == null;
        Object execute = this.hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query query = QueryBuilder.this.createQuery(session);
                if (QueryBuilder.this.maxResults != Integer.MIN_VALUE) {
                    if (QueryBuilder.this.maxResults != 1) {
                        throw new IllegalArgumentException("Para usar o m\u00e9todo unique do " + QueryBuilder.class.getSimpleName() + " o maxResults deve ser 1, ou ent\u00e3o n\u00e3o deve ser modificado");
                    }
                    query.setMaxResults(QueryBuilder.this.maxResults);
                }
                if (QueryBuilder.this.firstResult != Integer.MIN_VALUE) {
                    query.setFirstResult(QueryBuilder.this.firstResult);
                }
                query.setCacheable(QueryBuilder.this.useCache);
                if (QueryBuilder.this.cacheMode != null) {
                    query.setCacheMode(QueryBuilder.this.cacheMode);
                }
                Object uniqueResult = useUnique ? query.uniqueResult() : query.list();
                try {
                    QueryBuilder.this.initializeProxys(uniqueResult);
                }
                catch (RuntimeException e) {
                    StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                    throw new RuntimeException("Erro ao inicializar Proxys (Cole\u00e7\u00f5es). " + stackTrace[7], e);
                }
                session.evict(uniqueResult);
                return uniqueResult;
            }
        });
        if (qbt != null) {
            execute = execute instanceof List ? (((List)(execute = this.organizeListWithResultTranslator(qbt, (List)execute))).size() == 0 ? null : ((List)execute).get(0)) : this.organizeUniqueResultWithTranslator(qbt, (Object[])execute);
        }
        return (E)execute;
    }

    private Object organizeUniqueResultWithTranslator(QueryBuilderResultTranslator qbt, Object[] execute) {
        Object[] resultado = execute;
        Object novoResultado = qbt.translate(resultado);
        return novoResultado;
    }

    private Object organizeListWithResultTranslator(QueryBuilderResultTranslator qbt, List execute) {
        ArrayList resultado = execute;
        ArrayList novoResultado = new ArrayList(resultado.size());
        int j = 0;
        while (j < resultado.size()) {
            Object translate = qbt.translate((Object[])resultado.get(j));
            if (translate != null) {
                novoResultado.add(translate);
            }
            ++j;
        }
        execute = novoResultado;
        return execute;
    }

    public void ignoreJoin(String ... alias) {
        this.ignoreJoinPaths.addAll((Collection<String>)Arrays.asList(alias));
    }

    public QueryBuilder<E> ignoreAllJoinsPath(boolean ignore) {
        this.ignoreAllJoinPath = ignore;
        return this;
    }

    private QueryBuilderResultTranslator getQueryBuilderResultTranslator() {
        String selectString;
        QueryBuilderResultTranslatorImpl qbt = null;
        if (this.useTranslator && (selectString = this.select.select).contains(".")) {
            qbt = new QueryBuilderResultTranslatorImpl();
            if (this.translatorAlias != null) {
                qbt.setResultAlias(this.translatorAlias);
            }
            ArrayList<AliasMap> aliasMaps = new ArrayList<AliasMap>();
            aliasMaps.add(new AliasMap(this.alias, null, this.from.getFromClass()));
            for (Join join : this.joins) {
                String[] joinpath = join.path.split(" +");
                if (join.fetch) {
                    throw new UsefullNeoException("\u00c9 necess\u00e1rio utilizar joins sem Fetch quando especificar os campos a serem selecionados. Erro no join: " + join);
                }
                if (joinpath.length < 2) {
                    throw new UsefullNeoException("\u00c9 necess\u00e1rio informar um alias para todos os joins quando especificar os campos a serem selecionados. Erro no join: " + join);
                }
                if (this.ignoreJoinPaths.contains(joinpath[1])) continue;
                aliasMaps.add(new AliasMap(joinpath[1], joinpath[0], null));
            }
            int indexOfDistinct = selectString.indexOf("distinct ");
            if (indexOfDistinct >= 0 && selectString.substring(0, indexOfDistinct).trim().equals("")) {
                selectString = selectString.substring(indexOfDistinct + 9);
            }
            String[] properties = selectString.split("( )*?,( )*?");
            int j = 0;
            while (j < properties.length) {
                String property = properties[j];
                if (!property.trim().matches("[^ ]+\\.[^ ]+( +as +[^ ]+)?")) {
                    throw new RuntimeException("O campo \"" + property + "\" do select n\u00e3o \u00e9 v\u00e1lido.");
                }
                int indexOfAs = property.indexOf(" as");
                if (indexOfAs > 0) {
                    properties[j] = property.substring(0, indexOfAs);
                }
                properties[j] = properties[j].trim();
                ++j;
            }
            qbt.init(properties, aliasMaps.toArray(new AliasMap[aliasMaps.size()]));
            String[] extraFields = qbt.getExtraFields();
            String extraFieldsSelect = "";
            int j2 = 0;
            while (j2 < extraFields.length) {
                String extra = extraFields[j2];
                extraFieldsSelect = String.valueOf(extraFieldsSelect) + ", ";
                extraFieldsSelect = String.valueOf(extraFieldsSelect) + extra;
                ++j2;
            }
            Select select = this.select;
            select.select = String.valueOf(select.select) + extraFieldsSelect;
        }
        return qbt;
    }

    private void initializeProxys(Object object) {
        ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
        for (String fetch : this.fetchs) {
            try {
                Method method = reflectionCache.getMethod(object.getClass(), "get" + StringUtils.capitalize((String)fetch), new Class[0]);
                Object proxy = method.invoke(object, new Object[0]);
                Hibernate.initialize((Object)proxy);
            }
            catch (NoSuchMethodException e) {
                throw new UsefullNeoException("Erro ao tentar fazer fetch de " + fetch + " em " + this.from.getFromClass().getName() + ". \nA classe " + this.from.getFromClass().getName() + " n\u00e3o possui getter para a propriedade '" + fetch + "'", e);
            }
            catch (Exception e) {
                throw new UsefullNeoException("Erro ao tentar fazer fetch de " + fetch + " em " + this.from.getFromClass().getName(), e);
            }
        }
    }

    private Query createQuery(Session session) {
        Query query;
        String queryString = null;
        try {
            queryString = this.getQuery();
            query = session.createQuery(queryString);
        }
        catch (NullPointerException e) {
            throw new RuntimeException("NullPointerException ao criar query \n\t" + queryString, e);
        }
        int i = 0;
        while (i < this.where.getParameters().size()) {
            query.setParameter(i, this.where.getParameters().get(i));
            ++i;
        }
        return query;
    }

    public String getQuery() {
        if (this.from == null) {
            throw new RuntimeException("N\u00e3o foi informada a cl\u00e1usula from da Query");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.select);
        stringBuilder.append(" ");
        stringBuilder.append(this.from);
        stringBuilder.append(" ");
        for (Join join : this.joins) {
            stringBuilder.append(join);
            stringBuilder.append(" ");
        }
        stringBuilder.append(this.where);
        if (this.groupBy != null) {
            stringBuilder.append(" ");
            stringBuilder.append(this.groupBy);
        }
        if (this.orderby != null) {
            stringBuilder.append(" ORDER BY ");
            stringBuilder.append(this.orderby);
        }
        String hibernateQuery = stringBuilder.toString();
        log.info((Object)hibernateQuery);
        return hibernateQuery;
    }

    public HibernateTemplate getHibernateTemplate() {
        return this.hibernateTemplate;
    }

    public From getFrom() {
        return this.from;
    }

    public void setFrom(From from) {
        this.from = from;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public void setJoins(List<Join> joins) {
        this.joins = joins;
    }

    public Select getSelect() {
        return this.select;
    }

    public void setSelect(Select select) {
        this.select = select;
    }

    public Where getWhere() {
        return this.where;
    }

    public void setWhere(Where where) {
        this.where = where;
    }

    public String getAlias() {
        return this.alias;
    }

    public QueryBuilder<E> setFirstResult(int firstResult) {
        this.firstResult = firstResult;
        return this;
    }

    public QueryBuilder<E> setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public class From {
        private Class from;

        public Class getFromClass() {
            return this.from;
        }

        public From(Class from) {
            this.from = from;
        }

        public String toString() {
            return "FROM " + this.from.getName() + " " + QueryBuilder.this.alias;
        }
    }

    public class GroupBy {
        private String groupBy;
        private String having;

        public GroupBy(String groupBy, String having) {
            this.groupBy = groupBy;
            this.having = having;
        }

        public String toString() {
            String string = "GROUP BY " + this.groupBy;
            if (this.having != null) {
                string = String.valueOf(string) + " HAVING " + this.having;
            }
            return string;
        }
    }

    public class Join {
        private JoinMode joinMode;
        private boolean fetch;
        private String path;

        public Join(JoinMode mode, boolean fetch, String path) {
            this.joinMode = mode;
            this.fetch = fetch;
            this.path = path;
        }

        public boolean isFetch() {
            return this.fetch;
        }

        public JoinMode getJoinMode() {
            return this.joinMode;
        }

        public String getPath() {
            return this.path;
        }

        public String toString() {
            String stringJoinMode;
            if (this.joinMode.equals((Object)JoinMode.LEFT_OUTER)) {
                stringJoinMode = "LEFT OUTER";
            } else if (this.joinMode.equals((Object)JoinMode.RIGHT_OUTER)) {
                stringJoinMode = "RIGHT OUTER";
            } else if (this.joinMode.equals((Object)JoinMode.INNER)) {
                stringJoinMode = "INNER";
            } else {
                throw new RuntimeException("Constante JoinMode." + (Object)((Object)this.joinMode) + " desconhecida.");
            }
            return " " + stringJoinMode + " JOIN " + (this.fetch ? "FETCH " : "") + this.path;
        }

        public String dontFetchToString() {
            return " " + (Object)((Object)this.joinMode) + " JOIN " + this.path;
        }
    }

    public class Select {
        private String select;

        public Select(String select) {
            this.select = select;
        }

        public String toString() {
            return "SELECT " + this.select;
        }

        public String getValue() {
            return this.select;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Where {
        private StringBuilder stringBuilder = new StringBuilder();
        private List<Object> parameters = new ArrayList<Object>();
        boolean inParentesis;

        public List<Object> getParameters() {
            return this.parameters;
        }

        public void or() {
            if (this.stringBuilder.length() > 0 && !this.inParentesis) {
                this.append(" OR ");
            }
        }

        public void and() {
            if (this.stringBuilder.length() > 0 && !this.inParentesis) {
                this.append(" AND ");
            }
        }

        public void append(String string, Object parameter) {
            this.inParentesis = false;
            this.stringBuilder.append(string);
            this.parameters.add(parameter);
        }

        public void append(String string, Object[] parameters) {
            this.inParentesis = false;
            this.stringBuilder.append(string);
            Object[] objectArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Object parameter = objectArray[n2];
                this.parameters.add(parameter);
                ++n2;
            }
        }

        public void append(String string) {
            if (")".equals(string) && this.inParentesis) {
                this.inParentesis = this.stringBuilder.substring(this.stringBuilder.length() - 1, this.stringBuilder.length()).equals("( ");
                this.stringBuilder.delete(this.stringBuilder.length() - 2, this.stringBuilder.length());
                this.stringBuilder.append(" 1=1 ");
                return;
            }
            this.inParentesis = "(".equals(string);
            this.stringBuilder.append(string);
            this.stringBuilder.append(" ");
        }

        public String toString() {
            if (this.stringBuilder.length() == 0) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            builder.append("WHERE ");
            builder.append((CharSequence)this.stringBuilder);
            return builder.toString();
        }

        public Where clone() {
            Where clone = new Where();
            clone.stringBuilder.append(this.stringBuilder.toString());
            clone.parameters.addAll(this.parameters);
            return clone;
        }
    }
}

