/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.persistence;

import br.com.linkcom.neo.core.standard.Neo;
import br.com.linkcom.neo.util.ReflectionCache;
import br.com.linkcom.neo.util.ReflectionCacheFactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleSQLErrorCodeSQLExceptionTranslator
extends SQLErrorCodeSQLExceptionTranslator {
    static String errorRegex = "ORA-(?:\\d*?): restri\u00e7\u00e3o de integridade \\((.*)?\\) violada - registro filho localizado\n";
    static String errorRegexIngles = "ORA-(?:\\d*?): integrity constraint \\((.*)?\\) violated - child record found\n";
    static Pattern pattern = Pattern.compile(errorRegex);
    static Pattern patternIngles = Pattern.compile(errorRegexIngles);
    static final Log log = LogFactory.getLog(OracleSQLErrorCodeSQLExceptionTranslator.class);
    private DataSource dataSource;

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
        this.dataSource = dataSource;
    }

    private String getTableName(Class<?> entityClass) {
        ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
        Table table = reflectionCache.getAnnotation(entityClass, Table.class);
        if (table != null) {
            return table.name().toUpperCase();
        }
        return entityClass.getSimpleName().toUpperCase();
    }

    protected DataAccessException customTranslate(String task, String sql, SQLException sqlEx) {
        if (sqlEx.getNextException() != null) {
            sqlEx = sqlEx.getNextException();
        }
        String errorMessage = sqlEx.getMessage();
        Matcher matcher = pattern.matcher(errorMessage);
        Matcher matcherIngles = patternIngles.matcher(errorMessage);
        if (!matcher.find()) {
            matcher = matcherIngles;
        } else {
            matcher.reset();
        }
        if (matcher.find()) {
            String fk_name = matcher.group(1);
            if (fk_name.contains(".")) {
                fk_name = fk_name.substring(fk_name.indexOf(46) + 1, fk_name.length());
            }
            String fk_table_name = matcher.group(1).toUpperCase();
            String pk_table_name = matcher.group(1).toUpperCase();
            String fkTableDisplayName = null;
            String pkTableDisplayName = null;
            Connection connection = null;
            try {
                try {
                    connection = this.dataSource.getConnection();
                    DatabaseMetaData metaData = connection.getMetaData();
                    ResultSet importedKeys = metaData.getImportedKeys(null, null, null);
                    while (importedKeys.next()) {
                        if (!importedKeys.getString("FK_NAME").equals(fk_name)) continue;
                        pk_table_name = importedKeys.getString("PKTABLE_NAME");
                        if (pk_table_name != null) {
                            pk_table_name = pk_table_name.toUpperCase();
                        }
                        if ((fk_table_name = importedKeys.getString("FKTABLE_NAME")) == null) continue;
                        fk_table_name = fk_table_name.toUpperCase();
                    }
                }
                catch (SQLException e) {
                    log.warn((Object)"N\u00e3o foi poss\u00edvel conseguir o metadata do banco para ler informacoes de FK.");
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            Class<?>[] entities = Neo.getApplicationContext().getClassManager().getClassesWithAnnotation(Entity.class);
            pkTableDisplayName = pk_table_name;
            fkTableDisplayName = fk_table_name;
            Class<?>[] classArray = entities;
            int n = entities.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> entityClass = classArray[n2];
                String tableName = this.getTableName(entityClass);
                if (tableName.equals(pk_table_name)) {
                    pkTableDisplayName = Neo.getApplicationContext().getBeanDescriptor(null, entityClass).getDisplayName();
                }
                if (tableName.equals(fk_table_name)) {
                    fkTableDisplayName = Neo.getApplicationContext().getBeanDescriptor(null, entityClass).getDisplayName();
                }
                ++n2;
            }
            String mensagem = null;
            if (sql.toLowerCase().trim().startsWith("delete")) {
                mensagem = "N\u00e3o foi poss\u00edvel remover " + pkTableDisplayName.toLowerCase() + ". Existe(m) registro(s) vinculado(s) em " + fkTableDisplayName.toLowerCase() + ".";
            } else if (sql.toLowerCase().trim().startsWith("update")) {
                mensagem = "N\u00e3o foi poss\u00edvel atualizar " + fkTableDisplayName.toLowerCase() + ". A refer\u00eancia para " + pkTableDisplayName.toLowerCase() + " \u00e9 inv\u00e1lida.";
            } else if (sql.toLowerCase().trim().startsWith("insert")) {
                mensagem = "N\u00e3o foi poss\u00edvel inserir " + fkTableDisplayName.toLowerCase() + ". A refer\u00eancia para " + pkTableDisplayName.toLowerCase() + " \u00e9 inv\u00e1lida.";
            }
            return new ForeignKeyException(mensagem);
        }
        int indexOf = errorMessage.indexOf("APP");
        if (indexOf > 0) {
            errorMessage = errorMessage.substring(indexOf + 3);
            return new ApplicationDatabaseException(errorMessage);
        }
        return null;
    }

    public static class ApplicationDatabaseException
    extends DataAccessException {
        private static final long serialVersionUID = 1L;

        public ApplicationDatabaseException(String msg) {
            super(msg);
        }
    }

    public static class ForeignKeyException
    extends DataAccessException {
        private static final long serialVersionUID = 1L;

        public ForeignKeyException(String msg) {
            super(msg);
        }
    }
}

