/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.crypto;

import br.com.linkcom.neo.exception.NeoException;
import br.com.linkcom.neo.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class MacUtil {
    protected String patternAuthentication = "(.*?)\\[(\\d{8})\\-([A-Za-z0-9\\+/]+={1,2})\\]";
    protected String patternDate = "ddMMyyyy";

    public String generateMacKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGen = KeyGenerator.getInstance("HmacSHA1");
        SecretKey key = keyGen.generateKey();
        byte[] keyArray = key.getEncoded();
        String keyString = new BASE64Encoder().encode(keyArray);
        return keyString;
    }

    public String authenticateMessage(String message, String keyString) throws IOException, NoSuchAlgorithmException, InvalidKeyException {
        String simplifiedMessage = this.simplifyMessage(message);
        String oneLineMessage = this.oneLineMessage(simplifiedMessage);
        String digestString = this.generateMac(oneLineMessage, keyString);
        String encapsulatedMessage = this.encapsulateMessage(simplifiedMessage, digestString);
        return encapsulatedMessage;
    }

    public String generateAuthentication(String message, String keyString) throws IOException, NoSuchAlgorithmException, InvalidKeyException {
        String simplifiedMessage = this.simplifyMessage(message);
        String oneLineMessage = this.oneLineMessage(simplifiedMessage);
        String digestString = this.generateMac(oneLineMessage, keyString);
        String tagLine = this.generateTagline(digestString);
        return tagLine;
    }

    public boolean validateMessage(String message, String keyString) throws ParseException, InvalidKeyException, NoSuchAlgorithmException, IOException {
        String generatedMac;
        String msg = this.getMessage(message);
        String simplifiedMessage = this.simplifyMessage(msg);
        String oneLineMessage = this.oneLineMessage(simplifiedMessage);
        String mac = this.getMac(message);
        return mac.equals(generatedMac = this.generateMac(oneLineMessage, keyString));
    }

    private String getMessage(String message) throws ParseException {
        Pattern pattern = Pattern.compile(this.patternAuthentication, 32);
        Matcher matcher = pattern.matcher(message);
        if (matcher.find()) {
            String msg = matcher.group(1);
            return msg;
        }
        throw new NeoException("Mensagem inv\u00e1lida");
    }

    public Date getDate(String message) throws ParseException {
        Pattern pattern = Pattern.compile(this.patternAuthentication, 32);
        Matcher matcher = pattern.matcher(message);
        if (matcher.find()) {
            String dateString = matcher.group(2);
            Date date = new SimpleDateFormat(this.patternDate).parse(dateString);
            return date;
        }
        throw new NeoException("Mensagem inv\u00e1lida");
    }

    private String getMac(String message) throws ParseException {
        Pattern pattern = Pattern.compile(this.patternAuthentication, 32);
        Matcher matcher = pattern.matcher(message);
        if (matcher.find()) {
            String mac = matcher.group(3);
            return mac;
        }
        throw new NeoException("Mensagem inv\u00e1lida");
    }

    private String generateMac(String oneLineMessage, String keyString) throws NoSuchAlgorithmException, IOException, InvalidKeyException {
        byte[] keyArray = new BASE64Decoder().decodeBuffer(keyString);
        SecretKeySpec key = new SecretKeySpec(keyArray, "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(key);
        byte[] messageArray = oneLineMessage.getBytes("ISO-8859-1");
        byte[] digest = mac.doFinal(messageArray);
        String digestString = new BASE64Encoder().encode(digest);
        return digestString;
    }

    private String simplifyMessage(String message) {
        message = Util.strings.tiraAcento(message);
        message = message.replaceAll("[^\\p{Graph}\\n\\r]", " ");
        message = message.replaceAll(" +", " ");
        message = message.trim();
        return message;
    }

    private String oneLineMessage(String message) {
        message = message.replaceAll("[\\n\\r]", " ");
        message = message.replaceAll(" +", " ");
        message = message.trim();
        return message;
    }

    private String encapsulateMessage(String simplifiedMessage, String digestString) {
        return String.valueOf(simplifiedMessage) + "\n" + this.generateTagline(digestString);
    }

    public String generateTagline(String digestString) {
        String date = new SimpleDateFormat(this.patternDate).format(new Date());
        return "[" + date + "-" + digestString + "]";
    }

    public static void main(String[] args) throws NoSuchAlgorithmException, InvalidKeyException, IOException, ParseException {
        String message = "Fabr\u00edcio  - 20/08/1978 -> R$ 123.456,78 []{}*()-=_+\nlala\n\nlele";
        System.out.println(message);
        System.out.println("===================");
        String keyString = Util.crypto.generateMacKey();
        System.out.println(keyString);
        System.out.println("===================");
        String authenticatedMessage = Util.crypto.authenticateMessage(message, keyString);
        System.out.println(authenticatedMessage);
        System.out.println("===================");
        String enteredMessage = "";
        BufferedReader entrada = new BufferedReader(new InputStreamReader(System.in));
        String linha = entrada.readLine();
        while (!linha.equals(".")) {
            enteredMessage = String.valueOf(enteredMessage) + linha + "\n";
            linha = entrada.readLine();
        }
        System.out.println("===================");
        String enteredkey = "";
        linha = entrada.readLine();
        while (!linha.equals(".")) {
            enteredkey = String.valueOf(enteredkey) + linha + "\n";
            linha = entrada.readLine();
        }
        enteredkey = enteredkey.replaceAll("\\s", "");
        System.out.println("===================");
        Date data = Util.crypto.getDate(enteredMessage);
        System.out.println(data);
        System.out.println("===================");
        boolean ok = Util.crypto.validateMessage(enteredMessage, enteredkey);
        System.out.println(ok);
        System.out.println("===================");
    }
}

