/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.crypto;

import br.com.linkcom.neo.crypto.MacUtil;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.Date;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class CryptoUtil {
    MacUtil macUtil = new MacUtil();

    public String generateMacKey() throws NoSuchAlgorithmException {
        return this.macUtil.generateMacKey();
    }

    public String authenticateMessage(String message, String keyString) throws IOException, NoSuchAlgorithmException, InvalidKeyException {
        return this.macUtil.authenticateMessage(message, keyString);
    }

    public String generateAuthentication(String message, String keyString) throws IOException, NoSuchAlgorithmException, InvalidKeyException {
        return this.macUtil.generateAuthentication(message, keyString);
    }

    public Date getDate(String message) throws ParseException {
        return this.macUtil.getDate(message);
    }

    public boolean validateMessage(String message, String keyString) throws ParseException, InvalidKeyException, NoSuchAlgorithmException, IOException {
        return this.macUtil.validateMessage(message, keyString);
    }

    public static String generateMacBase64(String message, String key) throws NoSuchAlgorithmException, IOException, InvalidKeyException {
        byte[] messageArray = message.getBytes("ISO-8859-1");
        byte[] keyArray = key.getBytes("ISO-8859-1");
        SecretKeySpec secretKey = new SecretKeySpec(keyArray, "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(secretKey);
        byte[] digestArray = mac.doFinal(messageArray);
        byte[] digestBase64Array = Base64.encodeBase64((byte[])digestArray);
        String digest = new String(digestBase64Array, "ISO-8859-1");
        return digest;
    }
}

