/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.core.web;

import br.com.linkcom.neo.authorization.User;
import br.com.linkcom.neo.controller.Message;
import br.com.linkcom.neo.controller.MessageType;
import br.com.linkcom.neo.core.web.NeoWeb;
import br.com.linkcom.neo.core.web.WebApplicationContext;
import br.com.linkcom.neo.core.web.WebRequestContext;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.validation.BindException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWebRequestContext
implements WebRequestContext {
    String USER_ATTRIBUTE = "USER";
    String lastAction;
    HttpServletRequest httpServletRequest;
    HttpServletResponse httpServletResponse;
    String requestQuery;
    List<Message> messages = null;
    BindException bindException = new BindException(new Object(), "");
    private String firstRequestUrl;
    private WebApplicationContext applicationContext;

    public DefaultWebRequestContext(HttpServletRequest request, HttpServletResponse response, WebApplicationContext applicationContext) {
        this.httpServletRequest = request;
        this.httpServletResponse = response;
        this.applicationContext = applicationContext;
        String pathInfo = this.httpServletRequest.getPathInfo();
        if (pathInfo == null) {
            pathInfo = "";
        }
        this.firstRequestUrl = String.valueOf(this.httpServletRequest.getServletPath()) + pathInfo;
        this.messages = this.getSessionMessages();
        this.getRequestQuery();
    }

    private List<Message> getSessionMessages() {
        HttpSession session = this.httpServletRequest.getSession();
        ArrayList attribute = (ArrayList)session.getAttribute("_MESSAGES");
        if (attribute == null) {
            attribute = new ArrayList();
            session.setAttribute("_MESSAGES", attribute);
        }
        return attribute;
    }

    @Override
    public String getRequestQuery() {
        if (this.requestQuery == null) {
            this.requestQuery = String.valueOf(this.httpServletRequest.getServletPath()) + (this.httpServletRequest.getPathInfo() != null ? this.httpServletRequest.getPathInfo() : "");
        }
        return this.requestQuery;
    }

    @Override
    public String getParameter(String parameter) {
        return this.httpServletRequest.getParameter(parameter);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.httpServletRequest.setAttribute(name, value);
    }

    @Override
    public Principal getUserPrincipal() {
        return this.httpServletRequest.getUserPrincipal();
    }

    @Override
    public User getUser() {
        return (User)this.httpServletRequest.getSession().getAttribute(this.USER_ATTRIBUTE);
    }

    public void setUser(User user) {
        this.httpServletRequest.getSession().setAttribute(this.USER_ATTRIBUTE, (Object)user);
    }

    @Override
    public boolean hasRole(String role) {
        return this.httpServletRequest.getSession().getAttribute("PAPEL_" + role.toUpperCase()) != null;
    }

    @Override
    public HttpServletRequest getServletRequest() {
        return this.httpServletRequest;
    }

    @Override
    public HttpServletResponse getServletResponse() {
        return this.httpServletResponse;
    }

    @Override
    public Object getAttribute(String name) {
        return this.httpServletRequest.getAttribute(name);
    }

    @Override
    public String getFirstRequestUrl() {
        return this.firstRequestUrl;
    }

    public String getCurrentModule() {
        String uri;
        if (this.getServletRequest().getAttribute("NEO_MODULO") == null && (uri = this.getServletRequest().getRequestURI()).matches("/.+?/.+?/.*")) {
            this.getServletRequest().setAttribute("NEO_MODULO", (Object)uri.split("/")[2]);
        }
        return this.getServletRequest().getAttribute("NEO_MODULO").toString();
    }

    @Override
    public WebApplicationContext getWebApplicationContext() {
        return NeoWeb.getWebApplicationContext(this.httpServletRequest.getSession().getServletContext());
    }

    @Override
    public HttpSession getSession() {
        return this.httpServletRequest.getSession();
    }

    @Override
    public BindException getBindException() {
        return this.bindException;
    }

    public void setBindException(BindException bindException) {
        this.bindException = bindException;
    }

    @Override
    public Message[] getMessages() {
        return this.messages.toArray(new Message[this.messages.size()]);
    }

    @Override
    public void addMessage(Object source) {
        this.messages.add(new Message(MessageType.INFO, source));
    }

    @Override
    public void addError(Object source) {
        this.messages.add(new Message(MessageType.ERROR, source));
    }

    @Override
    public void clearMessages() {
        this.messages.clear();
    }

    @Override
    public void addMessage(Object source, MessageType type) {
        this.messages.add(new Message(type, source));
    }

    @Override
    public String getLastAction() {
        if (this.lastAction == null) {
            this.lastAction = this.httpServletRequest.getParameter("ACAO");
        }
        return this.lastAction;
    }

    @Override
    public void setLastAction(String lastAction) {
        this.lastAction = lastAction;
    }

    @Override
    public WebApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public Object getUserAttribute(String name) {
        return this.httpServletRequest.getSession().getAttribute(name);
    }

    @Override
    public void setUserAttribute(String name, Object value) {
        this.httpServletRequest.getSession().setAttribute(name, value);
    }
}

