/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.core.standard;

import br.com.linkcom.neo.authorization.User;
import br.com.linkcom.neo.classmanager.ClassRegister;
import br.com.linkcom.neo.core.config.Config;
import br.com.linkcom.neo.core.config.DefaultConfig;
import br.com.linkcom.neo.core.standard.ApplicationContext;
import br.com.linkcom.neo.core.standard.DataSourceInfo;
import br.com.linkcom.neo.core.standard.DefaultApplicationContext;
import br.com.linkcom.neo.core.standard.DefaultRequestContext;
import br.com.linkcom.neo.core.standard.Neo;
import br.com.linkcom.neo.core.standard.RequestContext;
import br.com.linkcom.neo.core.standard.StandardDataSourceConfigStrategy;
import br.com.linkcom.neo.core.standard.init.AnnotationsXmlApplicationContext;
import br.com.linkcom.neo.core.web.init.NeoBeanFactoryPostProcessor;
import br.com.linkcom.neo.exception.NeoException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class NeoStandard
extends Neo {
    private static DataSourceInfo dataSourceInfo;

    public static void configureDataSource(String driver, String url, String username, String password) {
        dataSourceInfo = new DataSourceInfo(driver, url, username, password);
    }

    public static void createNeoApplicationContext(Config config) {
        DefaultApplicationContext applicationContext = new DefaultApplicationContext(config);
        Neo.applicationContext.set(applicationContext);
    }

    public static void createNeoApplicationContext() {
        NeoStandard.createNeoApplicationContext(new DefaultConfig());
    }

    public static RequestContext createNeoContext(String ... locations) {
        NeoStandard.initLog4J();
        AnnotationsXmlApplicationContext xac = new AnnotationsXmlApplicationContext(locations);
        NeoBeanFactoryPostProcessor neoBeanFactoryPostProcessor = null;
        StandardDataSourceConfigStrategy configStrategy = new StandardDataSourceConfigStrategy(dataSourceInfo);
        try {
            neoBeanFactoryPostProcessor = new NeoBeanFactoryPostProcessor(ClassRegister.getClassManager(), configStrategy);
        }
        catch (IOException e) {
            throw new NeoException("N\u00e3o foi poss\u00edvel inicializar o contexto NEO ", e);
        }
        xac.addBeanFactoryPostProcessor(neoBeanFactoryPostProcessor);
        xac.refresh();
        Map map = xac.getBeansOfType(Config.class);
        Object nomeBean = map.keySet().iterator().next();
        Config config = (Config)map.get(nomeBean);
        NeoStandard.createNeoApplicationContext(config);
        config.init();
        xac.setBeanRegisters(config.getBeanRegisters());
        xac.setTypeBeanRegisters(config.getTypeBeanRegisters());
        xac.refresh();
        DefaultRequestContext requestContext = new DefaultRequestContext((ApplicationContext)applicationContext.get());
        Neo.requestContext.set(requestContext);
        return requestContext;
    }

    public static void initLog4J() {
        Properties properties = new Properties();
        properties.setProperty("log4j.defaultInitOverride", "false");
        properties.setProperty("log4j.rootCategory", "INFO, console");
        properties.setProperty("log4j.appender.console", "org.apache.log4j.ConsoleAppender");
        properties.setProperty("log4j.appender.console.layout", "org.apache.log4j.PatternLayout");
        properties.setProperty("log4j.appender.console.layout.ConversionPattern", "%-5p %c %x - %m%n");
    }

    public static RequestContext createNeoContext() {
        return NeoStandard.createNeoContext(new String[0]);
    }

    public static void setUser(User user) {
        DefaultRequestContext requestContext2 = (DefaultRequestContext)Neo.getRequestContext();
        requestContext2.setUser(user);
    }
}

