/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.core.config;

import br.com.linkcom.neo.authorization.AuthorizationDAO;
import br.com.linkcom.neo.authorization.AuthorizationManager;
import br.com.linkcom.neo.authorization.PermissionLocator;
import br.com.linkcom.neo.authorization.UserLocator;
import br.com.linkcom.neo.authorization.impl.AuthorizationDAOImpl;
import br.com.linkcom.neo.authorization.impl.AuthorizationManagerImpl;
import br.com.linkcom.neo.authorization.impl.ControlMappingLocatorImpl;
import br.com.linkcom.neo.authorization.impl.PermissionLocatorImpl;
import br.com.linkcom.neo.authorization.impl.UserLocatorImpl;
import br.com.linkcom.neo.bean.AnnotatedBeanRegister;
import br.com.linkcom.neo.bean.BeanDescriptorFactory;
import br.com.linkcom.neo.bean.BeanDescriptorFactoryImpl;
import br.com.linkcom.neo.bean.BeanRegisterBean;
import br.com.linkcom.neo.bean.BeanRegisterCrud;
import br.com.linkcom.neo.bean.BeanRegisterDao;
import br.com.linkcom.neo.bean.BeanRegisterService;
import br.com.linkcom.neo.bean.ControllerBeanRegister;
import br.com.linkcom.neo.bean.CrudBeanRegister;
import br.com.linkcom.neo.bean.DAOBeanRegister;
import br.com.linkcom.neo.bean.ServiceBeanRegister;
import br.com.linkcom.neo.bean.TypeBeanRegister;
import br.com.linkcom.neo.controller.ControlMappingLocator;
import br.com.linkcom.neo.core.config.AuthenticationConfig;
import br.com.linkcom.neo.core.config.Config;
import br.com.linkcom.neo.core.config.ValidatorRegistry;
import br.com.linkcom.neo.core.standard.Neo;
import br.com.linkcom.neo.core.web.WebApplicationContext;
import br.com.linkcom.neo.exception.ReportException;
import br.com.linkcom.neo.report.ReportGenerator;
import br.com.linkcom.neo.report.ReportGeneratorImpl;
import br.com.linkcom.neo.report.ReportNameResolverImpl;
import br.com.linkcom.neo.report.ReportTranslatorImpl;
import br.com.linkcom.neo.rtf.RTFGenerator;
import br.com.linkcom.neo.rtf.RTFGeneratorImpl;
import br.com.linkcom.neo.rtf.RTFNameResolverImpl;
import br.com.linkcom.neo.validation.ValidatorRegistryImpl;
import java.util.Properties;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class DefaultConfig
implements Config {
    public static final String AUTO_CONFIG_HIBERNATE = "autoConfigHibernate";
    public static final String HIBERNATE_DIALECT = "dialect";
    protected DefaultListableBeanFactory defaultListableBeanFactory;
    protected static final AnnotatedBeanRegister[] beanRegisters = new AnnotatedBeanRegister[]{new BeanRegisterBean(), new BeanRegisterCrud(), new BeanRegisterService(), new BeanRegisterDao()};
    protected static final TypeBeanRegister[] typeBeanRegisters = new TypeBeanRegister[]{new ControllerBeanRegister(), new CrudBeanRegister(), new ServiceBeanRegister(), new DAOBeanRegister()};
    protected Properties properties = new Properties();
    protected Properties hibernateProperties = new Properties();
    protected ReportGenerator reportGenerator;
    protected RTFGenerator rtfGenerator;
    protected AuthorizationManager authorizationManager;
    protected UserLocator userLocator;
    protected PermissionLocator permissionLocator;
    protected ControlMappingLocator controlMappingLocator;
    protected AuthorizationDAO authorizationDAO;
    protected BeanDescriptorFactory beanDescriptorFactory;
    protected ValidatorRegistry validatorRegistry;
    protected AuthenticationConfig authenticationConfig;
    protected String requiredRenderType = "asterisk";
    protected int maxUploadSize = 10000000;

    public int getMaxUploadSize() {
        return this.maxUploadSize;
    }

    public void setMaxUploadSize(int maxUploadSize) {
        this.maxUploadSize = maxUploadSize;
    }

    public ValidatorRegistry getValidatorRegistry() {
        return this.validatorRegistry;
    }

    public void init() {
        if (this.authorizationDAO == null) {
            this.authorizationDAO = new AuthorizationDAOImpl();
        }
        if (this.controlMappingLocator == null) {
            this.controlMappingLocator = new ControlMappingLocatorImpl();
        }
        if (this.permissionLocator == null) {
            this.permissionLocator = new PermissionLocatorImpl();
            ((PermissionLocatorImpl)this.permissionLocator).setAuthorizationDAO(this.authorizationDAO);
        }
        if (this.userLocator == null) {
            this.userLocator = new UserLocatorImpl();
            ((UserLocatorImpl)this.userLocator).setAuthorizationDAO(this.authorizationDAO);
        }
        if (this.authorizationManager == null) {
            this.authorizationManager = new AuthorizationManagerImpl();
            ((AuthorizationManagerImpl)this.authorizationManager).setControlMappingLocator(this.controlMappingLocator);
            ((AuthorizationManagerImpl)this.authorizationManager).setPermissionLocator(this.permissionLocator);
            ((AuthorizationManagerImpl)this.authorizationManager).setUserLocator(this.userLocator);
        }
        if (this.beanDescriptorFactory == null) {
            this.beanDescriptorFactory = new BeanDescriptorFactoryImpl();
        }
        if (this.validatorRegistry == null) {
            this.validatorRegistry = new ValidatorRegistryImpl();
        }
    }

    public AuthorizationDAO getAuthorizationDAO() {
        return this.authorizationDAO;
    }

    public void setAuthorizationDAO(AuthorizationDAO authorizationDAO) {
        this.authorizationDAO = authorizationDAO;
    }

    public AuthorizationManager getAuthorizationManager() {
        return this.authorizationManager;
    }

    public void setAuthorizationManager(AuthorizationManager authorizationManager) {
        this.authorizationManager = authorizationManager;
    }

    public ReportGenerator getReportGenerator() {
        if (this.reportGenerator == null) {
            try {
                WebApplicationContext applicationContext = (WebApplicationContext)Neo.getApplicationContext();
                ReportNameResolverImpl nameResolverImpl = new ReportNameResolverImpl("/WEB-INF/relatorio/", ".jasper", applicationContext.getServletContext());
                ReportTranslatorImpl translatorImpl = new ReportTranslatorImpl(nameResolverImpl);
                ReportGeneratorImpl generatorImpl = new ReportGeneratorImpl(translatorImpl);
                this.reportGenerator = generatorImpl;
            }
            catch (ClassCastException e) {
                throw new ReportException("A gera\u00e7\u00e3o de relat\u00f3rios s\u00f3 pode ser feita em um contexto WEB");
            }
        }
        return this.reportGenerator;
    }

    public RTFGenerator getRTFGenerator() {
        if (this.rtfGenerator == null) {
            try {
                WebApplicationContext applicationContext = (WebApplicationContext)Neo.getApplicationContext();
                RTFNameResolverImpl nameResolverImpl = new RTFNameResolverImpl("/WEB-INF/rtf/", ".rtf", applicationContext.getServletContext());
                this.rtfGenerator = new RTFGeneratorImpl(nameResolverImpl);
            }
            catch (ClassCastException e) {
                throw new ReportException("A gera\u00e7\u00e3o de RTFs s\u00f3 pode ser feita em um contexto WEB");
            }
        }
        return this.rtfGenerator;
    }

    public void setReportGenerator(ReportGenerator reportGenerator) {
        this.reportGenerator = reportGenerator;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Properties getHibernateProperties() {
        return this.hibernateProperties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public AnnotatedBeanRegister[] getBeanRegisters() {
        return beanRegisters;
    }

    public ControlMappingLocator getControlMappingLocator() {
        return this.controlMappingLocator;
    }

    public PermissionLocator getPermissionLocator() {
        return this.permissionLocator;
    }

    public UserLocator getUserLocator() {
        return this.userLocator;
    }

    public void setControlMappingLocator(ControlMappingLocator controlMappingLocator) {
        this.controlMappingLocator = controlMappingLocator;
    }

    public void setPermissionLocator(PermissionLocator permissionLocator) {
        this.permissionLocator = permissionLocator;
    }

    public void setUserLocator(UserLocator userLocator) {
        this.userLocator = userLocator;
    }

    public BeanDescriptorFactory getBeanDescriptorFactory() {
        return this.beanDescriptorFactory;
    }

    public DefaultListableBeanFactory getDefaultListableBeanFactory() {
        return this.defaultListableBeanFactory;
    }

    public void setDefaultListableBeanFactory(DefaultListableBeanFactory defaultListableBeanFactory) {
        this.defaultListableBeanFactory = defaultListableBeanFactory;
    }

    public TypeBeanRegister[] getTypeBeanRegisters() {
        return typeBeanRegisters;
    }

    public void setRequiredRenderType(String requiredRenderType) {
        this.requiredRenderType = requiredRenderType;
    }

    public String getRequiredRenderType() {
        return "asterisk";
    }

    public AuthenticationConfig getAuthenticationConfig() {
        return this.authenticationConfig;
    }

    public void setAuthenticationConfig(AuthenticationConfig authenticationConfig) {
        this.authenticationConfig = authenticationConfig;
    }

    public void setHibernateProperties(Properties hibernateProperties) {
        this.hibernateProperties = hibernateProperties;
    }
}

