/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.controller.resource;

import br.com.linkcom.neo.controller.resource.Resource;
import br.com.linkcom.neo.controller.resource.ResourceGenerationException;
import br.com.linkcom.neo.controller.resource.ResourceSenderController;
import br.com.linkcom.neo.core.standard.Neo;
import br.com.linkcom.neo.core.web.WebRequestContext;
import br.com.linkcom.neo.exception.NeoException;
import br.com.linkcom.neo.rtf.RTF;
import br.com.linkcom.neo.rtf.RTFGenerator;
import br.com.linkcom.neo.util.Util;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.servlet.ModelAndView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RTFController<FILTRO>
extends ResourceSenderController<FILTRO> {
    protected String name;
    protected Class<FILTRO> filtroClass;

    public void setName(String name) {
        this.name = name;
    }

    public RTFController() {
        Class clazz;
        Class[] genericTypes = Util.generics.getGenericTypes(((Object)((Object)this)).getClass());
        if (genericTypes.length < 1) {
            boolean invalido = false;
            try {
                genericTypes = Util.generics.getGenericTypes2(((Object)((Object)this)).getClass());
                if (genericTypes.length != 1) {
                    invalido = true;
                }
            }
            catch (Exception e) {
                genericTypes = new Class[]{Object.class};
            }
            if (invalido) {
                throw new RuntimeException("A classe " + ((Object)((Object)this)).getClass().getName() + " deve declarar um tipo gen\u00e9rico que indique o command que ser\u00e1 usado");
            }
        }
        this.filtroClass = clazz = genericTypes[0];
    }

    @Override
    public Resource generateResource(WebRequestContext request, FILTRO filtro) throws Exception {
        RTF rtf = this.createRTF(request, filtro);
        RTFGenerator generator = Neo.getApplicationContext().getRTFGenerator();
        byte[] generate = generator.generate(rtf);
        Resource resource = new Resource("application/rtf", this.getRTFName(rtf), generate);
        return resource;
    }

    private String getRTFName(RTF rtf) {
        String name = rtf.getFileName();
        if (name == null && (name = rtf.getName()).indexOf(47) != -1) {
            name = name.substring(rtf.getName().lastIndexOf(47) + 1);
        }
        if (!name.endsWith(".rtf")) {
            name = String.valueOf(name) + ".rtf";
        }
        return name;
    }

    @Override
    public ModelAndView doFiltro(WebRequestContext request, FILTRO filtro) throws Exception {
        try {
            request.setAttribute("filtro", filtro);
            this.filtro(request, filtro);
        }
        catch (Exception e) {
            throw new ResourceGenerationException("filtro", e);
        }
        return this.getFiltroModelAndView(request, filtro);
    }

    protected void filtro(WebRequestContext request, FILTRO filtro) {
    }

    protected ModelAndView getFiltroModelAndView(WebRequestContext request, FILTRO filtro) {
        if (this.name == null) {
            if (!((Object)((Object)this)).getClass().getSimpleName().endsWith("RTF")) {
                throw new NeoException("Um controller de rtf deve ter o sufixo RTF ou ent\u00e3o setar a vari\u00e1vel name");
            }
            String className = StringUtils.uncapitalize((String)((Object)((Object)this)).getClass().getSimpleName());
            this.name = className.substring(0, className.length() - "RTF".length());
        }
        return new ModelAndView("rtf/" + this.name, "filtro", filtro);
    }

    public abstract RTF createRTF(WebRequestContext var1, FILTRO var2) throws Exception;
}

