/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.controller.crud;

import br.com.linkcom.neo.controller.Action;
import br.com.linkcom.neo.controller.Command;
import br.com.linkcom.neo.controller.DefaultAction;
import br.com.linkcom.neo.controller.Input;
import br.com.linkcom.neo.controller.MultiActionController;
import br.com.linkcom.neo.controller.OnErrors;
import br.com.linkcom.neo.controller.crud.CrudException;
import br.com.linkcom.neo.controller.crud.FiltroListagem;
import br.com.linkcom.neo.core.standard.Neo;
import br.com.linkcom.neo.core.web.WebRequestContext;
import br.com.linkcom.neo.exception.NeoException;
import br.com.linkcom.neo.persistence.ListagemResult;
import br.com.linkcom.neo.service.GenericService;
import br.com.linkcom.neo.util.Util;
import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCrudController<FORMBEAN, BEAN>
extends MultiActionController {
    public static final String LISTAGEM = "listagem";
    public static final String ENTRADA = "entrada";
    public static final String CRIAR = "criar";
    public static final String EDITAR = "editar";
    public static final String CONSULTAR = "consultar";
    public static final String SALVAR = "salvar";
    public static final String EXCLUIR = "excluir";
    protected Class<BEAN> beanClass;
    protected Class<FORMBEAN> formClass;
    protected GenericService<BEAN> genericService;

    public GenericService<BEAN> getGenericService() {
        return this.genericService;
    }

    public void setGenericService(GenericService<BEAN> genericService) {
        this.genericService = genericService;
    }

    public void setBeanClass(Class<BEAN> beanClass) {
        this.beanClass = beanClass;
    }

    public void setFormClass(Class<FORMBEAN> formClass) {
        this.formClass = formClass;
    }

    public SimpleCrudController() {
        Class[] classes = Util.generics.getGenericTypes(((Object)((Object)this)).getClass());
        if (classes.length != 2) {
            classes = Util.generics.getGenericTypes2(((Object)((Object)this)).getClass());
            if (classes.length == 2) {
                this.setFormClass(classes[0]);
                this.setBeanClass(classes[1]);
                return;
            }
            throw new RuntimeException("A classe " + ((Object)((Object)this)).getClass().getName() + " deve declarar tres tipos gen\u00e9ricos LISTAGEM, FORMBEAN, BEAN");
        }
        this.setFormClass(classes[0]);
        this.setBeanClass(classes[1]);
    }

    @Action(value="listagem")
    @Command(validate=true)
    @Input(value="listagem")
    @DefaultAction
    public ModelAndView handleRequest(WebRequestContext request, FORMBEAN bean) throws CrudException {
        this.setInfosTemplate(request, bean);
        this.setAuthotizationMethod(request, true);
        return this.getModelAndView(request, bean);
    }

    @Action(value="editar")
    @Command(validate=true)
    @Input(value="listagem")
    @OnErrors(value="listagem")
    public ModelAndView doEditar(WebRequestContext request, FORMBEAN form) throws CrudException {
        try {
            BEAN bean = this.formToBean(form);
            bean = this.carregar(request, bean);
            form = this.beanToForm(bean);
        }
        catch (Exception e) {
            throw new CrudException(EDITAR, e);
        }
        this.setAuthotizationMethod(request, false);
        this.setInfosTemplate(request, form);
        return this.getModelAndView(request, form);
    }

    @Action(value="consultar")
    @Command(validate=true)
    @Input(value="listagem")
    @OnErrors(value="listagem")
    public ModelAndView doConsultar(WebRequestContext request, FORMBEAN form) throws CrudException {
        request.setAttribute(CONSULTAR, true);
        return this.doEditar(request, form);
    }

    @Action(value="excluir")
    @Command(validate=true)
    @Input(value="listagem")
    @OnErrors(value="listagem")
    public ModelAndView doExcluir(WebRequestContext request, FORMBEAN form) throws CrudException {
        BEAN bean = null;
        try {
            bean = this.formToBean(form);
            this.excluir(request, bean);
        }
        catch (Exception e) {
            throw new CrudException(EXCLUIR, e);
        }
        return this.sendRedirect(request);
    }

    @Action(value="salvar")
    @Command(validate=true)
    @Input(value="listagem")
    @OnErrors(value="listagem")
    public ModelAndView doSalvar(WebRequestContext request, FORMBEAN form) throws CrudException {
        BEAN bean = null;
        try {
            bean = this.formToBean(form);
            this.salvar(request, bean);
        }
        catch (Exception e) {
            throw new CrudException(SALVAR, e);
        }
        return this.sendRedirect(request);
    }

    protected void setEntradaDefaultInfo(WebRequestContext request, FORMBEAN form) throws CrudException {
        request.setAttribute(this.getBeanName(), form);
    }

    protected void setInfoForTemplate(WebRequestContext request, FORMBEAN form) {
        request.setAttribute("TEMPLATE_beanNameUncaptalized", this.getBeanName());
        request.setAttribute("TEMPLATE_beanName", this.getBeanName());
        request.setAttribute("TEMPLATE_enviar", SALVAR);
        request.setAttribute("TEMPLATE_voltar", LISTAGEM);
        request.setAttribute("TEMPLATE_beanDisplayName", Neo.getApplicationContext().getBeanDescriptor(null, this.beanClass).getDisplayName());
        request.setAttribute("TEMPLATE_beanClass", this.beanClass);
    }

    protected void setInfosTemplate(WebRequestContext request, FORMBEAN bean) throws CrudException {
        this.setListagemInfo(request);
        this.setInfoForTemplate(request, bean);
        this.setEntradaDefaultInfo(request, bean);
        request.setAttribute("TEMPLATE_listagem", "true");
    }

    protected void setListagemInfo(WebRequestContext request) throws CrudException {
        String attribute = request.getParameter("currentPage");
        Integer currentPage = 0;
        if (attribute != null) {
            currentPage = Integer.parseInt(attribute);
        }
        FiltroListagem filtroListagem = new FiltroListagem();
        filtroListagem.pageSize = 10;
        filtroListagem.setCurrentPage(currentPage);
        ListagemResult<BEAN> listagemResult = this.getLista(request, filtroListagem);
        request.setAttribute("lista", listagemResult.list());
        request.setAttribute("currentPage", filtroListagem.getCurrentPage());
        request.setAttribute("numberOfPages", filtroListagem.getNumberOfPages());
    }

    protected ListagemResult<BEAN> getLista(WebRequestContext request, FiltroListagem filtro) {
        return this.genericService.findForListagem(filtro);
    }

    protected void excluir(WebRequestContext request, BEAN bean) throws Exception {
        this.genericService.delete(bean);
    }

    protected BEAN carregar(WebRequestContext request, BEAN bean) throws Exception {
        return this.genericService.loadForEntrada(bean);
    }

    protected void salvar(WebRequestContext request, BEAN bean) throws Exception {
        this.genericService.saveOrUpdate(bean);
    }

    public FORMBEAN beanToForm(BEAN bean) {
        if (this.formClass.equals(this.beanClass)) {
            return (FORMBEAN)bean;
        }
        throw new NeoException("N\u00e3o foi poss\u00edvel converter de bean para form. Sobrescrever o m\u00e9todo beanToForm");
    }

    public BEAN formToBean(FORMBEAN form) {
        if (this.beanClass.equals(this.formClass)) {
            return (BEAN)form;
        }
        throw new NeoException("N\u00e3o foi poss\u00edvel converter de form para bean. Sobrescrever o m\u00e9todo formToBean");
    }

    protected ModelAndView sendRedirect(WebRequestContext request) {
        return this.sendRedirectToAction(LISTAGEM);
    }

    protected ModelAndView getModelAndView(WebRequestContext request, FORMBEAN bean) {
        return new ModelAndView("crud/" + this.getBeanName());
    }

    public String getBeanName() {
        return Util.strings.uncaptalize(this.beanClass.getSimpleName());
    }

    public void setAuthotizationMethod(WebRequestContext context, Boolean type) {
        if (type.booleanValue()) {
            context.setAttribute("TEMPLATE_authorization", CRIAR);
        } else {
            context.setAttribute("TEMPLATE_authorization", EDITAR);
        }
    }

    protected void validateBean(FORMBEAN bean, BindException errors) {
    }
}

