/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.controller;

import br.com.linkcom.neo.controller.Action;
import br.com.linkcom.neo.controller.DefaultAction;
import br.com.linkcom.neo.controller.MultiActionController;
import br.com.linkcom.neo.core.web.WebRequestContext;
import br.com.linkcom.neo.util.Util;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.multiaction.NoSuchRequestHandlingMethodException;

public class MethodNameResolverImpl {
    private Class clazz;
    private Map<String, Method> mapAction = new HashMap<String, Method>();

    public MethodNameResolverImpl(Object delegate) {
        this.clazz = delegate.getClass();
    }

    public Method getHandlerMethod(HttpServletRequest request) throws NoSuchRequestHandlingMethodException {
        String actionParameter = request.getParameter("ACAO");
        return this.getHandlerMethod(actionParameter);
    }

    public Method getHandlerMethod(String action) throws NoSuchRequestHandlingMethodException {
        Method method = null;
        method = this.mapAction.get(action);
        if (method != null) {
            return method;
        }
        Class[] hierarquia = this.getHierarquia();
        if (Util.strings.isEmpty(action)) {
            method = this.findDefaultAction(hierarquia);
        }
        if (method == null) {
            method = this.findAction(hierarquia, action);
        }
        if (method == null) {
            method = this.findMethodName(hierarquia, action);
        }
        if (method != null) {
            this.mapAction.put(action, method);
            return method;
        }
        throw new NoSuchRequestHandlingMethodException("(a\u00e7\u00e3o " + action + ")", this.clazz);
    }

    private Method findMethodName(Class[] hierarquia, String action) {
        Class[] classArray = hierarquia;
        int n = hierarquia.length;
        int n2 = 0;
        while (n2 < n) {
            Method[] methods;
            Class class1 = classArray[n2];
            Method[] methodArray = methods = class1.getMethods();
            int n3 = methods.length;
            int n4 = 0;
            while (n4 < n3) {
                Class<?>[] params;
                Method method = methodArray[n4];
                if ((method.getReturnType().equals(ModelAndView.class) || method.getReturnType().equals(Void.TYPE)) && (params = method.getParameterTypes()).length >= 1 && params[0].equals(WebRequestContext.class) && method.getName().equals(action)) {
                    return method;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    private Method findAction(Class[] hierarquia, String action) {
        Class[] classArray = hierarquia;
        int n = hierarquia.length;
        int n2 = 0;
        while (n2 < n) {
            Method[] methods;
            Class class1 = classArray[n2];
            Method[] methodArray = methods = class1.getMethods();
            int n3 = methods.length;
            int n4 = 0;
            while (n4 < n3) {
                String value;
                Action annotation;
                Class<?>[] params;
                Method method = methodArray[n4];
                if ((method.getReturnType().equals(ModelAndView.class) || method.getReturnType().equals(Void.TYPE)) && (params = method.getParameterTypes()).length >= 1 && params[0].equals(WebRequestContext.class) && (annotation = method.getAnnotation(Action.class)) != null && (value = annotation.value()).equals(action)) {
                    return method;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    private Method findDefaultAction(Class[] hierarquia) {
        Method result = null;
        Class[] classArray = hierarquia;
        int n = hierarquia.length;
        int n2 = 0;
        while (n2 < n) {
            Method[] methods;
            Class class1 = classArray[n2];
            Method[] methodArray = methods = class1.getMethods();
            int n3 = methods.length;
            int n4 = 0;
            while (n4 < n3) {
                Class<?>[] params;
                Method method = methodArray[n4];
                if ((method.getReturnType().equals(ModelAndView.class) || method.getReturnType().equals(Void.TYPE)) && (params = method.getParameterTypes()).length >= 1 && params[0].equals(WebRequestContext.class) && method.getAnnotation(DefaultAction.class) != null) {
                    result = method;
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    private Class[] getHierarquia() {
        ArrayList hierarquia = new ArrayList();
        Class clazz = this.clazz;
        while (!MultiActionController.class.equals((Object)clazz)) {
            hierarquia.add(0, clazz);
            clazz = clazz.getSuperclass();
        }
        return hierarquia.toArray(new Class[hierarquia.size()]);
    }
}

