/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.controller;

import br.com.linkcom.neo.authorization.AuthorizationModule;
import br.com.linkcom.neo.controller.Controller;
import br.com.linkcom.neo.core.web.NeoWeb;
import br.com.linkcom.neo.core.web.WebApplicationContext;
import br.com.linkcom.neo.util.ReflectionCache;
import br.com.linkcom.neo.util.ReflectionCacheFactory;
import br.com.linkcom.neo.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;

public class AnnotationsHandlerMapping
extends AbstractUrlHandlerMapping {
    private static final Log log = LogFactory.getLog(AnnotationsHandlerMapping.class);
    protected String[] annotatedBeans = new String[0];
    protected String module = null;
    protected boolean registerWithFullUrl = false;

    public boolean isRegisterWithFullUrl() {
        return this.registerWithFullUrl;
    }

    public void setRegisterWithFullUrl(boolean registerWithFullUrl) {
        this.registerWithFullUrl = registerWithFullUrl;
    }

    public String[] getAnnotatedBeans() {
        return this.annotatedBeans;
    }

    public void setAnnotatedBeans(String[] annotatedBeans) {
        this.annotatedBeans = annotatedBeans;
    }

    public void initApplicationContext() throws BeansException {
        WebApplicationContext applicationContext = NeoWeb.getWebApplicationContext(this.getServletContext());
        Class<?>[] classesWithAnnotation = applicationContext.getClassManager().getClassesWithAnnotation(Controller.class);
        ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
        log.info((Object)("Inicializando configura\u00e7\u00e3o dos Controllers para o modulo: " + this.getModule()));
        Class<?>[] classArray = classesWithAnnotation;
        int n = classesWithAnnotation.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            Controller controller = reflectionCache.getAnnotation(clazz, Controller.class);
            String beanName = Util.beans.getName(clazz, applicationContext.getConfig().getBeanRegisters());
            if (beanName == null) {
                beanName = Util.strings.uncaptalize(clazz.getSimpleName());
            }
            String[] paths = controller.path();
            int i = 0;
            while (i < paths.length) {
                String path = paths[i];
                if (!path.startsWith("/")) {
                    path = String.valueOf('/') + path;
                }
                if (path.startsWith(this.getModule())) {
                    Class<? extends AuthorizationModule> authorizationModuleClass = controller.authorizationModule();
                    log.debug((Object)("Registrando " + path + " (" + clazz.getName() + ")"));
                    applicationContext.getConfig().getControlMappingLocator().registerMapping(path, authorizationModuleClass);
                    if (!this.registerWithFullUrl) {
                        path = path.substring(path.substring(1).indexOf(47) + 1);
                    }
                    this.registerHandler(path, beanName);
                }
                ++i;
            }
            ++n2;
        }
    }

    public String getModule() {
        if (this.module == null) {
            throw new RuntimeException("A propriedade module da classe " + AnnotationsHandlerMapping.class.getName() + " n\u00e3o foi configurada. " + "Essa propriedade \u00e9 o path do m\u00f3dulo come\u00e7ando com '/'. ex.: /moduloAcademico");
        }
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }
}

