/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.classmanager;

import br.com.linkcom.neo.classmanager.ClassLocator;
import br.com.linkcom.neo.classmanager.ClassManager;
import br.com.linkcom.neo.classmanager.ClassManagerImpl;
import java.io.File;
import java.io.IOException;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebClassRegister {
    private static final String CLASS_MANAGER_ATTRIBUTE = ClassManager.class.getName();
    private static Log log = LogFactory.getLog(WebClassRegister.class);

    private WebClassRegister() {
    }

    public static ClassManager getClassManager(ServletContext context, String ignorePackage) throws IOException {
        ClassManager classManager = (ClassManager)context.getAttribute(CLASS_MANAGER_ATTRIBUTE);
        if (classManager == null) {
            String[] classesInPackage;
            long x = System.currentTimeMillis();
            classManager = new ClassManagerImpl();
            String path = context.getRealPath(String.valueOf(File.separator) + "WEB-INF" + File.separator + "classes");
            String[] stringArray = classesInPackage = ClassLocator.getClassesNameInPackage(path, File.separator);
            int n = classesInPackage.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                try {
                    if (!name.startsWith(ignorePackage)) {
                        classManager.registerClass(Class.forName(name));
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                ++n2;
            }
            context.setAttribute(CLASS_MANAGER_ATTRIBUTE, (Object)classManager);
            x = System.currentTimeMillis() - x;
            log.debug((Object)("Classes registradas em " + x + " milisegundos"));
        }
        return classManager;
    }
}

