/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.classmanager;

import br.com.linkcom.neo.classmanager.ClassManager;
import br.com.linkcom.neo.classmanager.ClassManagerImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassRegister {
    private static Log log = LogFactory.getLog(ClassRegister.class);
    private static ClassManager classManager;

    private ClassRegister() {
    }

    public static ClassManager getClassManager() throws IOException {
        if (classManager == null) {
            long x = System.currentTimeMillis();
            classManager = new ClassManagerImpl();
            String basePath = ClassLoader.getSystemResource("").toExternalForm();
            if ((basePath = basePath.substring(basePath.indexOf(47))).startsWith("/C:")) {
                basePath = basePath.substring(1);
            }
            File file = new File(basePath);
            ArrayList<String> classNames = new ArrayList<String>();
            ClassRegister.findClassesFiles(file.listFiles(), classNames, basePath);
            for (String name : classNames) {
                try {
                    classManager.registerClass(Class.forName(name));
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            x = System.currentTimeMillis() - x;
            log.debug((Object)("Classes registradas em " + x + " milisegundos"));
        }
        return classManager;
    }

    private static void findClassesFiles(File[] dir, List<String> classes, String basePath) throws IOException {
        File[] fileArray = dir;
        int n = dir.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                String path = file.getPath();
                if (path.endsWith(".class")) {
                    basePath = basePath.replace("/", File.separator);
                    String classFileName = path.replace(basePath, "");
                    String className = classFileName.substring(0, classFileName.length() - ".class".length());
                    className = className.replace(File.separatorChar, '.');
                    classes.add(className);
                }
            } else if (file.isDirectory() && !file.getAbsolutePath().contains("linkcom" + File.separator + "neo")) {
                ClassRegister.findClassesFiles(file.listFiles(), classes, basePath);
            }
            ++n2;
        }
    }
}

