/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.classmanager;

import br.com.linkcom.neo.classmanager.ClassManager;
import br.com.linkcom.neo.util.ReflectionCache;
import br.com.linkcom.neo.util.ReflectionCacheFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassManagerImpl
implements ClassManager {
    private Map<Object, List<Class<?>>> families = new HashMap();
    private List<Class<?>> classes = new ArrayList();
    private Map<Class<?>, List<Class<?>>> classesOfType = new HashMap();
    private Map<Class<?>, List<Class<?>>> classesOfFamily = new HashMap();
    private Map<Class<?>, List<Class<?>>> classesWithAnnotation = new HashMap();
    private Map<String, List<Class<?>>> classesFromPackage = new HashMap();

    private void fillList(List<Class<?>> list, Class<?> type) {
        ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
        for (Class<?> clazz : this.classes) {
            if (type.isAssignableFrom(clazz) && !list.contains(clazz)) {
                list.add(clazz);
                continue;
            }
            if (!type.isAnnotation() || !reflectionCache.isAnnotationPresent(clazz, type) || list.contains(clazz)) continue;
            list.add(clazz);
        }
    }

    @Override
    public Class<?>[] getAllClassesOfType(Class<?> type) {
        List<Class<?>> list = this.classesOfType.get(type);
        if (list == null) {
            list = new ArrayList();
            this.fillList(list, type);
        }
        return list.toArray(new Class[list.size()]);
    }

    public Class<?>[] getClassesOfFamily(String family) {
        System.out.println("Get classes of family");
        long x = System.currentTimeMillis();
        List<Class<?>> list = this.classesOfFamily.get(family);
        if (list == null) {
            list = new ArrayList();
            List<Class<?>> familyClasses = this.families.get(family);
            for (Class<?> familyClass : familyClasses) {
                this.fillList(list, familyClass);
            }
        }
        System.out.println(System.currentTimeMillis() - x);
        return list.toArray(new Class[list.size()]);
    }

    @Override
    public Class<?>[] getClassesWithAnnotation(Class<?> annotationType) {
        List<Class<?>> list = this.classesWithAnnotation.get(annotationType);
        if (list == null) {
            list = new ArrayList();
            this.fillList(list, annotationType);
        }
        return list.toArray(new Class[list.size()]);
    }

    @Override
    public void registerClass(Class<?> clazz) {
        if (clazz.isAnnotation()) {
            return;
        }
        this.classes.add(clazz);
    }

    public void registerFamily(Object family, Class<?> ... classes) {
        List<Class<?>> list = this.families.get(family);
        if (list == null) {
            list = new ArrayList();
            this.families.put(family, list);
        }
        Collections.addAll(list, classes);
    }

    @Override
    public Class<?>[] getAllClassesFromPackage(String pacote) {
        List<Class<?>> list = this.classesFromPackage.get(pacote);
        if (list == null) {
            list = new ArrayList();
            for (Class<?> clazz : this.classes) {
                if (!this.isInPackage(clazz, pacote)) continue;
                list.add(clazz);
            }
        }
        return list.toArray(new Class[list.size()]);
    }

    private boolean isInPackage(Class<?> clazz, String pacote) {
        return clazz.getName().startsWith(pacote);
    }

    @Override
    public Class<?>[] getAllClasses() {
        return this.classes.toArray(new Class[this.classes.size()]);
    }
}

