/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.bean.editors;

import java.beans.PropertyEditorSupport;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.springframework.util.StringUtils;

public class TimestampPropertyEditor
extends PropertyEditorSupport {
    private final DateFormat dateFormat;
    private final boolean allowEmpty;

    public TimestampPropertyEditor(DateFormat dateFormat, boolean allowEmpty) {
        this.dateFormat = dateFormat;
        this.allowEmpty = allowEmpty;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (this.allowEmpty && !StringUtils.hasText((String)text)) {
            this.setValue(null);
        } else {
            try {
                this.setValue(new Timestamp(this.dateFormat.parse(text).getTime()));
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("Could not parse timestamp: " + ex.getMessage());
            }
        }
    }

    public Object getValue() {
        Object object = super.getValue();
        if (object instanceof Date) {
            Timestamp timestamp = new Timestamp(((Date)object).getTime());
            return timestamp;
        }
        return object;
    }

    public String getAsText() {
        return this.getValue() == null ? "" : this.dateFormat.format((Timestamp)this.getValue());
    }
}

