/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.bean;

import br.com.linkcom.neo.bean.CachedIntrospectionResults;
import br.com.linkcom.neo.bean.IndexValueResolver;
import br.com.linkcom.neo.bean.PropertyInfo;
import br.com.linkcom.neo.core.standard.Neo;
import br.com.linkcom.neo.exception.NeoException;
import br.com.linkcom.neo.exception.NotParameterizedTypeException;
import br.com.linkcom.neo.persistence.QueryBuilder;
import br.com.linkcom.neo.util.ReflectionCache;
import br.com.linkcom.neo.util.ReflectionCacheFactory;
import br.com.linkcom.neo.util.Util;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import javax.persistence.Id;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.LazyInitializationException;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.MethodInvocationException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.NullValueInNestedPathException;
import org.springframework.beans.PropertyAccessException;
import org.springframework.beans.PropertyAccessExceptionsException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.propertyeditors.ByteArrayPropertyEditor;
import org.springframework.beans.propertyeditors.CharacterEditor;
import org.springframework.beans.propertyeditors.ClassEditor;
import org.springframework.beans.propertyeditors.CustomBooleanEditor;
import org.springframework.beans.propertyeditors.CustomCollectionEditor;
import org.springframework.beans.propertyeditors.CustomNumberEditor;
import org.springframework.beans.propertyeditors.FileEditor;
import org.springframework.beans.propertyeditors.InputStreamEditor;
import org.springframework.beans.propertyeditors.LocaleEditor;
import org.springframework.beans.propertyeditors.PropertiesEditor;
import org.springframework.beans.propertyeditors.StringArrayPropertyEditor;
import org.springframework.beans.propertyeditors.URLEditor;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourceArrayPropertyEditor;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.util.StringUtils;

public class PropertyDescriptorBeanWrapper {
    static final String NESTED_PROPERTY_SEPARATOR = ".";
    static final char NESTED_PROPERTY_SEPARATOR_CHAR = '.';
    static final String PROPERTY_KEY_PREFIX = "[";
    static final char PROPERTY_KEY_PREFIX_CHAR = '[';
    static final String PROPERTY_KEY_SUFFIX = "]";
    static final char PROPERTY_KEY_SUFFIX_CHAR = ']';
    private static final Log logger = LogFactory.getLog(PropertyDescriptorBeanWrapper.class);
    private PropertyInfo propertyInfo;
    private String nestedPath = "";
    private PropertyInfo rootObject;
    private boolean extractOldValueForEditor = false;
    private final Map defaultEditors;
    private Map customEditors;
    private IndexValueResolver indexValueResolver;
    private CachedIntrospectionResults cachedIntrospectionResults;
    private Map nestedBeanWrappers;

    public PropertyDescriptorBeanWrapper() {
        this(true);
    }

    public PropertyDescriptorBeanWrapper(boolean registerDefaultEditors) {
        if (registerDefaultEditors) {
            this.defaultEditors = new HashMap(32);
            this.registerDefaultEditors();
        } else {
            this.defaultEditors = Collections.EMPTY_MAP;
        }
    }

    public PropertyDescriptorBeanWrapper(PropertyInfo object) {
        this();
        this.setWrappedInstance(object);
    }

    public PropertyDescriptorBeanWrapper(Class clazz) {
        this();
        Object instantiateClass = BeanUtils.instantiateClass((Class)clazz);
        PropertyInfo info = new PropertyInfo();
        info.type = clazz;
        info.clazz = clazz;
        info.value = instantiateClass;
        this.setWrappedInstance(info);
    }

    public PropertyDescriptorBeanWrapper(Class clazz, Object wrappedInstance) {
        this();
        if (clazz == null) {
            throw new NullPointerException("Classe nula ao criar propertyDescriptorBeanWrapper");
        }
        PropertyInfo info = new PropertyInfo();
        info.type = clazz;
        info.clazz = clazz;
        info.value = wrappedInstance;
        this.setWrappedInstance(info, "", null);
    }

    public PropertyDescriptorBeanWrapper(PropertyInfo object, String nestedPath, PropertyInfo rootPropertyInfo) {
        this();
        this.setWrappedInstance(object, nestedPath, rootPropertyInfo);
    }

    private PropertyDescriptorBeanWrapper(PropertyInfo object, String nestedPath, PropertyDescriptorBeanWrapper superBw) {
        this.defaultEditors = superBw.defaultEditors;
        this.setWrappedInstance(object, nestedPath, superBw.propertyInfo);
    }

    private void registerDefaultEditors() {
        this.defaultEditors.put(byte[].class, new ByteArrayPropertyEditor());
        this.defaultEditors.put(Class.class, new ClassEditor());
        this.defaultEditors.put(File.class, new FileEditor());
        this.defaultEditors.put(InputStream.class, new InputStreamEditor());
        this.defaultEditors.put(Locale.class, new LocaleEditor());
        this.defaultEditors.put(Properties.class, new PropertiesEditor());
        this.defaultEditors.put(Resource[].class, new ResourceArrayPropertyEditor());
        this.defaultEditors.put(String[].class, new StringArrayPropertyEditor());
        this.defaultEditors.put(URL.class, new URLEditor());
        this.defaultEditors.put(Collection.class, new CustomCollectionEditor(Collection.class));
        this.defaultEditors.put(Set.class, new CustomCollectionEditor(Set.class));
        this.defaultEditors.put(SortedSet.class, new CustomCollectionEditor(SortedSet.class));
        this.defaultEditors.put(List.class, new CustomCollectionEditor(List.class));
        CharacterEditor characterEditor = new CharacterEditor(false);
        CustomBooleanEditor booleanEditor = new CustomBooleanEditor(false);
        this.defaultEditors.put(Character.TYPE, characterEditor);
        this.defaultEditors.put(Character.class, characterEditor);
        this.defaultEditors.put(Boolean.TYPE, booleanEditor);
        this.defaultEditors.put(Boolean.class, booleanEditor);
        CustomNumberEditor byteEditor = new CustomNumberEditor(Byte.class, false);
        CustomNumberEditor shortEditor = new CustomNumberEditor(Short.class, false);
        CustomNumberEditor integerEditor = new CustomNumberEditor(Integer.class, false);
        CustomNumberEditor longEditor = new CustomNumberEditor(Long.class, false);
        CustomNumberEditor floatEditor = new CustomNumberEditor(Float.class, false);
        CustomNumberEditor doubleEditor = new CustomNumberEditor(Double.class, false);
        this.defaultEditors.put(Byte.TYPE, byteEditor);
        this.defaultEditors.put(Byte.class, byteEditor);
        this.defaultEditors.put(Short.TYPE, shortEditor);
        this.defaultEditors.put(Short.class, shortEditor);
        this.defaultEditors.put(Integer.TYPE, integerEditor);
        this.defaultEditors.put(Integer.class, integerEditor);
        this.defaultEditors.put(Long.TYPE, longEditor);
        this.defaultEditors.put(Long.class, longEditor);
        this.defaultEditors.put(Float.TYPE, floatEditor);
        this.defaultEditors.put(Float.class, floatEditor);
        this.defaultEditors.put(Double.TYPE, doubleEditor);
        this.defaultEditors.put(Double.class, doubleEditor);
        this.defaultEditors.put(BigDecimal.class, new CustomNumberEditor(BigDecimal.class, false));
        this.defaultEditors.put(BigInteger.class, new CustomNumberEditor(BigInteger.class, false));
    }

    public void setWrappedInstance(Object object) {
        PropertyInfo info = new PropertyInfo();
        info.value = object;
        if (object == null) {
            throw new NullPointerException("PropertyDescriptorBeanWrapper n\u00e3o pode ser inicializado. Objeto nulo.");
        }
        info.clazz = object.getClass();
        info.type = object.getClass();
        this.setWrappedInstance(info, "", null);
    }

    public void setWrappedInstance(PropertyInfo propertyInfo, String nestedPath, PropertyInfo rootPropertyInfo) {
        if (propertyInfo == null) {
            throw new IllegalArgumentException("Cannot set PropertyDescriptorBeanWrapper target to a null object");
        }
        this.propertyInfo = propertyInfo;
        this.nestedPath = nestedPath != null ? nestedPath : "";
        this.rootObject = !"".equals(this.nestedPath) ? rootPropertyInfo : propertyInfo;
        this.nestedBeanWrappers = null;
        this.setIntrospectionClass(propertyInfo.clazz);
    }

    public Object getWrappedInstance() {
        return this.propertyInfo.value;
    }

    public PropertyInfo getWrappedPropertyInfo() {
        return this.propertyInfo;
    }

    public Class getWrappedClass() {
        return this.propertyInfo.clazz;
    }

    public String getNestedPath() {
        return this.nestedPath;
    }

    public PropertyInfo getRootInstance() {
        return this.rootObject;
    }

    public Class getRootClass() {
        return this.rootObject != null ? this.rootObject.clazz : this.propertyInfo.clazz;
    }

    protected void setIntrospectionClass(Class clazz) {
        if (this.cachedIntrospectionResults == null || !this.cachedIntrospectionResults.getBeanClass().equals(clazz)) {
            this.cachedIntrospectionResults = CachedIntrospectionResults.forClass(clazz);
        }
    }

    public void setExtractOldValueForEditor(boolean extractOldValueForEditor) {
        this.extractOldValueForEditor = extractOldValueForEditor;
    }

    public void registerCustomEditor(Class requiredType, PropertyEditor propertyEditor) {
        this.registerCustomEditor(requiredType, null, propertyEditor);
    }

    public void registerCustomEditor(Class requiredType, String propertyPath, PropertyEditor propertyEditor) {
        if (requiredType == null && propertyPath == null) {
            throw new IllegalArgumentException("Either requiredType or propertyPath is required");
        }
        if (this.customEditors == null) {
            this.customEditors = new HashMap();
        }
        if (propertyPath != null) {
            this.customEditors.put(propertyPath, new CustomEditorHolder(propertyEditor, requiredType));
        } else {
            this.customEditors.put(requiredType, propertyEditor);
        }
    }

    public PropertyEditor findCustomEditor(Class requiredType, String propertyPath) {
        if (this.customEditors == null) {
            return null;
        }
        if (propertyPath != null) {
            PropertyEditor editor = this.getCustomEditor(propertyPath, requiredType);
            if (editor == null) {
                LinkedList strippedPaths = new LinkedList();
                this.addStrippedPropertyPaths(strippedPaths, "", propertyPath);
                Iterator it = strippedPaths.iterator();
                while (it.hasNext() && editor == null) {
                    String strippedPath = (String)it.next();
                    editor = this.getCustomEditor(strippedPath, requiredType);
                }
            }
            if (editor != null) {
                return editor;
            }
            if (requiredType == null) {
                requiredType = this.getPropertyType(propertyPath);
            }
        }
        return this.getCustomEditor(requiredType);
    }

    private PropertyEditor getCustomEditor(String propertyName, Class requiredType) {
        CustomEditorHolder holder = (CustomEditorHolder)this.customEditors.get(propertyName);
        return holder != null ? holder.getPropertyEditor(requiredType) : null;
    }

    private PropertyEditor getCustomEditor(Class requiredType) {
        if (requiredType != null) {
            PropertyEditor editor = (PropertyEditor)this.customEditors.get(requiredType);
            if (editor == null) {
                for (Object key : this.customEditors.keySet()) {
                    if (!(key instanceof Class) || !((Class)key).isAssignableFrom(requiredType)) continue;
                    editor = (PropertyEditor)this.customEditors.get(key);
                }
            }
            return editor;
        }
        return null;
    }

    private void addStrippedPropertyPaths(List strippedPaths, String nestedPath, String propertyPath) {
        int endIndex;
        int startIndex = propertyPath.indexOf(91);
        if (startIndex != -1 && (endIndex = propertyPath.indexOf(93)) != -1) {
            String prefix = propertyPath.substring(0, startIndex);
            String key = propertyPath.substring(startIndex, endIndex + 1);
            String suffix = propertyPath.substring(endIndex + 1, propertyPath.length());
            strippedPaths.add(String.valueOf(nestedPath) + prefix + suffix);
            this.addStrippedPropertyPaths(strippedPaths, String.valueOf(nestedPath) + prefix, suffix);
            this.addStrippedPropertyPaths(strippedPaths, String.valueOf(nestedPath) + prefix + key, suffix);
        }
    }

    private int getNestedPropertySeparatorIndex(String propertyPath, boolean last) {
        boolean inKey = false;
        int i = last ? propertyPath.length() - 1 : 0;
        while (last && i >= 0 || i < propertyPath.length()) {
            switch (propertyPath.charAt(i)) {
                case '[': 
                case ']': {
                    inKey = !inKey;
                    break;
                }
                case '.': {
                    if (inKey) break;
                    return i;
                }
            }
            if (last) {
                --i;
                continue;
            }
            ++i;
        }
        return -1;
    }

    private String getFinalPath(PropertyDescriptorBeanWrapper bw, String nestedPath) {
        if (bw == this) {
            return nestedPath;
        }
        return nestedPath.substring(this.getNestedPropertySeparatorIndex(nestedPath, true) + 1);
    }

    public PropertyDescriptorBeanWrapper getBeanWrapperForPropertyPath(String propertyPath) throws BeansException {
        int pos = this.getNestedPropertySeparatorIndex(propertyPath, false);
        if (pos > -1) {
            String nestedProperty = propertyPath.substring(0, pos);
            String nestedPath = propertyPath.substring(pos + 1);
            PropertyDescriptorBeanWrapper nestedBw = this.getNestedBeanWrapper(nestedProperty);
            return nestedBw.getBeanWrapperForPropertyPath(nestedPath);
        }
        return this;
    }

    protected PropertyDescriptorBeanWrapper getNestedBeanWrapper(String nestedProperty) throws BeansException {
        if (this.nestedBeanWrappers == null) {
            this.nestedBeanWrappers = new HashMap();
        }
        PropertyTokenHolder tokens = this.getPropertyNameTokens(nestedProperty);
        PropertyInfo propertyInfo = this.getPropertyValue(tokens);
        Object propertyValue = propertyInfo.value;
        String canonicalName = tokens.canonicalName;
        String propertyName = tokens.actualName;
        PropertyDescriptorBeanWrapper nestedBw = (PropertyDescriptorBeanWrapper)this.nestedBeanWrappers.get(canonicalName);
        if (nestedBw == null || nestedBw.getWrappedInstance() != propertyValue) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating new nested BeanWrapper for property '" + canonicalName + "'"));
            }
            nestedBw = new PropertyDescriptorBeanWrapper(propertyInfo, String.valueOf(this.nestedPath) + canonicalName + NESTED_PROPERTY_SEPARATOR, this);
            nestedBw.indexValueResolver = this.indexValueResolver;
            if (this.customEditors != null) {
                for (Map.Entry entry : this.customEditors.entrySet()) {
                    String editorPath;
                    int pos;
                    if (entry.getKey() instanceof Class) {
                        Class requiredType = (Class)entry.getKey();
                        PropertyEditor editor = (PropertyEditor)entry.getValue();
                        nestedBw.registerCustomEditor(requiredType, editor);
                        continue;
                    }
                    if (!(entry.getKey() instanceof String) || (pos = this.getNestedPropertySeparatorIndex(editorPath = (String)entry.getKey(), false)) == -1) continue;
                    String editorNestedProperty = editorPath.substring(0, pos);
                    String editorNestedPath = editorPath.substring(pos + 1);
                    if (!editorNestedProperty.equals(canonicalName) && !editorNestedProperty.equals(propertyName)) continue;
                    CustomEditorHolder editorHolder = (CustomEditorHolder)entry.getValue();
                    nestedBw.registerCustomEditor(editorHolder.getRegisteredType(), editorNestedPath, editorHolder.getPropertyEditor());
                }
            }
            this.nestedBeanWrappers.put(canonicalName, nestedBw);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using cached nested BeanWrapper for property '" + canonicalName + "'"));
        }
        return nestedBw;
    }

    private PropertyTokenHolder getPropertyNameTokens(String propertyName) {
        PropertyTokenHolder tokens = new PropertyTokenHolder();
        String actualName = null;
        ArrayList<String> keys = new ArrayList<String>(2);
        int searchIndex = 0;
        while (searchIndex != -1) {
            int keyEnd;
            int keyStart = propertyName.indexOf(PROPERTY_KEY_PREFIX, searchIndex);
            searchIndex = -1;
            if (keyStart == -1 || (keyEnd = propertyName.indexOf(PROPERTY_KEY_SUFFIX, keyStart + PROPERTY_KEY_PREFIX.length())) == -1) continue;
            if (actualName == null) {
                actualName = propertyName.substring(0, keyStart);
            }
            String key = propertyName.substring(keyStart + PROPERTY_KEY_PREFIX.length(), keyEnd);
            keys.add(key);
            searchIndex = keyEnd + PROPERTY_KEY_SUFFIX.length();
        }
        tokens.actualName = actualName != null ? actualName : propertyName;
        tokens.canonicalName = tokens.actualName;
        if (!keys.isEmpty()) {
            PropertyTokenHolder propertyTokenHolder = tokens;
            propertyTokenHolder.canonicalName = String.valueOf(propertyTokenHolder.canonicalName) + PROPERTY_KEY_PREFIX + StringUtils.collectionToDelimitedString(keys, (String)"][") + PROPERTY_KEY_SUFFIX;
            tokens.keys = keys.toArray(new String[keys.size()]);
        }
        return tokens;
    }

    public Object getPropertyValue(String propertyName) {
        return this.getPropertyInfo((String)propertyName).value;
    }

    public PropertyInfo getPropertyInfo(String propertyName) throws BeansException {
        PropertyDescriptorBeanWrapper nestedBw = this.getBeanWrapperForPropertyPath(propertyName);
        PropertyTokenHolder tokens = this.getPropertyNameTokens(this.getFinalPath(nestedBw, propertyName));
        return nestedBw.getPropertyValue(tokens);
    }

    protected PropertyInfo getPropertyValue(PropertyTokenHolder tokens) throws BeansException {
        String propertyName = tokens.canonicalName;
        String actualName = tokens.actualName;
        PropertyDescriptor pd = this.getPropertyDescriptorInternal(tokens.actualName);
        if (pd == null || pd.getReadMethod() == null) {
            throw new NotReadablePropertyException(this.getRootClass(), String.valueOf(this.nestedPath) + propertyName);
        }
        Method readMethod = pd.getReadMethod();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("About to invoke read method [" + readMethod + "] on object of class [" + this.propertyInfo.type + PROPERTY_KEY_SUFFIX));
        }
        try {
            ReflectionCache reflectionCache = ReflectionCacheFactory.getReflectionCache();
            PropertyInfo propertyInfo = new PropertyInfo();
            propertyInfo.lastPropertyGetterName = readMethod.getName();
            propertyInfo.type = readMethod.getGenericReturnType();
            propertyInfo.clazz = readMethod.getReturnType();
            propertyInfo.propertyName = String.valueOf(this.nestedPath) + actualName;
            propertyInfo.errorMessages.addAll(this.propertyInfo.errorMessages);
            propertyInfo.annotations = reflectionCache.getAnnotations(readMethod);
            propertyInfo.ownerType = readMethod.getDeclaringClass();
            if (this.propertyInfo.value != null) {
                LazyInitializer hibernateLazyInitializer;
                Object value = this.propertyInfo.value;
                if (value instanceof HibernateProxy && (hibernateLazyInitializer = ((HibernateProxy)value).getHibernateLazyInitializer()).isUninitialized()) {
                    boolean isId = false;
                    Annotation[] annotationArray = propertyInfo.annotations;
                    int n = propertyInfo.annotations.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Annotation ann = annotationArray[n2];
                        if (Id.class.isAssignableFrom(ann.annotationType())) {
                            isId = true;
                        }
                        ++n2;
                    }
                    if (!isId) {
                        try {
                            Class<?> superclass = value.getClass().getSuperclass();
                            Serializable identifier = hibernateLazyInitializer.getIdentifier();
                            if (identifier != null) {
                                Object newValue = new QueryBuilder(Neo.getObject(HibernateTemplate.class)).from(superclass).idEq(identifier).unique();
                                if (newValue != null) {
                                    value = newValue;
                                    logger.warn((Object)("N\u00e3o foi poss\u00edvel encontrar " + superclass.getSimpleName() + " com identificador " + identifier + " no banco de dados"));
                                }
                                logger.warn((Object)("Carregando objeto da classe " + propertyInfo.clazz.getName() + " sob demanda. propriedade (" + propertyInfo.propertyName + "). Utilize leftOuterJoinFetch para evitar esse problema"));
                                if (Util.config.getDefaultConfigBoolean(false, "showLazyWarnings")) {
                                    throw new NeoException("Propriedade " + propertyInfo.propertyName + " da classe " + propertyInfo.clazz.getName() + " carregado sob demanda.");
                                }
                            }
                        }
                        catch (IllegalArgumentException superclass) {
                        }
                        catch (SecurityException superclass) {
                            // empty catch block
                        }
                    }
                }
                propertyInfo.value = readMethod.invoke(value, new Object[0]);
            } else {
                propertyInfo.value = null;
            }
            if (tokens.keys != null) {
                int i = 0;
                while (i < tokens.keys.length) {
                    Type collectionType;
                    ParameterizedType parameterizedType;
                    Object resolveName;
                    String key = tokens.keys[i];
                    if (propertyInfo.value == null && this.indexValueResolver != null && (resolveName = this.indexValueResolver.resolveName(key, Object.class)) == null) {
                        propertyInfo.addErrorMessage("N\u00e3o foi poss\u00edvel achar nenhum valor para a chave: '" + key + "' properiedade: " + this.nestedPath + propertyName + " (obs.: " + propertyInfo.propertyName + " \u00e9 nulo)");
                    }
                    if (propertyInfo.clazz.isArray()) {
                        Integer index;
                        if (this.indexValueResolver != null) {
                            index = this.indexValueResolver.resolveName(key, Integer.class);
                        } else {
                            logger.warn((Object)"IndexValueResolver n\u00e3o informado");
                            index = Integer.parseInt(key);
                        }
                        if (propertyInfo.value != null) {
                            if (index != null && index < ((Object[])propertyInfo.value).length) {
                                propertyInfo.value = Array.get(propertyInfo.value, index);
                            } else {
                                if (index == null) {
                                    propertyInfo.addErrorMessage("N\u00e3o foi poss\u00edvel achar nenhum valor para a chave: " + key);
                                }
                                propertyInfo.value = null;
                            }
                        }
                        propertyInfo.propertyName = this.resolveIndexedPropertyName(propertyInfo.propertyName, index, key);
                    } else if (List.class.isAssignableFrom(propertyInfo.clazz)) {
                        Integer index;
                        Class rawType;
                        if (!(propertyInfo.type instanceof ParameterizedType)) {
                            throw new NotParameterizedTypeException("Path direciona a um List n\u00e3o parameterizado com generics.  Propriedade '" + this.nestedPath + propertyName + "' da classe [" + this.rootObject.clazz.getName() + PROPERTY_KEY_SUFFIX);
                        }
                        parameterizedType = (ParameterizedType)propertyInfo.type;
                        collectionType = parameterizedType.getActualTypeArguments()[0];
                        propertyInfo.clazz = rawType = collectionType instanceof Class ? (Class)collectionType : (Class)((ParameterizedType)collectionType).getRawType();
                        propertyInfo.type = collectionType;
                        if (this.indexValueResolver != null) {
                            index = this.indexValueResolver.resolveName(key, Integer.class);
                        } else {
                            logger.warn((Object)"IndexValueResolver n\u00e3o informado");
                            index = Integer.parseInt(key);
                        }
                        if (propertyInfo.value != null) {
                            List list = (List)propertyInfo.value;
                            try {
                                propertyInfo.value = list.get(index);
                            }
                            catch (Exception e) {
                                if (index == null) {
                                    propertyInfo.addErrorMessage("N\u00e3o foi poss\u00edvel achar nenhum valor para a chave: '" + key + "' properiedade: " + this.nestedPath + propertyName);
                                }
                                propertyInfo.value = null;
                            }
                        }
                        propertyInfo.propertyName = this.resolveIndexedPropertyName(propertyInfo.propertyName, index, key);
                    } else if (Set.class.isAssignableFrom(propertyInfo.clazz)) {
                        Integer index;
                        Class rawType;
                        if (!(propertyInfo.type instanceof ParameterizedType)) {
                            throw new NotParameterizedTypeException("Path direciona a um Set n\u00e3o parameterizado com generics.  Propriedade '" + this.nestedPath + propertyName + "' da classe [" + this.rootObject.clazz.getName() + PROPERTY_KEY_SUFFIX);
                        }
                        parameterizedType = (ParameterizedType)propertyInfo.type;
                        collectionType = parameterizedType.getActualTypeArguments()[0];
                        propertyInfo.clazz = rawType = collectionType instanceof Class ? (Class)collectionType : (Class)((ParameterizedType)collectionType).getRawType();
                        propertyInfo.type = collectionType;
                        if (this.indexValueResolver != null) {
                            index = this.indexValueResolver.resolveName(key, Integer.class);
                        } else {
                            logger.warn((Object)"IndexValueResolver n\u00e3o informado");
                            index = Integer.parseInt(key);
                        }
                        if (propertyInfo.value != null) {
                            Set set = (Set)propertyInfo.value;
                            if (index != null && index < set.size()) {
                                Iterator it = set.iterator();
                                int j = 0;
                                while (it.hasNext()) {
                                    Object elem = it.next();
                                    if (j == index) {
                                        propertyInfo.value = elem;
                                        break;
                                    }
                                    ++j;
                                }
                            } else {
                                if (index == null) {
                                    propertyInfo.addErrorMessage("N\u00e3o foi poss\u00edvel achar nenhum valor para a chave: '" + key + "' properiedade: " + this.nestedPath + propertyName);
                                }
                                propertyInfo.value = null;
                            }
                        }
                        propertyInfo.propertyName = this.resolveIndexedPropertyName(propertyInfo.propertyName, index, key);
                    } else if (Map.class.isAssignableFrom(propertyInfo.clazz)) {
                        String index;
                        if (!(propertyInfo.type instanceof ParameterizedType)) {
                            throw new NotParameterizedTypeException("Path direciona a um Map n\u00e3o parameterizado com generics.  Propriedade '" + this.nestedPath + propertyName + "' da classe [" + this.rootObject.clazz.getName() + PROPERTY_KEY_SUFFIX);
                        }
                        parameterizedType = (ParameterizedType)propertyInfo.type;
                        Type mapKeyType = parameterizedType.getActualTypeArguments()[0];
                        Type mapValueType = parameterizedType.getActualTypeArguments()[1];
                        Class rawType = mapValueType instanceof Class ? (Class)mapValueType : (Class)((ParameterizedType)mapValueType).getRawType();
                        Class rawKeyType = mapKeyType instanceof Class ? (Class)mapKeyType : (Class)((ParameterizedType)mapKeyType).getRawType();
                        propertyInfo.clazz = rawType;
                        propertyInfo.type = mapValueType;
                        if (this.indexValueResolver != null) {
                            index = this.indexValueResolver.resolveName(key, rawKeyType);
                        } else {
                            logger.warn((Object)"IndexValueResolver n\u00e3o informado");
                            index = key;
                        }
                        if (propertyInfo.value != null) {
                            Map map = (Map)propertyInfo.value;
                            if (index != null) {
                                propertyInfo.value = map.get(index);
                            } else {
                                propertyInfo.addErrorMessage("N\u00e3o foi poss\u00edvel achar nenhum valor para a chave: '" + key + "' properiedade: " + this.nestedPath + propertyName);
                                propertyInfo.value = null;
                            }
                        } else {
                            propertyInfo.value = null;
                        }
                        propertyInfo.propertyName = this.resolveIndexedPropertyName(propertyInfo.propertyName, index, key);
                    } else {
                        throw new InvalidPropertyException(this.getRootClass(), String.valueOf(this.nestedPath) + propertyName, "Property referenced in indexed property path '" + propertyName + "' is neither an array nor a List nor a Set nor a Map; returned value was [" + propertyInfo.value + PROPERTY_KEY_SUFFIX);
                    }
                    ++i;
                }
            }
            return propertyInfo;
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof LazyInitializationException) {
                throw new InvalidPropertyException(this.getRootClass(), String.valueOf(this.nestedPath) + propertyName, "Getter for property '" + actualName + "' threw exception. LazyInitializationException: objeto da classe " + this.propertyInfo.clazz.getName() + " n\u00e3o inicializado", (Throwable)ex);
            }
            throw new InvalidPropertyException(this.getRootClass(), String.valueOf(this.nestedPath) + propertyName, "Getter for property '" + actualName + "' threw exception", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new InvalidPropertyException(this.getRootClass(), String.valueOf(this.nestedPath) + propertyName, "Illegal attempt to get property '" + actualName + "' threw exception", (Throwable)ex);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new InvalidPropertyException(this.getRootClass(), String.valueOf(this.nestedPath) + propertyName, "Index of out of bounds in property path '" + propertyName + "'", (Throwable)ex);
        }
        catch (NumberFormatException ex) {
            throw new InvalidPropertyException(this.getRootClass(), String.valueOf(this.nestedPath) + propertyName, "Invalid index in property path '" + propertyName + "'", (Throwable)ex);
        }
    }

    private String resolveIndexedPropertyName(String propertyName, Object index, String key) {
        Object newKey = index == null ? key : index;
        return String.valueOf(propertyName) + PROPERTY_KEY_PREFIX + newKey + PROPERTY_KEY_SUFFIX;
    }

    public void setPropertyValue(String propertyName, Object value) throws BeansException {
        PropertyDescriptorBeanWrapper nestedBw = null;
        try {
            nestedBw = this.getBeanWrapperForPropertyPath(propertyName);
        }
        catch (NotReadablePropertyException ex) {
            throw new NotWritablePropertyException(this.getRootClass(), String.valueOf(this.nestedPath) + propertyName, "Nested property in path '" + propertyName + "' does not exist", (Throwable)ex);
        }
        PropertyTokenHolder tokens = this.getPropertyNameTokens(this.getFinalPath(nestedBw, propertyName));
        nestedBw.setPropertyValue(tokens, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setPropertyValue(PropertyTokenHolder tokens, Object newValue) throws BeansException {
        String propertyName = tokens.canonicalName;
        if (tokens.keys != null) {
            PropertyTokenHolder getterTokens = new PropertyTokenHolder();
            getterTokens.canonicalName = tokens.canonicalName;
            getterTokens.actualName = tokens.actualName;
            getterTokens.keys = new String[tokens.keys.length - 1];
            System.arraycopy(tokens.keys, 0, getterTokens.keys, 0, tokens.keys.length - 1);
            PropertyInfo propValue = null;
            try {
                propValue = this.getPropertyValue(getterTokens);
            }
            catch (NotReadablePropertyException ex) {
                throw new NotWritablePropertyException(this.getRootClass(), String.valueOf(this.nestedPath) + propertyName, "Cannot access indexed value in property referenced in indexed property path '" + propertyName + "'", (Throwable)ex);
            }
            String key = tokens.keys[tokens.keys.length - 1];
            if (propValue == null) {
                throw new NullValueInNestedPathException(this.getRootClass(), String.valueOf(this.nestedPath) + propertyName, "Cannot access indexed value in property referenced in indexed property path '" + propertyName + "': returned null");
            }
            if (propValue.getClass().isArray()) {
                Class<?> requiredType = propValue.getClass().getComponentType();
                int arrayIndex = Integer.parseInt(key);
                Object oldValue = null;
                try {
                    if (this.extractOldValueForEditor) {
                        oldValue = Array.get(propValue, arrayIndex);
                    }
                    Object convertedValue = this.doTypeConversionIfNecessary(propertyName, propertyName, oldValue, newValue, requiredType);
                    Array.set(propValue, Integer.parseInt(key), convertedValue);
                    return;
                }
                catch (IllegalArgumentException ex) {
                    PropertyChangeEvent pce = new PropertyChangeEvent(this.rootObject.value, String.valueOf(this.nestedPath) + propertyName, oldValue, newValue);
                    throw new TypeMismatchException(pce, requiredType, (Throwable)ex);
                }
                catch (IndexOutOfBoundsException ex) {
                    throw new InvalidPropertyException(this.getRootClass(), String.valueOf(this.nestedPath) + propertyName, "Invalid array index in property path '" + propertyName + "'", (Throwable)ex);
                }
            }
            if (propValue instanceof List) {
                List list = (List)((Object)propValue);
                int index = Integer.parseInt(key);
                Object oldValue = null;
                if (this.extractOldValueForEditor && index < list.size()) {
                    oldValue = list.get(index);
                }
                Object convertedValue = this.doTypeConversionIfNecessary(propertyName, propertyName, oldValue, newValue, null);
                if (index < list.size()) {
                    list.set(index, convertedValue);
                    return;
                }
                if (index < list.size()) return;
                int i = list.size();
                while (i < index) {
                    try {
                        list.add(null);
                    }
                    catch (NullPointerException ex) {
                        throw new InvalidPropertyException(this.getRootClass(), String.valueOf(this.nestedPath) + propertyName, "Cannot set element with index " + index + " in List of size " + list.size() + ", accessed using property path '" + propertyName + "': List does not support filling up gaps with null elements");
                    }
                    ++i;
                }
                list.add(convertedValue);
                return;
            }
            if (!(propValue instanceof Map)) throw new InvalidPropertyException(this.getRootClass(), String.valueOf(this.nestedPath) + propertyName, "Property referenced in indexed property path '" + propertyName + "' is neither an array nor a List nor a Map; returned value was [" + newValue + PROPERTY_KEY_SUFFIX);
            Map map = (Map)((Object)propValue);
            Object oldValue = null;
            if (this.extractOldValueForEditor) {
                oldValue = map.get(key);
            }
            Object convertedValue = this.doTypeConversionIfNecessary(propertyName, propertyName, oldValue, newValue, null);
            map.put(key, convertedValue);
            return;
        }
        PropertyDescriptor pd = this.getPropertyDescriptorInternal(propertyName);
        if (pd == null || pd.getWriteMethod() == null) {
            throw new NotWritablePropertyException(this.getRootClass(), String.valueOf(this.nestedPath) + propertyName);
        }
        Method readMethod = pd.getReadMethod();
        Method writeMethod = pd.getWriteMethod();
        Object oldValue = null;
        if (this.extractOldValueForEditor && readMethod != null) {
            try {
                oldValue = readMethod.invoke((Object)this.propertyInfo, new Object[0]);
            }
            catch (Exception ex) {
                logger.debug((Object)("Could not read previous value of property '" + this.nestedPath + propertyName), (Throwable)ex);
            }
        }
        try {
            Object convertedValue = this.doTypeConversionIfNecessary(propertyName, propertyName, oldValue, newValue, pd.getPropertyType());
            if (pd.getPropertyType().isPrimitive() && (convertedValue == null || "".equals(convertedValue))) {
                throw new IllegalArgumentException("Invalid value [" + newValue + "] for property '" + pd.getName() + "' of primitive type [" + pd.getPropertyType() + PROPERTY_KEY_SUFFIX);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("About to invoke write method [" + writeMethod + "] on object of class [" + this.propertyInfo.getClass().getName() + PROPERTY_KEY_SUFFIX));
            }
            writeMethod.invoke((Object)this.propertyInfo, convertedValue);
            if (!logger.isDebugEnabled()) return;
            logger.debug((Object)("Invoked write method [" + writeMethod + "] with value of type [" + pd.getPropertyType().getName() + PROPERTY_KEY_SUFFIX));
            return;
        }
        catch (InvocationTargetException ex) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.rootObject.value, String.valueOf(this.nestedPath) + propertyName, oldValue, newValue);
            if (!(ex.getTargetException() instanceof ClassCastException)) throw new MethodInvocationException(propertyChangeEvent, ex.getTargetException());
            throw new TypeMismatchException(propertyChangeEvent, pd.getPropertyType(), ex.getTargetException());
        }
        catch (IllegalArgumentException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.rootObject.value, String.valueOf(this.nestedPath) + propertyName, oldValue, newValue);
            throw new TypeMismatchException(pce, pd.getPropertyType(), (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.rootObject.value, String.valueOf(this.nestedPath) + propertyName, oldValue, newValue);
            throw new MethodInvocationException(pce, (Throwable)ex);
        }
    }

    public void setPropertyValue(PropertyValue pv) throws BeansException {
        this.setPropertyValue(pv.getName(), pv.getValue());
    }

    public void setPropertyValues(Map map) throws BeansException {
        this.setPropertyValues((PropertyValues)new MutablePropertyValues(map));
    }

    public void setPropertyValues(PropertyValues pvs) throws BeansException {
        this.setPropertyValues(pvs, false);
    }

    public void setPropertyValues(PropertyValues propertyValues, boolean ignoreUnknown) throws BeansException {
        ArrayList<PropertyAccessException> propertyAccessExceptions = new ArrayList<PropertyAccessException>();
        PropertyValue[] pvs = propertyValues.getPropertyValues();
        int i = 0;
        while (i < pvs.length) {
            try {
                this.setPropertyValue(pvs[i]);
            }
            catch (NotWritablePropertyException ex) {
                if (!ignoreUnknown) {
                    throw ex;
                }
            }
            catch (PropertyAccessException ex) {
                propertyAccessExceptions.add(ex);
            }
            ++i;
        }
        if (!propertyAccessExceptions.isEmpty()) {
            PropertyAccessException[] paeArray = propertyAccessExceptions.toArray(new PropertyAccessException[propertyAccessExceptions.size()]);
            throw new PropertyAccessExceptionsException(null, paeArray);
        }
    }

    private PropertyChangeEvent createPropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        return new PropertyChangeEvent(this.rootObject != null ? this.rootObject : "constructor", propertyName != null ? String.valueOf(this.nestedPath) + propertyName : null, oldValue, newValue);
    }

    public Object doTypeConversionIfNecessary(Object newValue, Class requiredType) throws TypeMismatchException {
        return this.doTypeConversionIfNecessary(null, null, null, newValue, requiredType);
    }

    protected Object doTypeConversionIfNecessary(String propertyName, String fullPropertyName, Object oldValue, Object newValue, Class requiredType) throws TypeMismatchException {
        PropertyEditor pe;
        Object convertedValue = newValue;
        if (convertedValue != null && ((pe = this.findCustomEditor(requiredType, fullPropertyName)) != null || requiredType != null && (requiredType.isArray() || !requiredType.isAssignableFrom(convertedValue.getClass())))) {
            if (requiredType != null && pe == null && (pe = (PropertyEditor)this.defaultEditors.get(requiredType)) == null) {
                pe = PropertyEditorManager.findEditor(requiredType);
            }
            if (pe != null && !(convertedValue instanceof String)) {
                try {
                    pe.setValue(convertedValue);
                    Object newConvertedValue = pe.getValue();
                    if (newConvertedValue != convertedValue) {
                        convertedValue = newConvertedValue;
                        pe = null;
                    }
                }
                catch (IllegalArgumentException ex) {
                    throw new TypeMismatchException(this.createPropertyChangeEvent(fullPropertyName, oldValue, newValue), requiredType, (Throwable)ex);
                }
            }
            if (requiredType != null && !requiredType.isArray() && convertedValue instanceof String[]) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Converting String array to comma-delimited String [" + convertedValue + PROPERTY_KEY_SUFFIX));
                }
                convertedValue = StringUtils.arrayToCommaDelimitedString((Object[])((String[])convertedValue));
            }
            if (pe != null && convertedValue instanceof String) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Converting String to [" + requiredType + "] using property editor [" + pe + PROPERTY_KEY_SUFFIX));
                }
                try {
                    pe.setValue(oldValue);
                    pe.setAsText((String)convertedValue);
                    convertedValue = pe.getValue();
                }
                catch (IllegalArgumentException ex) {
                    throw new TypeMismatchException(this.createPropertyChangeEvent(fullPropertyName, oldValue, newValue), requiredType, (Throwable)ex);
                }
            }
            if (requiredType != null) {
                if (requiredType.isArray()) {
                    Class<?> componentType = requiredType.getComponentType();
                    if (convertedValue instanceof Collection) {
                        Collection coll = (Collection)convertedValue;
                        Object result = Array.newInstance(componentType, coll.size());
                        int i = 0;
                        Iterator it = coll.iterator();
                        while (it.hasNext()) {
                            Object value = this.doTypeConversionIfNecessary(propertyName, String.valueOf(propertyName) + PROPERTY_KEY_PREFIX + i + PROPERTY_KEY_SUFFIX, null, it.next(), componentType);
                            Array.set(result, i, value);
                            ++i;
                        }
                        return result;
                    }
                    if (convertedValue != null && convertedValue.getClass().isArray()) {
                        int arrayLength = Array.getLength(convertedValue);
                        Object result = Array.newInstance(componentType, arrayLength);
                        int i = 0;
                        while (i < arrayLength) {
                            Object value = this.doTypeConversionIfNecessary(propertyName, String.valueOf(propertyName) + PROPERTY_KEY_PREFIX + i + PROPERTY_KEY_SUFFIX, null, Array.get(convertedValue, i), componentType);
                            Array.set(result, i, value);
                            ++i;
                        }
                        return result;
                    }
                    Object result = Array.newInstance(componentType, 1);
                    Object value = this.doTypeConversionIfNecessary(propertyName, String.valueOf(propertyName) + PROPERTY_KEY_PREFIX + 0 + PROPERTY_KEY_SUFFIX, null, convertedValue, componentType);
                    Array.set(result, 0, value);
                    return result;
                }
                if (convertedValue != null && !requiredType.isPrimitive() && !requiredType.isAssignableFrom(convertedValue.getClass())) {
                    if (convertedValue instanceof String) {
                        try {
                            Field enumField = requiredType.getField((String)convertedValue);
                            return enumField.get(null);
                        }
                        catch (Exception ex) {
                            logger.debug((Object)("Field [" + convertedValue + "] isn't an enum value"), (Throwable)ex);
                        }
                    }
                    throw new TypeMismatchException(this.createPropertyChangeEvent(fullPropertyName, oldValue, newValue), requiredType);
                }
            }
        }
        return convertedValue;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.cachedIntrospectionResults.getBeanInfo().getPropertyDescriptors();
    }

    public PropertyDescriptor getPropertyDescriptor(String propertyName) throws BeansException {
        if (propertyName == null) {
            throw new IllegalArgumentException("Can't find property descriptor for <code>null</code> property");
        }
        PropertyDescriptor pd = this.getPropertyDescriptorInternal(propertyName);
        if (pd != null) {
            return pd;
        }
        throw new InvalidPropertyException(this.getRootClass(), String.valueOf(this.nestedPath) + propertyName, "No property '" + propertyName + "' found");
    }

    protected PropertyDescriptor getPropertyDescriptorInternal(String propertyName) throws BeansException {
        PropertyDescriptorBeanWrapper nestedBw = this.getBeanWrapperForPropertyPath(propertyName);
        return nestedBw.cachedIntrospectionResults.getPropertyDescriptor(this.getFinalPath(nestedBw, propertyName));
    }

    public Class getPropertyType(String propertyName) throws BeansException {
        try {
            PropertyDescriptor pd = this.getPropertyDescriptorInternal(propertyName);
            if (pd != null) {
                return pd.getPropertyType();
            }
            PropertyInfo value = this.getPropertyInfo(propertyName);
            if (value != null) {
                return value.getClass();
            }
            if (this.customEditors != null) {
                CustomEditorHolder editorHolder = (CustomEditorHolder)this.customEditors.get(propertyName);
                if (editorHolder == null) {
                    LinkedList strippedPaths = new LinkedList();
                    this.addStrippedPropertyPaths(strippedPaths, "", propertyName);
                    Iterator it = strippedPaths.iterator();
                    while (it.hasNext() && editorHolder == null) {
                        String strippedName = (String)it.next();
                        editorHolder = (CustomEditorHolder)this.customEditors.get(strippedName);
                    }
                }
                if (editorHolder != null) {
                    return editorHolder.getRegisteredType();
                }
            }
        }
        catch (InvalidPropertyException invalidPropertyException) {
            // empty catch block
        }
        return null;
    }

    public boolean isReadableProperty(String propertyName) {
        block5: {
            if (propertyName == null) {
                throw new IllegalArgumentException("Can't find readability status for <code>null</code> property");
            }
            PropertyDescriptor pd = this.getPropertyDescriptorInternal(propertyName);
            if (pd == null) break block5;
            if (pd.getReadMethod() != null) {
                return true;
            }
        }
        try {
            this.getPropertyInfo(propertyName);
            return true;
        }
        catch (InvalidPropertyException invalidPropertyException) {
            // empty catch block
        }
        return false;
    }

    public boolean isWritableProperty(String propertyName) {
        block5: {
            if (propertyName == null) {
                throw new IllegalArgumentException("Can't find writability status for <code>null</code> property");
            }
            PropertyDescriptor pd = this.getPropertyDescriptorInternal(propertyName);
            if (pd == null) break block5;
            if (pd.getWriteMethod() != null) {
                return true;
            }
        }
        try {
            this.getPropertyInfo(propertyName);
            return true;
        }
        catch (InvalidPropertyException invalidPropertyException) {
            // empty catch block
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PropertyDescriptorBeanWrapper: wrapping class [");
        sb.append(this.getWrappedClass().getName()).append(PROPERTY_KEY_SUFFIX);
        return sb.toString();
    }

    public Type getType() {
        return this.propertyInfo.type;
    }

    public Annotation[] getAnnotations() {
        return this.propertyInfo.annotations;
    }

    public void setType(Class beanClass) {
        if (this.propertyInfo == null) {
            this.propertyInfo = new PropertyInfo();
        }
        this.propertyInfo.type = beanClass;
        this.propertyInfo.clazz = beanClass;
        this.propertyInfo.value = null;
        this.setIntrospectionClass(beanClass);
    }

    public IndexValueResolver getIndexValueResolver() {
        return this.indexValueResolver;
    }

    public void setIndexValueResolver(IndexValueResolver valueindexValueResolver) {
        this.indexValueResolver = valueindexValueResolver;
    }

    private static class CustomEditorHolder {
        private final PropertyEditor propertyEditor;
        private final Class registeredType;

        private CustomEditorHolder(PropertyEditor propertyEditor, Class registeredType) {
            this.propertyEditor = propertyEditor;
            this.registeredType = registeredType;
        }

        private PropertyEditor getPropertyEditor() {
            return this.propertyEditor;
        }

        private Class getRegisteredType() {
            return this.registeredType;
        }

        private PropertyEditor getPropertyEditor(Class requiredType) {
            if (this.registeredType == null || requiredType != null && (BeanUtils.isAssignable((Class)this.registeredType, (Class)requiredType) || BeanUtils.isAssignable((Class)requiredType, (Class)this.registeredType)) || requiredType == null && !Collection.class.isAssignableFrom(this.registeredType) && !this.registeredType.isArray()) {
                return this.propertyEditor;
            }
            return null;
        }
    }

    private static class PropertyTokenHolder {
        private String canonicalName;
        private String actualName;
        private String[] keys;

        private PropertyTokenHolder() {
        }
    }
}

