/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.authorization.report;

import br.com.linkcom.neo.authorization.Authorization;
import br.com.linkcom.neo.authorization.AuthorizationItem;
import br.com.linkcom.neo.authorization.AuthorizationModuleSupport;
import br.com.linkcom.neo.authorization.Permission;
import br.com.linkcom.neo.authorization.report.ReportAuthorization;
import br.com.linkcom.neo.authorization.report.ReportAuthorizer;
import br.com.linkcom.neo.exception.InconsistencyException;

public class ReportAuthorizationModule
extends AuthorizationModuleSupport {
    public static final String RELATORIOS = "Relat\u00f3rios";
    protected static final String GENERATE = "generate";

    public ReportAuthorization createAuthorization(Permission[] permissoes) {
        boolean canGenerate = false;
        Permission[] permissionArray = permissoes;
        int n = permissoes.length;
        int n2 = 0;
        while (n2 < n) {
            Permission permission = permissionArray[n2];
            try {
                if (canGenerate) break;
                canGenerate = permission.getPermissionvalue(GENERATE).equals("true");
            }
            catch (Exception e) {
                throw new InconsistencyException("Inconsistencia no objeto Permission! Faltando parametro (generate): " + permission);
            }
            ++n2;
        }
        ReportAuthorization authorization = new ReportAuthorization();
        authorization.setCanGenerate(canGenerate);
        return authorization;
    }

    public boolean isAuthorized(String acao, Authorization autorizacao) {
        return ReportAuthorizer.getInstance().isAuthorized(acao, autorizacao);
    }

    public AuthorizationItem[] getAuthorizationItens() {
        return new AuthorizationItem[]{new AuthorizationItem(GENERATE, "gerar", new String[]{"true", "false"})};
    }

    public String getAuthorizationGroupName() {
        return RELATORIOS;
    }
}

