/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.authorization;

import br.com.linkcom.neo.authorization.AuthorizationCheckerResolver;
import br.com.linkcom.neo.authorization.User;
import br.com.linkcom.neo.core.standard.Neo;
import br.com.linkcom.neo.core.web.DefaultWebRequestContext;
import br.com.linkcom.neo.core.web.NeoWeb;
import br.com.linkcom.neo.core.web.WebApplicationContext;
import br.com.linkcom.neo.exception.NeoException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AuthorizationChecker {
    protected static final String DTD_LOCATION = "br/com/linkcom/neo/core/config/security-constraints.dtd";
    protected ClassLoader classLoader = this.getClass().getClassLoader();
    private static String NODE_MODULE = "module";
    private static String ATTRIBUTE_MODULENAME = "name";
    private static String NODE_RULE = "rule";
    public static HashMap<String, List<String>> PERMISSION_CACHE;

    public boolean hasPermission(HttpServletRequest request, User user) {
        if (request == null || user == null) {
            return false;
        }
        this.loadPermissions();
        DefaultWebRequestContext requestContext = (DefaultWebRequestContext)NeoWeb.getRequestContext();
        String currentModule = requestContext.getCurrentModule();
        List<String> list = PERMISSION_CACHE.get(currentModule);
        if (list == null || list.size() <= 0) {
            return false;
        }
        boolean isUserInRole = false;
        for (String string : list) {
            if (!requestContext.hasRole(string)) continue;
            isUserInRole = true;
            break;
        }
        return isUserInRole;
    }

    private void loadPermissions() {
        PERMISSION_CACHE = null;
        if (PERMISSION_CACHE == null) {
            PERMISSION_CACHE = new HashMap();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                ServletContext servletContext = ((WebApplicationContext)NeoWeb.getApplicationContext()).getServletContext();
                String xmlSecurityRules = Neo.getApplicationContext().getConfig().getAuthenticationConfig().getXmlSecurityRules();
                InputStream stream = servletContext.getResourceAsStream(xmlSecurityRules);
                if (stream == null) {
                    throw new NeoException("O arquivo de configura\u00e7\u00e3o da autoriza\u00e7\u00e3o n\u00e3o foi encontrado. [" + xmlSecurityRules + "]");
                }
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                documentBuilder.setEntityResolver(new AuthorizationCheckerResolver(this.classLoader));
                Document document = documentBuilder.parse(stream);
                Element element = document.getDocumentElement();
                NodeList moduleNode = element.getElementsByTagName(NODE_MODULE);
                int i = 0;
                while (i < moduleNode.getLength()) {
                    Element module = (Element)moduleNode.item(i);
                    NodeList ruleNode = module.getElementsByTagName(NODE_RULE);
                    ArrayList<String> ruleList = new ArrayList<String>();
                    int j = 0;
                    while (j < ruleNode.getLength()) {
                        ruleList.add(ruleNode.item(j).getTextContent());
                        ++j;
                    }
                    PERMISSION_CACHE.put(module.getAttribute(ATTRIBUTE_MODULENAME), ruleList);
                    ++i;
                }
                stream.close();
            }
            catch (SAXException e) {
                throw new NeoException("Erro no processamento da leitura dos m\u00f3dulos", e);
            }
            catch (ParserConfigurationException e) {
                throw new NeoException("O arquivo de configura\u00e7\u00e3o da autoriza\u00e7\u00e3o n\u00e3o \u00e9 v\u00e1lido", e);
            }
            catch (IOException e) {
                throw new NeoException("Erro no processamento da leitura dos m\u00f3dulos", e);
            }
        }
    }
}

