/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.authorization;

import br.com.linkcom.neo.authorization.AuthorizationChecker;
import br.com.linkcom.neo.authorization.AuthorizationDAO;
import br.com.linkcom.neo.authorization.User;
import br.com.linkcom.neo.core.config.AuthenticationConfig;
import br.com.linkcom.neo.core.standard.ApplicationContext;
import br.com.linkcom.neo.core.standard.Neo;
import br.com.linkcom.neo.core.web.DefaultWebRequestContext;
import br.com.linkcom.neo.core.web.NeoWeb;
import br.com.linkcom.neo.core.web.WebRequestContext;
import br.com.linkcom.neo.exception.NeoException;
import br.com.linkcom.neo.view.menu.MenuTag;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.jasypt.util.password.StrongPasswordEncryptor;

public class AuthenticationControlFilter
implements Filter {
    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        ApplicationContext applicationContext = Neo.getApplicationContext();
        AuthenticationConfig config = applicationContext.getConfig().getAuthenticationConfig();
        if (config == null) {
            throw new NeoException("As configura\u00e7\u00f5es de autentica\u00e7\u00e3o n\u00e3o foram definidas.");
        }
        if (this.doLogin() && httpServletRequest.getRequestURI().endsWith(config.getLoginMapper())) {
            this.authenticateUser(httpServletRequest, httpServletResponse, chain, config);
        } else {
            WebRequestContext requestContext = NeoWeb.getRequestContext();
            if (requestContext.getUser() == null) {
                this.doAuth(httpServletRequest, httpServletResponse, config);
            } else if (config.getUseStaticModuleAccess().booleanValue()) {
                applicationContext.getAuthorizationManager().loadPermissions(requestContext);
                AuthorizationChecker authorizationChecker = new AuthorizationChecker();
                if (authorizationChecker.hasPermission(httpServletRequest, Neo.getUser())) {
                    chain.doFilter(request, response);
                } else {
                    this.dispachNoPermission(httpServletResponse);
                }
            } else {
                chain.doFilter(request, response);
            }
        }
    }

    public boolean doLogin() {
        return true;
    }

    private void authenticateUser(HttpServletRequest request, HttpServletResponse response, FilterChain chain, AuthenticationConfig config) throws IOException, ServletException {
        Object attribute;
        String username = request.getParameter("username") != null && !request.getParameter("username").equals("") ? request.getParameter("username") : "0";
        String password = request.getParameter("password") != null && !request.getParameter("password").equals("") ? request.getParameter("password") : "0";
        AuthorizationDAO authorizationDAO = (AuthorizationDAO)Neo.getApplicationContext().getBean("authorizationDAO");
        User user = authorizationDAO.findUserByLogin(username);
        if (user != null && this.verifyPassword(user, password)) {
            DefaultWebRequestContext requestContext = (DefaultWebRequestContext)NeoWeb.getRequestContext();
            if ((user = this.updateUserInfo(user, request, response)) == null) {
                this.dispachError(request, response, config);
                return;
            }
            requestContext.setUser(user);
            request.getSession().setAttribute(MenuTag.MENU_CACHE_MAP, null);
            attribute = request.getSession().getAttribute("originator");
            if (attribute == null) {
                attribute = String.valueOf(request.getContextPath()) + config.getIndexPage();
            }
        } else {
            this.dispachError(request, response, config);
            return;
        }
        response.sendRedirect((String)attribute);
    }

    protected boolean verifyPassword(User user, String password) {
        boolean passwordMatch = false;
        boolean updatePassword = false;
        StrongPasswordEncryptor passwordEncryptor = new StrongPasswordEncryptor();
        if (user != null && user.getPassword() != null) {
            if (user.getPassword().matches("[a-zA-Z0-9\\+/]{64}")) {
                if (passwordEncryptor.checkPassword(password, user.getPassword())) {
                    passwordMatch = true;
                }
            } else if (user.getPassword().matches("[0-9a-f]{32}")) {
                updatePassword = true;
                if (DigestUtils.md5Hex((String)password).equals(user.getPassword())) {
                    passwordMatch = true;
                }
            } else {
                updatePassword = true;
                if (user.getPassword().equals(password)) {
                    passwordMatch = true;
                }
            }
        }
        if (passwordMatch) {
            String hashSenha = passwordEncryptor.encryptPassword(user.getPassword());
            if (updatePassword) {
                this.updatePasswordOnDataBase(user, hashSenha);
            }
        }
        return passwordMatch;
    }

    public void doAuth(HttpServletRequest request, HttpServletResponse response, AuthenticationConfig config) throws IOException, ServletException {
        String requestURI = request.getRequestURI();
        String queryString = request.getQueryString() != null ? "?" + request.getQueryString() : "";
        String contextPath = request.getContextPath() != null ? request.getContextPath() : "";
        request.getSession().setAttribute("originator", (Object)(String.valueOf(contextPath) + requestURI.substring(contextPath.length()) + queryString));
        User user = NeoWeb.getRequestContext().getUser();
        if (user == null) {
            this.dispachError(request, response, config, false);
        }
    }

    public User updateUserInfo(User user, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        return user;
    }

    public void updatePasswordOnDataBase(User user, String hashSenha) {
    }

    public void dispachError(HttpServletRequest request, HttpServletResponse response, AuthenticationConfig config) throws IOException, ServletException {
        this.dispachError(request, response, config, true);
    }

    public void dispachError(HttpServletRequest request, HttpServletResponse response, AuthenticationConfig config, Boolean error) throws IOException, ServletException {
        if (error.booleanValue()) {
            request.setAttribute("login_error", (Object)true);
        }
        request.getRequestDispatcher(config.getLoginPage()).forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void dispachNoPermission(HttpServletResponse response) throws IOException, ServletException {
        response.sendError(403);
    }

    public void destroy() {
    }
}

