/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.view.template;

import br.com.linkcom.neo.exception.NeoException;
import br.com.linkcom.neo.util.Util;
import br.com.linkcom.neo.view.BaseTag;
import br.com.linkcom.neo.view.DataGridTag;
import br.com.linkcom.neo.view.PanelGridTag;
import br.com.linkcom.neo.view.template.TemplateTag;

public class PropertyConfigTag
extends TemplateTag {
    public static final String INPUT = "input";
    public static final String OUTPUT = "output";
    public static final String COLUMN = "column";
    public static final String SINGLE = "single";
    public static final String DOUBLE = "double";
    public static final String DOUBLELINE = "doubleline";
    protected String mode = null;
    protected String renderAs = null;
    protected Boolean showLabel = null;
    protected Boolean disabled = null;

    public Boolean getShowLabel() {
        return this.showLabel;
    }

    public void setShowLabel(Boolean showLabel) {
        this.showLabel = showLabel;
    }

    public String getMode() {
        return this.mode;
    }

    public String getRenderAs() {
        return this.renderAs;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setRenderAs(String renderAs) {
        this.renderAs = renderAs;
    }

    protected void doComponent() throws Exception {
        PropertyConfigTag parent = this.findParent(PropertyConfigTag.class);
        BaseTag findFirst = this.findFirst(PropertyConfigTag.class, PanelGridTag.class, DataGridTag.class);
        if (Util.strings.isNotEmpty(this.mode)) {
            this.mode = this.mode.toLowerCase();
            if (!INPUT.equals(this.mode) && !OUTPUT.equals(this.mode)) {
                throw new NeoException("A tag propertyConfig s\u00f3 aceita no atributo 'mode' os seguintes valores: input ou output. Valor encontrado: " + this.mode);
            }
        } else if (parent != null) {
            this.mode = parent.getMode();
        }
        if (Util.strings.isNotEmpty(this.renderAs)) {
            this.renderAs = this.renderAs.toLowerCase();
            if (!(COLUMN.equals(this.renderAs) || SINGLE.equals(this.renderAs) || DOUBLE.equals(this.renderAs) || DOUBLELINE.equals(this.renderAs))) {
                throw new NeoException("A tag propertyConfig s\u00f3 aceita no atributo 'renderAs' os seguintes valores: column, single, double ou doubleline. Valor encontrado: " + this.renderAs);
            }
        } else if (findFirst != null) {
            if (findFirst instanceof PropertyConfigTag) {
                this.renderAs = ((PropertyConfigTag)findFirst).getRenderAs();
            } else if (findFirst instanceof PanelGridTag) {
                Boolean propertyRenderAsDouble = ((PanelGridTag)findFirst).getPropertyRenderAsDouble();
                this.renderAs = propertyRenderAsDouble != null ? (propertyRenderAsDouble.booleanValue() ? DOUBLE : SINGLE) : null;
            } else if (findFirst instanceof DataGridTag) {
                this.renderAs = COLUMN;
            }
        }
        if (this.showLabel == null && DOUBLE.equals(this.renderAs)) {
            this.showLabel = false;
        }
        if (this.showLabel == null && parent != null) {
            this.showLabel = parent.getShowLabel();
        }
        if (this.disabled == null && parent != null) {
            this.disabled = parent.getDisabled();
        }
        this.getRequest().setAttribute("propertyConfigDisabled", (Object)this.disabled);
        this.doBody();
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }
}

