/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.view.menu;

import br.com.linkcom.neo.authorization.AuthorizationManager;
import br.com.linkcom.neo.authorization.User;
import br.com.linkcom.neo.core.standard.Neo;
import br.com.linkcom.neo.util.Util;
import br.com.linkcom.neo.view.BaseTag;
import br.com.linkcom.neo.view.menu.Menu;
import br.com.linkcom.neo.view.menu.MenuBuilder;
import br.com.linkcom.neo.view.menu.MenuParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.jsp.JspException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class MenuTag
extends BaseTag {
    public static final String MENU_CACHE_MAP = String.valueOf(MenuTag.class.getName()) + "_cache";
    private static final Log log = LogFactory.getLog(MenuTag.class);
    protected String menupath;

    public String getMenupath() {
        return this.menupath;
    }

    public void setMenupath(String menupath) {
        this.menupath = menupath;
    }

    public void doComponent() throws JspException, IOException {
        String orientation;
        String cachedCode;
        if (this.menupath == null) {
            throw new RuntimeException("A path do menu nao pode ser null");
        }
        String menuCode = null;
        HashMap<String, String> menuCacheMap = (HashMap<String, String>)this.getRequest().getSession().getAttribute(MENU_CACHE_MAP);
        if (menuCacheMap == null) {
            menuCacheMap = new HashMap<String, String>();
            this.getRequest().getSession().setAttribute(MENU_CACHE_MAP, menuCacheMap);
        }
        if ((cachedCode = (String)menuCacheMap.get(this.menupath)) == null) {
            try {
                MenuParser menuParser = new MenuParser();
                menuParser.setUrlPrefix(this.getRequest().getContextPath());
                Menu menu = menuParser.parse(this.getServletContext().getResourceAsStream(this.getMenupath()));
                orientation = menu.getOrientation();
                AuthorizationManager authorizationManager = Neo.getApplicationContext().getAuthorizationManager();
                User user = Neo.getRequestContext().getUser();
                this.verificarAutorizacao(menu, authorizationManager, user);
                this.removeEmptyMenus(menu);
                MenuBuilder menuBuilder = new MenuBuilder();
                menuCode = menuBuilder.build(menu);
                menuCacheMap.put(this.menupath, String.valueOf(orientation) + "<!>" + menuCode);
            }
            catch (ParserConfigurationException e) {
                throw new JspException("Erro de parsing ao ler XML do menu. ", (Throwable)e);
            }
            catch (SAXException e) {
                throw new JspException("Erro de SAX ao ler XML do menu. ", (Throwable)e);
            }
            catch (IOException e) {
                throw new JspException("Erro de leitura (I/O) ao ler XML do menu. ", (Throwable)e);
            }
            catch (Exception e) {
                throw new RuntimeException("Erro ao gerar menu " + this.menupath, e);
            }
        } else {
            log.debug((Object)("Using cached menu... " + this.menupath));
            int separator = cachedCode.indexOf("<!>");
            menuCode = cachedCode.substring(separator + 3);
            orientation = cachedCode.substring(0, separator);
        }
        String menuId = this.generateUniqueId();
        String divId = this.generateUniqueId();
        menuCode = "var " + menuId + " = \n" + menuCode + ";";
        String drawCode = "cmDraw ('" + divId + "', " + menuId + ", '" + orientation + "', cmThemeOffice, 'ThemeOffice');";
        this.getOut().print("<span class=\"menuClass\" id=\"" + divId + "\">");
        this.getOut().print("</span>");
        this.getOut().println("<script language=\"JavaScript\">");
        this.getOut().println(menuCode);
        this.getOut().println(drawCode);
        this.getOut().println("</script>");
    }

    private void removeEmptyMenus(Menu menu) {
        Menu parent2;
        if (menu.getSubmenus().size() > 0) {
            int i = 0;
            while (i < menu.getSubmenus().size()) {
                Menu submenu = menu.getSubmenus().get(i);
                this.removeEmptyMenus(submenu);
                if (!menu.getSubmenus().contains(submenu)) {
                    --i;
                }
                ++i;
            }
        }
        if (menu.getSubmenus().size() == 0 && Util.strings.isEmpty(menu.getUrl()) && menu.getTitle() != null && !menu.getTitle().matches("--(-)+") && (parent2 = menu.getParent()) != null) {
            parent2.getSubmenus().remove(menu);
        }
    }

    private void verificarAutorizacao(Menu menu, AuthorizationManager authorizationManager, User user) {
        int length = this.getRequest().getContextPath().length();
        Iterator<Menu> iter = menu.getSubmenus().iterator();
        while (iter.hasNext()) {
            Menu submenu = iter.next();
            String url = submenu.getUrl();
            if (!StringUtils.isEmpty((String)url)) {
                if (url.contains("?")) {
                    url = url.substring(0, url.indexOf(63));
                }
                if (!authorizationManager.isAuthorized(url.substring(length), null, user)) {
                    iter.remove();
                    continue;
                }
            }
            this.verificarAutorizacao(submenu, authorizationManager, user);
        }
    }
}

