/*
 * Decompiled with CFR 0.152.
 */
package br.com.linkcom.neo.view;

import br.com.linkcom.neo.core.standard.Neo;
import br.com.linkcom.neo.exception.NeoException;
import br.com.linkcom.neo.util.Util;
import br.com.linkcom.neo.view.BaseTag;
import br.com.linkcom.neo.view.DataGridTag;
import br.com.linkcom.neo.view.FormTag;
import br.com.linkcom.neo.view.template.PropertyConfigTag;

public class SubmitTag
extends BaseTag {
    protected String url;
    protected String action = "";
    protected String img;
    protected String description;
    protected String type;
    protected String parameters;
    protected Boolean validate;
    protected String confirmationScript;
    protected String onclick;

    public String getOnclick() {
        return this.onclick;
    }

    protected void doComponent() throws Exception {
        Tipo tipo;
        boolean hasAuthorization = this.hasAuthorization();
        this.url = this.montarUrlCompleta();
        if (!hasAuthorization) {
            this.getOut().println("<!-- Sem autoriza\u00e7\u00e3o para acessar: " + this.url + "-->");
            return;
        }
        FormTag form = this.findParent(FormTag.class, true);
        String formName = form.getName();
        String submitFunction = form.getSubmitFunction();
        this.onclick = !this.url.startsWith("javascript:") ? (this.validate != null ? String.valueOf(formName) + ".action = '" + this.url + "'; " + formName + ".validate = '" + this.validate + "'; " + submitFunction + "()" : String.valueOf(formName) + ".action = '" + this.url + "'; " + submitFunction + "()") : this.url.substring("javascript:".length());
        if (this.getDynamicAttributesMap().get("onclick") != null) {
            this.onclick = this.getDynamicAttributesMap().get("onclick") + ";" + this.onclick;
            this.getDynamicAttributesMap().remove("onclick");
        }
        if (this.confirmationScript != null && this.confirmationScript.trim().length() > 0) {
            if (this.confirmationScript.contains(";")) {
                throw new NeoException("O confirmationScript n\u00e3o pode conter ';' Ele deve ser uma express\u00e3o (ou chamada de fun\u00e7\u00e3o) booleana. Se a express\u00e3o retornar true o submit ser\u00e1 executado. confirmationScriptEncontrado: " + this.confirmationScript);
            }
            this.onclick = "if (" + this.confirmationScript + ") {" + this.onclick + "}";
        }
        if (this.action != null) {
            this.action = String.valueOf(formName) + "." + "ACAO" + ".value ='" + this.action + "';";
        }
        if ((tipo = this.definirTipo()) == Tipo.BUTTON) {
            boolean disabled = "disabled".equals(this.getDynamicAttributesMap().get("disabled"));
            boolean enabled = "false".equals(this.getDynamicAttributesMap().get("disabled"));
            if (!enabled) {
                PropertyConfigTag propertyConfig = this.findParent(PropertyConfigTag.class);
                DataGridTag dataGridTag = this.findParent(DataGridTag.class);
                if (propertyConfig != null && Boolean.TRUE.equals(propertyConfig.getDisabled()) && (dataGridTag == null || dataGridTag.getCurrentStatus() != DataGridTag.Status.DYNALINE)) {
                    if (disabled) {
                        this.getDynamicAttributesMap().put("originaldisabled", "disabled");
                    }
                    this.getDynamicAttributesMap().put("disabled", "disabled");
                }
            } else {
                this.getDynamicAttributesMap().remove("disabled");
            }
        }
        switch (tipo) {
            case IMAGE: {
                this.includeTextTemplate("image");
                break;
            }
            case BUTTON: {
                this.includeTextTemplate("button");
                break;
            }
            case LINK: {
                this.includeTextTemplate("link");
            }
        }
    }

    private boolean hasAuthorization() {
        try {
            return Neo.getApplicationContext().getAuthorizationManager().isAuthorized(this.getPartialURL(), this.action, Neo.getRequestContext().getUser());
        }
        catch (Exception e) {
            throw new NeoException("Problema ao verificar autoriza\u00e7\u00e3o", e);
        }
    }

    private String getPartialURL() {
        if (this.url != null && this.url.startsWith(this.getRequest().getContextPath())) {
            return this.url.substring(this.getRequest().getContextPath().length());
        }
        String fullUrl = this.url == null ? Util.web.getFirstUrl() : (this.url.startsWith("/") ? this.url : this.url);
        return fullUrl;
    }

    private Tipo definirTipo() {
        Tipo tipo = Tipo.BUTTON;
        if ("link".equalsIgnoreCase(this.type)) {
            tipo = Tipo.LINK;
        }
        if (this.img != null) {
            tipo = Tipo.IMAGE;
        }
        return tipo;
    }

    private String montarUrlCompleta() {
        String separator;
        if (this.url != null && this.url.startsWith("javascript:")) {
            return this.url;
        }
        if (this.action != null && this.action.startsWith("javascript:")) {
            this.url = this.action;
            this.action = null;
            return this.url;
        }
        String fullUrl = this.url == null ? Util.web.getFirstFullUrl() : (this.url.startsWith("/") ? Util.web.getFullUrl(this.getRequest(), this.url) : this.url);
        String string = separator = fullUrl.contains("?") ? "&" : "?";
        if (this.parameters != null) {
            fullUrl = String.valueOf(fullUrl) + separator + this.parameters.replace(";", "&");
        }
        return fullUrl;
    }

    public String getAction() {
        return this.action;
    }

    public String getDescription() {
        return this.description;
    }

    public String getImg() {
        return this.img;
    }

    public String getParameters() {
        return this.parameters;
    }

    public String getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setImg(String img) {
        this.img = img;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Boolean getValidate() {
        return this.validate;
    }

    public void setValidate(Boolean validate) {
        this.validate = validate;
    }

    public String getConfirmationScript() {
        return this.confirmationScript;
    }

    public void setConfirmationScript(String confirmationScript) {
        this.confirmationScript = confirmationScript;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Tipo {
        BUTTON,
        IMAGE,
        LINK;

    }
}

